/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.tcloud.exceptions.CustomException;
import com.tcloud.logic.entity.InstanciaMetricas;
import com.tcloud.logic.entity.request.EBSRequest;
import com.tcloud.logic.entity.request.EC2Request;
import com.tcloud.logic.entity.request.LoadBalancerRequest;
import com.tcloud.logic.entity.request.VPNRequest;
import com.tcloud.logic.entity.request.WAFRequest;
import com.tcloud.logic.service.TenansService;
import com.tcloud.logic.service.impl.AuthenticationServiceImpl;
import com.tcloud.repository.AwsCredentialDAO;
import com.tcloud.repository.EmpresaDAO;
import com.tcloud.repository.ServiceDAO;
import com.tcloud.utils.ApiResponse;
import com.tcloud.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class TenansServiceImpl
implements TenansService {
    private static final Logger log = LoggerFactory.getLogger(TenansServiceImpl.class);
    @Value(value="${back.python.path}")
    private String pythonEndpoint;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private AwsCredentialDAO awsCredentialDAO;
    @Autowired
    private ServiceDAO serviceDAO;
    @Autowired
    private AuthenticationServiceImpl authService;

    public ResponseEntity<ApiResponse<?>> getEC2DiskRead(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/diskread";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerRequestCount(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/request_count";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER Request Count", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerTargetResponseTime(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/target_response_time";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER Target Response Time", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp2xxCount(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/http_2xx_count";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER http_2xx_count", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp3xxCount(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/http_3xx_count";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER http_3xx_count", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp4xxCount(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/http_4xx_count";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER http_4xx_count", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getLoadBalancerActiveConnectionCount(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/load_balancer/active_connection_count";
            Map result = this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codEmpresa);
            LoadBalancerRequest loadBRequest = new LoadBalancerRequest();
            if (result != null && !result.isEmpty()) {
                loadBRequest.setSecret_key((String)result.get("secretKey"));
                loadBRequest.setRegion((String)result.get("region"));
                loadBRequest.setAccess_key((String)result.get("accessKey"));
                loadBRequest.setLoad_balancer_arn((String)result.get("resourceId"));
                loadBRequest.setEnd_time(fecha2);
                loadBRequest.setStart_time(fecha1);
                loadBRequest.setTime(time);
                loadBRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)loadBRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo LOAD BALANCER active_connection_count", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getWaf(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/waf-allowed";
            Map result = this.serviceDAO.getServiceWAFbyEmpresa(codEmpresa);
            WAFRequest wafRequest = new WAFRequest();
            if (result != null && !result.isEmpty()) {
                wafRequest.setSecret_key((String)result.get("secretKey"));
                wafRequest.setRegion((String)result.get("region"));
                wafRequest.setAccess_key((String)result.get("accessKey"));
                wafRequest.setWeb_acl_id((String)result.get("resourceId"));
                wafRequest.setEnd_time(fecha2);
                wafRequest.setStart_time(fecha1);
                wafRequest.setTime(time);
                wafRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)wafRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo WAF", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolReadOpsByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_read_ops";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getWafAllowed(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/waf-allowed";
            Map result = this.serviceDAO.getServiceACLWAFbyEmpresa(codEmpresa);
            WAFRequest wafRequest = new WAFRequest();
            if (result != null && !result.isEmpty()) {
                wafRequest.setSecret_key((String)result.get("secretKey"));
                wafRequest.setRegion((String)result.get("region"));
                wafRequest.setAccess_key((String)result.get("accessKey"));
                wafRequest.setWeb_acl_id((String)result.get("resourceId"));
                wafRequest.setCountry_code("EC");
                wafRequest.setEnd_time(fecha2);
                wafRequest.setStart_time(fecha1);
                wafRequest.setTime(time);
                wafRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)wafRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo WAF", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getWafBlocked(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/waf-blocked";
            Map result = this.serviceDAO.getServiceACLWAFbyEmpresa(codEmpresa);
            WAFRequest wafRequest = new WAFRequest();
            if (result != null && !result.isEmpty()) {
                wafRequest.setSecret_key((String)result.get("secretKey"));
                wafRequest.setRegion((String)result.get("region"));
                wafRequest.setAccess_key((String)result.get("accessKey"));
                wafRequest.setWeb_acl_id((String)result.get("resourceId"));
                wafRequest.setCountry_code("EC");
                wafRequest.setEnd_time(fecha2);
                wafRequest.setStart_time(fecha1);
                wafRequest.setTime(time);
                wafRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)wafRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo WAF", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getVpnTunnelDataIn(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/vpn/tunnel_data_in";
            Map result = this.serviceDAO.getServiceVPNbyEmpresa(codEmpresa);
            VPNRequest vpnRequest = new VPNRequest();
            if (result != null && !result.isEmpty()) {
                vpnRequest.setSecret_key((String)result.get("secretKey"));
                vpnRequest.setRegion((String)result.get("region"));
                vpnRequest.setAccess_key((String)result.get("accessKey"));
                vpnRequest.setVpn_id((String)result.get("resourceId"));
                vpnRequest.setEnd_time(fecha2);
                vpnRequest.setStart_time(fecha1);
                vpnRequest.setTime(time);
                vpnRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)vpnRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo VPN", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getVpnTunnelDataOut(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/vpn/tunnel_data_out";
            Map result = this.serviceDAO.getServiceVPNbyEmpresa(codEmpresa);
            VPNRequest vpnRequest = new VPNRequest();
            if (result != null && !result.isEmpty()) {
                vpnRequest.setSecret_key((String)result.get("secretKey"));
                vpnRequest.setRegion((String)result.get("region"));
                vpnRequest.setAccess_key((String)result.get("accessKey"));
                vpnRequest.setVpn_id((String)result.get("resourceId"));
                vpnRequest.setEnd_time(fecha2);
                vpnRequest.setStart_time(fecha1);
                vpnRequest.setTime(time);
                vpnRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)vpnRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo VPN", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getVpnTunnelState(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/vpn/tunnel_state";
            Map result = this.serviceDAO.getServiceVPNbyEmpresa(codEmpresa);
            VPNRequest vpnRequest = new VPNRequest();
            if (result != null && !result.isEmpty()) {
                vpnRequest.setSecret_key((String)result.get("secretKey"));
                vpnRequest.setRegion((String)result.get("region"));
                vpnRequest.setAccess_key((String)result.get("accessKey"));
                vpnRequest.setVpn_id((String)result.get("resourceId"));
                vpnRequest.setEnd_time(fecha2);
                vpnRequest.setStart_time(fecha1);
                vpnRequest.setTime(time);
                vpnRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)vpnRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo VPN", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolWriteOpsByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_write_ops";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolReadBytesByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_read_bytes";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolWriteBytesByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_write_bytes";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolTotalReadTimeByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_total_read_time";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolTotalWriteTimeByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_total_write_time";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolIdleTimeByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_idle_time";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolQueueLengthByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_queue_length";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolThroughputPercentageByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/volume_throughput_percentage";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEBSVolBurstBalanceByDate(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ebs/BurstBalance";
            Map result = this.serviceDAO.getServiceEBSbyEmpresa(codEmpresa);
            EBSRequest ebsRequest = new EBSRequest();
            if (result != null && !result.isEmpty()) {
                ebsRequest.setSecret_key((String)result.get("secretKey"));
                ebsRequest.setRegion((String)result.get("region"));
                ebsRequest.setAccess_key((String)result.get("accessKey"));
                ebsRequest.setVolume_id((String)result.get("resourceId"));
                ebsRequest.setEnd_time(fecha2);
                ebsRequest.setStart_time(fecha1);
                ebsRequest.setTime(time);
                ebsRequest.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ebsRequest, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EBS", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2Categorized(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/categorized";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2DiskWrite(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/diskwrite";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2NetworkIn(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/networkin";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2NetworkOut(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/networkout";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2DiskReadBytes(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/diskreadbytes";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2DiskWriteBytes(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/diskwritebytes";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getEC2StatusCheckFailed(String fecha1, String fecha2, long time, String stat) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String url = this.pythonEndpoint + "/metrics/ec2/statuscheckfailed";
            Map result = this.serviceDAO.getServiceEC2byEmpresa(codEmpresa);
            EC2Request ec2Request = new EC2Request();
            if (result != null && !result.isEmpty()) {
                ec2Request.setSecret_key((String)result.get("secretKey"));
                ec2Request.setRegion((String)result.get("region"));
                ec2Request.setAccess_key((String)result.get("accessKey"));
                ec2Request.setInstance_id((String)result.get("resourceId"));
                ec2Request.setEnd_time(fecha2);
                ec2Request.setStart_time(fecha1);
                ec2Request.setTime(time);
                ec2Request.setStat(stat);
            }
            try {
                ResponseEntity response = this.restTemplate.postForEntity(url, (Object)ec2Request, Map.class, new Object[0]);
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)((Map)response.getBody()));
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity<ApiResponse<?>> getAllMetricsServices() {
        String codEmpresa = this.authService.getMyParameter("empresa");
        if (codEmpresa != null) {
            ArrayList<InstanciaMetricas> metricas = new ArrayList<InstanciaMetricas>();
            metricas.add(new InstanciaMetricas("pi pi-hdd", "EBS", 10, "EBS, o Elastic Block Store, es un servicio de almacenamiento de bloques proporcionado por Amazon Web Services (AWS). Est\u00e1 dise\u00f1ado para aplicaciones que requieren acceso persistente y de baja latencia a los datos. EBS permite crear vol\u00famenes de almacenamiento que se pueden conectar a instancias EC2, proporcionando almacenamiento confiable y escalable para datos cr\u00edticos de aplicaciones, bases de datos y archivos de sistema."));
            metricas.add(new InstanciaMetricas("pi pi-shield", "WAF", 2, "WAF, o Web Application Firewall, es un servicio de seguridad que ayuda a proteger las aplicaciones web de amenazas comunes y ataques maliciosos, como inyecciones SQL, scripting entre sitios (XSS), y otros tipos de ataques a nivel de aplicaci\u00f3n. WAF analiza y filtra el tr\u00e1fico entrante en las aplicaciones web en busca de patrones sospechosos, bloqueando solicitudes peligrosas para proteger la integridad de los datos y la infraestructura."));
            metricas.add(new InstanciaMetricas("pi pi-sitemap", "LOAD BALANCER", 5, "Un Load Balancer, o balanceador de carga, distribuye el tr\u00e1fico de red o aplicaci\u00f3n entre varias instancias de servidores para optimizar la utilizaci\u00f3n de recursos, mejorar el rendimiento y garantizar la disponibilidad. Act\u00faa como un punto de entrada \u00fanico y permite que las solicitudes de los usuarios se redirijan autom\u00e1ticamente a las instancias disponibles, lo cual reduce el tiempo de respuesta y evita que una instancia se sobrecargue."));
            metricas.add(new InstanciaMetricas("pi pi-lock", "VPN", 3, "Una VPN, o Red Privada Virtual, permite crear una conexi\u00f3n segura y encriptada entre la red privada de una empresa y recursos externos, como empleados remotos o proveedores. Esta tecnolog\u00eda asegura la transmisi\u00f3n de datos sensibles sobre redes p\u00fablicas, proporcionando un canal seguro para acceder a aplicaciones y datos corporativos sin exponerlos a Internet p\u00fablico"));
            metricas.add(new InstanciaMetricas("pi pi-cloud", "EC2", 8, "EC2, o Elastic Compute Cloud, es un servicio de AWS que proporciona capacidad de c\u00f3mputo escalable en la nube. Permite crear instancias de servidores virtuales que pueden configurarse, gestionarse y redimensionarse de acuerdo a las necesidades de carga de trabajo. EC2 es ideal para aplicaciones que requieren flexibilidad en la capacidad de procesamiento y se adapta a diferentes casos de uso, desde desarrollo y pruebas hasta producci\u00f3n."));
            try {
                ApiResponse apiResponse = ApiResponse.ok((int)200, metricas);
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }
}

