/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.tcloud.exceptions.CustomException;
import com.tcloud.logic.entity.dto.RolesPreguntas;
import com.tcloud.logic.service.RolService;
import com.tcloud.logic.service.impl.AuthenticationServiceImpl;
import com.tcloud.repository.RolDAO;
import com.tcloud.utils.ApiResponse;
import com.tcloud.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service
public class RolServiceImpl
implements RolService {
    private final RolDAO rolesDAO;
    @Autowired
    private AuthenticationServiceImpl authService;

    public ResponseEntity<ApiResponse<?>> obtenerNumeroPreguntasRol(String fecha1, String fecha2, String rol) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (codEmpresa != null) {
            List consumo = this.rolesDAO.obtenerNumeroPreguntasRol(date1, date2);
            try {
                ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)consumo);
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public List<RolesPreguntas> obtenerNumeroPreguntasNoRol(String fecha1, String fecha2) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return null;
    }

    public RolServiceImpl(RolDAO rolesDAO, AuthenticationServiceImpl authService) {
        this.rolesDAO = rolesDAO;
        this.authService = authService;
    }
}

