/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import com.tcloud.logic.entity.ConversacionDetalle;
import com.tcloud.logic.entity.ConversacionUsuario;
import com.tcloud.logic.entity.DocumentFile;
import com.tcloud.logic.entity.Empresa;
import com.tcloud.logic.entity.SeccionDocumento;
import com.tcloud.logic.entity.dto.CredentialRequest;
import com.tcloud.logic.entity.dto.ProcessVoucherDto;
import com.tcloud.logic.entity.dto.RespuestaRobotDTO;
import com.tcloud.logic.service.ImageRecognitionService;
import com.tcloud.logic.service.QuestionMetricService;
import com.tcloud.logic.service.SeccionDocumentoService;
import com.tcloud.logic.service.impl.AuthenticationServiceImpl;
import com.tcloud.logic.service.impl.ChatApiServiceImpl;
import com.tcloud.repository.ConversacionDetalleDAO;
import com.tcloud.repository.DocumentFileDAO;
import com.tcloud.repository.EmpresaDAO;
import com.tcloud.repository.ServiceDAO;
import com.tcloud.utils.Base64Utils;
import com.tcloud.utils.PromptUtils;
import com.tcloud.utils.UtilLhia;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class QuestionMetricsServiceImpl
implements QuestionMetricService {
    private static final Logger log = LoggerFactory.getLogger(QuestionMetricsServiceImpl.class);
    @Autowired
    private AuthenticationServiceImpl authService;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private ChatApiServiceImpl chatApiService;
    @Autowired
    private ImageRecognitionService imageReecongService;
    @Autowired
    private SeccionDocumentoService seccionDocService;
    @Autowired
    private ServiceDAO serviceDAO;
    @Autowired
    private DocumentFileDAO documentFileDAO;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${back.python.path}")
    private String pythonUrl;
    @Value(value="${back.spring.local}")
    private String lhiaDomainUrl;
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    private String textSystem = "";

    public RespuestaRobotDTO findDocumentsByQuestion(String question, String descripcion, String usuario, String identificador) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        Empresa empresa = this.empresaDAO.findByCodigoEmpresa(codEmpresa);
        RespuestaRobotDTO newRespuestaRobotDTO = new RespuestaRobotDTO();
        Object answer = "";
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        String iniTextNew = PromptUtils.getPromptForCompany((String)empresa.getNombreEmpresa());
        conversacionUsuario.add(0, new ConversacionUsuario("system", iniTextNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            switch (c.getRol()) {
                case "user": {
                    conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
                    break;
                }
                case "assistant": {
                    conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
                    break;
                }
            }
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase() + " ";
        String promptPrincipal = pregunta.replaceAll("\n", "");
        String embedding = this.seccionDocService.generateEmbedding(UtilLhia.quitarTildes((String)pregunta.toUpperCase()).replace("\u00bf", "").replace("?", ""));
        List secciones = this.seccionDocService.getPromptsByRole(descripcion);
        double maxSimilarity = -1.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        ArrayList<SeccionDocumento> masSimilar = new ArrayList<SeccionDocumento>();
        for (SeccionDocumento seccion : secciones) {
            double similarity = UtilLhia.cosineSimilarity((String)embedding, (String)seccion.getEmbedding());
            if (!(similarity > maxSimilarity)) continue;
            maxSimilarity = similarity;
            seccion.setScore(maxSimilarity);
            if (!(maxSimilarity >= 0.5)) continue;
            masSimilar.add(seccion);
        }
        if (masSimilar.size() > 0) {
            Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
            Collections.sort(masSimilar, scoreComparator);
            List primerosCinco = masSimilar.subList(0, masSimilar.size());
            StringBuilder resultadoBusqueda = new StringBuilder();
            int count = 0;
            for (SeccionDocumento seccion : primerosCinco) {
                resultadoBusqueda.append("el resultado de la informacion" + count++ + " es el siguiente:\n");
                resultadoBusqueda.append(seccion.getTexto()).append("\n\n");
            }
            scoreFinal = ((SeccionDocumento)masSimilar.get(0)).getScore();
            try {
                newRespuestaRobotDTO = this.obtenerRespuestaHTTP(this.pythonUrl.concat(((SeccionDocumento)masSimilar.get(0)).getUrl_endpoint().toString()), codEmpresa);
                answer = "Los resultados de la busqueda " + newRespuestaRobotDTO.getRespuesta();
                resultadoBusqueda.append("La informaci\u00f2n obtenida es la siguiente:");
                resultadoBusqueda.append((String)answer);
                prompt = (String)prompt + resultadoBusqueda;
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            for (SeccionDocumento seccion : primerosCinco) {
                seccion.setScore(0.0);
            }
        } else {
            prompt = "";
        }
        String promptCompleto = ((String)prompt).concat("pregunta: " + promptPrincipal);
        conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
        answer = this.chatApiService.respondePreguntasV2(conversacionUsuario);
        if (!((String)answer).isEmpty()) {
            this.chatApiService.guardarConversacion(identificador, usuario, descripcion, pregunta, "", promptCompleto, 0.0, 0, this.textSystem);
            this.chatApiService.guardarConversacion(identificador, usuario, "user", pregunta, (String)answer, "", 0.0, this.encoding.countTokens(promptCompleto), this.textSystem);
            this.chatApiService.guardarConversacion(identificador, usuario, "assistant", pregunta, (String)answer, promptCompleto, scoreFinal, this.encoding.countTokens((String)answer), this.textSystem);
        }
        newRespuestaRobotDTO.setRespuesta((String)answer);
        return newRespuestaRobotDTO;
    }

    public RespuestaRobotDTO obtenerRespuestaHTTP(String endpoint, String codigoEmpresa) throws IOException {
        DocumentFile documentFile = new DocumentFile();
        String uniqueFileName = UUID.randomUUID().toString();
        List<String> tiposServicios = Arrays.asList("instance_id", "load_balancer_arn", "volume_id", "web_acl_id", "WebACL", "vpn_id");
        for (String serviceType : tiposServicios) {
            CredentialRequest credential = this.getCredentialsByService(serviceType, codigoEmpresa);
            if (credential.getAccess_key() == null || credential.getSecret_key() == null) continue;
            try {
                ResponseEntity response = this.restTemplate.postForEntity(endpoint, (Object)credential, Map.class, new Object[0]);
                String base64Response = (String)((Map)response.getBody()).get("image_base64");
                documentFile.setName(uniqueFileName.concat(".png"));
                documentFile.setFileData(Base64Utils.convertBase64ToBytes((String)base64Response));
                documentFile = (DocumentFile)this.documentFileDAO.save((Object)documentFile);
                String urlImageToGPT = this.lhiaDomainUrl + "/api/report/image/" + documentFile.getName();
                Optional procesImage = this.imageReecongService.checkImageDocument(urlImageToGPT);
                RespuestaRobotDTO respuesta = new RespuestaRobotDTO();
                respuesta.setRespuesta(((ProcessVoucherDto)procesImage.get()).getDescription());
                respuesta.setUrl(urlImageToGPT);
                return respuesta;
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode().value() == 400) continue;
                throw e;
            }
        }
        throw new RuntimeException("No se encontraron credenciales v\u00e1lidas para la llamada al endpoint: " + endpoint);
    }

    public CredentialRequest getCredentialsByService(String serviceType, String codigoEmpresa) {
        CredentialRequest credential = new CredentialRequest();
        Map result = switch (serviceType) {
            case "instance_id" -> this.serviceDAO.getServiceEC2byEmpresa(codigoEmpresa);
            case "load_balancer_arn" -> this.serviceDAO.getServiceLOADBALANCERbyEmpresa(codigoEmpresa);
            case "volume_id" -> this.serviceDAO.getServiceEBSbyEmpresa(codigoEmpresa);
            case "web_acl_id", "WebACL" -> this.serviceDAO.getServiceACLWAFbyEmpresa(codigoEmpresa);
            case "vpn_id" -> this.serviceDAO.getServiceVPNbyEmpresa(codigoEmpresa);
            default -> throw new IllegalArgumentException("Tipo de servicio no v\u00e1lido: " + serviceType);
        };
        if (result != null && !result.isEmpty()) {
            credential.setService_type(serviceType);
            credential.setSecret_key((String)result.get("secretKey"));
            credential.setRegion((String)result.get("region"));
            credential.setAccess_key((String)result.get("accessKey"));
            credential.setGeneric_id((String)result.get("resourceId"));
        }
        return credential;
    }
}

