/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.tcloud.logic.entity.dto.ProcessVoucherDto;
import com.tcloud.logic.service.ImageRecognitionService;
import com.tcloud.utils.FileAnaliticsUtils;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ImageRecognitionServiceImpl
implements ImageRecognitionService {
    @Value(value="${openai.urlAnswer4}")
    private String urlAnswer4;
    @Value(value="${openai.modelAnswer4}")
    private String modelAnswer4;
    @Value(value="${openai.apiKey}")
    private String apiKey;

    public Optional<ProcessVoucherDto> checkImageDocument(String urlImage) {
        String url = this.urlAnswer4;
        HttpHeaders headers = FileAnaliticsUtils.createHeaders((String)this.apiKey);
        Map requestBody = FileAnaliticsUtils.createRequestBody((String)urlImage, (String)this.modelAnswer4, (int)300);
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (!FileAnaliticsUtils.isJsonResponse((ResponseEntity)response)) {
                System.err.println("Error: Response is not JSON");
                return Optional.empty();
            }
            return Optional.of(FileAnaliticsUtils.processResponse((String)((String)response.getBody())));
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            System.err.println("HTTP error: " + e.getStatusCode() + " - " + e.getResponseBodyAsString());
            System.err.println("Request Body: " + entity.getBody());
        }
        catch (Exception e) {
            System.err.println("General error: " + e.getMessage());
        }
        return Optional.empty();
    }
}

