/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.tcloud.exceptions.CustomException;
import com.tcloud.logic.entity.Conversacion;
import com.tcloud.logic.entity.ConversacionDetalle;
import com.tcloud.logic.entity.ConversacionUsuario;
import com.tcloud.logic.service.ChatApiService;
import com.tcloud.logic.service.impl.AuthenticationServiceImpl;
import com.tcloud.repository.ConversacionDAO;
import com.tcloud.repository.ConversacionDetalleDAO;
import com.tcloud.repository.RolDAO;
import com.tcloud.utils.ApiResponse;
import com.tcloud.utils.DateUtils;
import com.tcloud.utils.UtilLhia;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ChatApiServiceImpl
implements ChatApiService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AuthenticationServiceImpl authService;
    @Autowired
    private ConversacionDetalleDAO conversacioDetDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    @Value(value="${back.python.path}")
    private String pythonUrl;
    @Value(value="${back.python.path}")
    private String urlApiMilvu;
    private String textSystem = "";
    @Autowired
    private ConversacionDAO conversacionRepository;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private RolDAO roleDAO;

    public String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)this.modelAnswer2);
        requestBody.put("max_tokens", 400);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public String respondePreguntasV3(String pregunta, Double temp) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", conversacionUsuario);
        requestBody.put("max_tokens", 240);
        requestBody.put("temperature", temp);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public ResponseEntity<ApiResponse<?>> obtenerTokens(String fecha1, String fecha2) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String totales = this.conversacioDetDAO.obtenerTokens(date1, date2);
            try {
                HashMap<String, String> responsePayload = new HashMap<String, String>();
                responsePayload.put("tokens", totales);
                ApiResponse apiResponse = ApiResponse.ok((int)200, responsePayload);
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }

    public void guardarConversacion(String identificador, String usuario, String rol, String pregunta, String respuesta, String adicional, double score, int tokens, String descripcion) {
        if (this.conversacionRepository.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(descripcion);
                conversacion_detalle.setPregunta(pregunta);
                conversacion_detalle.setMensaje(respuesta);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens((long)tokens);
                conversacion_detalle.setAdicional(adicional);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionRepository.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setRoles(this.roleDAO.findByDescripcion(descripcion));
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionRepository.save((Object)nueva_conversacion);
            conversacion_detalle.setActor("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(this.textSystem);
            conversacion_detalle.setTokens(0L);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseEntity<ApiResponse<?>> archivosGenerados(String fecha1, String fecha2) {
        String codEmpresa = this.authService.getMyParameter("empresa");
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        if (fecha1 != null && fecha2 != null && codEmpresa != null) {
            String totales = this.conversacioDetDAO.archivosGenerados(date1, date2);
            try {
                HashMap<String, String> responsePayload = new HashMap<String, String>();
                responsePayload.put("Archivos", totales);
                ApiResponse apiResponse = ApiResponse.ok((int)200, responsePayload);
                return ResponseEntity.ok((Object)apiResponse);
            }
            catch (HttpClientErrorException e) {
                throw new CustomException("Error en la solicitud al servicio de Python: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            catch (HttpServerErrorException e) {
                throw new CustomException("Error en el servicio de Python: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new CustomException("Error inesperado: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        throw new CustomException("El request no es del tipo EC2", HttpStatus.BAD_REQUEST);
    }
}

