/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.controller;

import com.tcloud.exceptions.CustomException;
import com.tcloud.logic.entity.DocumentFile;
import com.tcloud.logic.service.ChatApiService;
import com.tcloud.logic.service.ConversacioService;
import com.tcloud.logic.service.RolService;
import com.tcloud.logic.service.TenansService;
import com.tcloud.repository.DocumentFileDAO;
import com.tcloud.utils.ApiResponse;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"report"})
public class DashBoardController {
    private static final Logger log = LoggerFactory.getLogger(DashBoardController.class);
    private final ConversacioService conversacionService;
    private final RolService rolService;
    private final ChatApiService charApiService;
    private final TenansService tenansService;
    private final DocumentFileDAO documentFileDAO;

    @PostMapping(value={"/ebs_vol_reads_ops"})
    public ResponseEntity<ApiResponse<?>> getEBSMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolReadOpsByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_write_ops"})
    public ResponseEntity<ApiResponse<?>> getEBSVolWriteOpsMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolWriteOpsByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_read_bytes"})
    public ResponseEntity<ApiResponse<?>> getEBSVolReadBytesMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolReadBytesByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_write_bytes"})
    public ResponseEntity<ApiResponse<?>> getEBSVolWriteBytesMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolWriteBytesByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_total_read_time"})
    public ResponseEntity<ApiResponse<?>> getEBSVolTotalTReadTimeMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolTotalReadTimeByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_total_write_time"})
    public ResponseEntity<ApiResponse<?>> getEBSVolTotalWriteTimeMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolTotalWriteTimeByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_idle_time"})
    public ResponseEntity<ApiResponse<?>> getEBSVolIdleTimeMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolIdleTimeByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_queue_length"})
    public ResponseEntity<ApiResponse<?>> getEBSVolQueueMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolQueueLengthByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_volume_throughput_percentage"})
    public ResponseEntity<ApiResponse<?>> getEBSVolThroughputMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolThroughputPercentageByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ebs_burst_balance"})
    public ResponseEntity<ApiResponse<?>> getEBSBurstBalanceMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEBSVolBurstBalanceByDate(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/waf"})
    public ResponseEntity<ApiResponse<?>> getWAFMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getWaf(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/waf-allowed"})
    public ResponseEntity<ApiResponse<?>> getWAFAllowed(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getWafAllowed(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/waf-blocked"})
    public ResponseEntity<ApiResponse<?>> getWAFBlocked(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getWafBlocked(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/request_count"})
    public ResponseEntity<ApiResponse<?>> getLoadRequestCount(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerRequestCount(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/target_response_time"})
    public ResponseEntity<ApiResponse<?>> getLoadBalancerTargetResponseTime(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerTargetResponseTime(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/http_2xx_count"})
    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp2xxCount(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerHttp2xxCount(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/http_3xx_count"})
    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp3xxCount(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerHttp3xxCount(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/http_4xx_count"})
    public ResponseEntity<ApiResponse<?>> getLoadBalancerHttp4xxCount(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerHttp4xxCount(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/loadbalancer/active_connection_count"})
    public ResponseEntity<ApiResponse<?>> getLoadBalancerActiveConnectionCount(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getLoadBalancerActiveConnectionCount(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/vpn_tunnel_in"})
    public ResponseEntity<ApiResponse<?>> getVPNMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getVpnTunnelDataIn(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/vpn_tunnel_out"})
    public ResponseEntity<ApiResponse<?>> getVPNTunnelOut(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getVpnTunnelDataOut(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/vpn_tunnel_state"})
    public ResponseEntity<ApiResponse<?>> getVPNTunnelState(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getVpnTunnelState(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2-categorized"})
    public ResponseEntity<ApiResponse<?>> getEC2CategorizedMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2Categorized(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/diskread"})
    public ResponseEntity<ApiResponse<?>> getEC2DiskReadMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2DiskRead(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/diskwrite"})
    public ResponseEntity<ApiResponse<?>> getEC2DiskWriteMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2DiskWrite(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/networkin"})
    public ResponseEntity<ApiResponse<?>> getEC2NetworkInMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2NetworkIn(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/networkout"})
    public ResponseEntity<ApiResponse<?>> getEC2NetworkOutMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2NetworkOut(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/diskreadbytes"})
    public ResponseEntity<ApiResponse<?>> getEC2DiskReadBytesMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2DiskReadBytes(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/diskwritebytes"})
    public ResponseEntity<ApiResponse<?>> getEC2DiskWriteBytesMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2DiskWriteBytes(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2/statuscheckfailed"})
    public ResponseEntity<ApiResponse<?>> getEC2StatusCheckFailedMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2StatusCheckFailed(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/ec2"})
    public ResponseEntity<ApiResponse<?>> getEC2CtegorizedMetrics(@RequestParam(name="fecha1") String fecha1, @RequestParam(name="fecha2") String fecha2, @RequestParam(name="time") long time, @RequestParam(name="stat") String stat) {
        try {
            return this.tenansService.getEC2DiskRead(fecha1, fecha2, time, stat);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @GetMapping(value={"/image/{name}"})
    public ResponseEntity<byte[]> getImage(@PathVariable(name="name") String name) {
        log.info("entra al controlador");
        Optional documentFile = this.documentFileDAO.findByName(name);
        if (documentFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = DashBoardController.determineImageType((byte[])((DocumentFile)documentFile.get()).getFileData());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((DocumentFile)documentFile.get()).getFileData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private static String determineImageType(byte[] imageBytes) {
        if (imageBytes.length > 4 && imageBytes[0] == -119 && imageBytes[1] == 80 && imageBytes[2] == 78 && imageBytes[3] == 71) {
            return "image/png";
        }
        if (imageBytes.length > 3 && imageBytes[0] == -1 && imageBytes[1] == -40 && imageBytes[2] == -1) {
            return "image/jpeg";
        }
        return null;
    }

    @PostMapping(value={"/total-usuarios"})
    public ResponseEntity<ApiResponse<?>> obtenerlistadoUsuarios() {
        try {
            return this.conversacionService.obtenerlistadoUsuarios();
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/total_preguntas"})
    public ResponseEntity<ApiResponse<?>> obtenerNumeroPreguntasRol(@RequestParam String fecha1, String fecha2, String rol) {
        try {
            return this.rolService.obtenerNumeroPreguntasRol(fecha1, fecha2, rol);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/lista_metricas"})
    public ResponseEntity<ApiResponse<?>> obtenerMetricas() {
        try {
            return this.tenansService.getAllMetricsServices();
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/obtener-tokens"})
    public ResponseEntity<ApiResponse<?>> obtenerTokens(@RequestParam(value="fecha1") String fecha1, @RequestParam(value="fecha2") String fecha2) {
        try {
            return this.charApiService.obtenerTokens(fecha1, fecha2);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    @PostMapping(value={"/archivos-generados"})
    public ResponseEntity<ApiResponse<?>> archivosGenerados(@RequestParam(value="fecha1") String fecha1, @RequestParam(value="fecha2") String fecha2) {
        try {
            return this.charApiService.archivosGenerados(fecha1, fecha2);
        }
        catch (CustomException e) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setStatus(e.getHttpStatus().value());
            errorResponse.setSuccess(Boolean.valueOf(false));
            errorResponse.setMessage(e.getMessage());
            return new ResponseEntity((Object)errorResponse, (HttpStatusCode)e.getHttpStatus());
        }
    }

    public DashBoardController(ConversacioService conversacionService, RolService rolService, ChatApiService charApiService, TenansService tenansService, DocumentFileDAO documentFileDAO) {
        this.conversacionService = conversacionService;
        this.rolService = rolService;
        this.charApiService = charApiService;
        this.tenansService = tenansService;
        this.documentFileDAO = documentFileDAO;
    }
}

