/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.interceptors;

import com.tcloud.exceptions.CustomException;
import com.tcloud.utils.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(Exception ex, WebRequest request) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(RuntimeException ex, WebRequest request) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(CustomException ex, WebRequest request) {
        ApiResponse response = ApiResponse.error((int)ex.getHttpStatus().value(), (String)ex.getMessage());
        return new ResponseEntity((Object)response, (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public ResponseEntity<ApiResponse<Object>> handleAsyncRequestTimeoutException() {
        ApiResponse response = ApiResponse.error((int)HttpStatus.REQUEST_TIMEOUT.value(), (String)"La solicitud ha tardado demasiado tiempo en procesarse.");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.REQUEST_TIMEOUT);
    }
}

