/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.interceptors;

import com.tcloud.utils.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AuditingInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuditingInterceptor.class);
    private final RequestUtils requestUtils;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("startTime", (Object)System.currentTimeMillis());
        log.info(this.requestUtils.getParamsFromRequest(request).toString());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.requestUtils.saveInfoAudit(request, response);
    }

    public AuditingInterceptor(RequestUtils requestUtils) {
        this.requestUtils = requestUtils;
    }
}

