/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.procesor.service.impl;

import ec.tws2.back.lhia.procesor.dao.DocumentoDAO;
import ec.tws2.back.lhia.procesor.dao.SeccionDocumentoDAO;
import ec.tws2.back.lhia.procesor.entity.Documento;
import ec.tws2.back.lhia.procesor.entity.SeccionDocumento;
import ec.tws2.back.lhia.procesor.service.SegmenterRepository;
import ec.tws2.back.lhia.procesor.util.UtilLhia;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SegmenterRepositoryImpl
implements SegmenterRepository {
    private Logger log = Logger.getLogger(SegmenterRepositoryImpl.class.getName());
    @Autowired
    DocumentoDAO documentoDAO;
    @Autowired
    SeccionDocumentoDAO seccionDocumentoDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    UtilLhia util = new UtilLhia();

    public void parseSegmenter() {
        Documento documento = (Documento)this.documentoDAO.findById((Object)6L).get();
        Path pdfPath = Path.of("E:\\TWS2\\proyectos\\LHIA\\JARDIN AZUAYO\\Fwd_\u00a0Portafolio de servicios Jard\u00edn Azuayo\\procesados\\virtuales_ja.pdf", new String[0]);
        try (PDDocument document = PDDocument.load((File)pdfPath.toFile());){
            PDFTextStripper textStripper = new PDFTextStripper();
            String text = textStripper.getText(document);
            int cont = 0;
            List chapters = this.segmentTextByChapter(text);
            for (String chapter : chapters) {
                SeccionDocumento seccionDocumento = new SeccionDocumento();
                seccionDocumento.setId_seccion_documento(Long.valueOf(0L));
                seccionDocumento.setDocumento(documento);
                seccionDocumento.setGenerado(Long.valueOf(0L));
                seccionDocumento.setScore(0.0);
                seccionDocumento.setTexto(chapter);
                this.seccionDocumentoDAO.save((Object)seccionDocumento);
                System.out.println(cont + ") SALTO--------------------------------------------------------------");
                ++cont;
                System.out.println(chapter);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> segmentTextByChapter(String text) {
        ArrayList<String> chapters = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?i)(SeccionLhia)");
        Matcher matcher = pattern.matcher(text);
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start();
            chapters.add(text.substring(start, end));
            start = matcher.start();
        }
        chapters.add(text.substring(start));
        return chapters;
    }

    public String extractAndStorePdfText(String pdfPath) throws IOException {
        File pdfFile = new File(pdfPath);
        PDDocument document = PDDocument.load((File)pdfFile);
        PDFTextStripper pdfTextStripper = new PDFTextStripper();
        String text = pdfTextStripper.getText(document);
        String filename = pdfFile.getName();
        return text;
    }

    public void extractAndStorePdfTexts(List<String> pdfPaths) throws IOException {
        for (String pdfPath : pdfPaths) {
            this.extractAndStorePdfText(pdfPath);
        }
    }

    public void generateEmbeddingsForProducts() {
        List documents = this.seccionDocumentoDAO.listadoProductosNG();
        for (SeccionDocumento document : documents) {
            String prompt = "SECCION: " + document.getTexto();
            this.log.info(prompt);
            String response = this.generateEmbedding(prompt);
            this.log.info("Embedding=" + response);
            document.setEmbedding(response);
            document.setGenerado(Long.valueOf(1L));
            this.seccionDocumentoDAO.save((Object)document);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-ada-002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }
}

