/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.crea.controller;

import ec.tws2.back.lhia.crea.data.ClienteConsumo;
import ec.tws2.back.lhia.crea.data.RespuestaRobot;
import ec.tws2.back.lhia.crea.service.CreaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"crea"})
public class ProductController {
    @Autowired
    CreaRepository creaRepository;

    @GetMapping(value={"/saludo1"})
    public String saludo1() {
        return "Hola Admin";
    }

    @GetMapping(value={"/saludo2"})
    public String saludo2() {
        return "Hola User";
    }

    @GetMapping(value={"/saludo3"})
    @CrossOrigin
    public String saludo3() {
        return "Hola User";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.creaRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getLstConversation());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.creaRepository.generateEmbeddingsForProducts();
    }
}

