/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.service.impl;

import ec.tws2.back.lhia.dao.ProductVehiculosDAO;
import ec.tws2.back.lhia.data.Conversacion;
import ec.tws2.back.lhia.entity.ProductVehiculos;
import ec.tws2.back.lhia.service.ProductVehiculosRepository;
import ec.tws2.back.lhia.util.UtilLhia;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ProductVehiculosRepositoryImpl
implements ProductVehiculosRepository {
    private Logger log = Logger.getLogger(ProductVehiculosRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew = "Responde de forma clara, en maximo tres lineas y precisa, actuando como una persona de Atenci\u00f2n al cliente especializada en ventas de vehiculos de todo tipo de la empresa TWS2 siempre tomando en cuenta las Notas que vienen en la pregunta";
    @Autowired
    private ProductVehiculosDAO productoDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    private final RestTemplate restTemplate = new RestTemplate();

    @PostConstruct
    public void init() {
    }

    public String findProductsByQuestion(String question, List<Conversacion> lstConversation) {
        lstConversation.add(0, new Conversacion("system", this.iniTextoNew));
        Object promptPrincipal = question + "\nNotas:\n0)" + this.util.obtenerUltimaRespuesta(lstConversation) + "\n";
        String embedding = this.generateEmbedding(question);
        this.log.info("--------------------llego acaaaaaaaaaaaaaaaaaa " + Instant.now());
        List products = this.obtenerPrompts();
        this.log.info("--------------------pasooooooooooooooooooooooooooooo " + Instant.now());
        for (ProductVehiculos product : products) {
            double similarity = this.util.cosineSimilarity(embedding, product.getEmbedding());
            product.setScore(similarity);
        }
        Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
        Collections.sort(products, scoreComparator);
        for (int i = 0; i < 2; ++i) {
            String prompt = i + 1 + "):Nombre: " + ((ProductVehiculos)products.get(i)).getName() + " Descripcion: " + ((ProductVehiculos)products.get(i)).getDescription() + "\n";
            this.log.info("PRODUCTO:" + ((ProductVehiculos)products.get(i)).getName() + "/ SCORE:" + ((ProductVehiculos)products.get(i)).getScore());
            promptPrincipal = ((ProductVehiculos)products.get(i)).getScore() >= 0.77 ? ((String)promptPrincipal).concat(prompt) : ((String)promptPrincipal).concat(i + 1 + ")No disponemos de ese producto, en TWS2 nos dedicamos a la venta de vehiculos de todo tipo. Si desea hacer alguna compra puede contactarnos al Telf:072897845 Cel:0996625708 o visitar nuestra tienda en Sergio Ortega y Fransisco Paredes cuarto piso edificio los rios oficina 404.\n");
        }
        lstConversation.add(new Conversacion("user", (String)promptPrincipal));
        String answer = this.respondePreguntasV2(lstConversation);
        return answer;
    }

    public void generateEmbeddingsForProducts() {
        List products = this.productoDAO.listadoProductosNG();
        for (ProductVehiculos product : products) {
            String prompt = "Nombre: " + product.getName() + " Descripcion: " + product.getDescription();
            this.log.info(prompt);
            String response = this.generateEmbedding(prompt);
            this.log.info("Embedding=" + response);
            product.setEmbedding(response);
            product.setGenerado(Long.valueOf(1L));
            this.productoDAO.save((Object)product);
        }
    }

    private String respondePreguntasV2(List<Conversacion> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 240);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        this.log.info("---------------------------------------------------------");
        this.log.info("" + responseJson);
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-ada-002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    public List<ProductVehiculos> obtenerPrompts() {
        return this.productoDAO.findAll();
    }
}

