/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.dao.ProductDAO;
import ec.tws2.back.lhia.data.Conversacion;
import ec.tws2.back.lhia.data.Correo;
import ec.tws2.back.lhia.entity.Product;
import ec.tws2.back.lhia.service.ProductRepository;
import ec.tws2.back.lhia.service.impl.ProductFybecaRepositoryImpl;
import ec.tws2.back.lhia.util.EnvioCorreo;
import ec.tws2.back.lhia.util.UtilLhia;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ProductRepositoryImpl
implements ProductRepository {
    private Logger log = Logger.getLogger(ProductFybecaRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew = "Responde de forma corta, conscisa y clara, actuando como una persona de Atenci\u00f2n al cliente especializada en ventas de la empresa TWS2 siempre tomando en cuenta las Notas que vienen en la pregunta";
    @Autowired
    private ProductDAO productoDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();
    private Map<String, List<Conversacion>> historialUsuarios = new HashMap();
    private String rutaCarpetaCertificados = "/opt/spring_back/lhia/certificados/";

    @PostConstruct
    public void init() {
    }

    public String findProductsByQuestion(String question, List<Conversacion> lstConversation) {
        this.log.info("--------------------pregunta:" + question);
        if ((question.toUpperCase().contains("ENV\u00cdA") || question.toUpperCase().contains("ENVIA") || question.toUpperCase().contains("ENVIAR")) && (question.toUpperCase().contains("CORREO") || question.toUpperCase().contains("EMAIL") || question.toUpperCase().contains("ELECTRONICO") || question.toUpperCase().contains("ELECTR\u00d3NICO"))) {
            String resp = this.enviaCorreo(question);
            return resp;
        }
        lstConversation.add(0, new Conversacion("system", this.iniTextoNew));
        Object promptPrincipal = question + "\nNotas:\n0)" + this.util.obtenerUltimaRespuesta(lstConversation) + "\n";
        String embedding = this.generateEmbedding(question);
        this.log.info("--------------------llego acaaaaaaaaaaaaaaaaaa " + Instant.now());
        List products = this.obtenerPrompts();
        this.log.info("--------------------pasooooooooooooooooooooooooooooo " + Instant.now());
        for (Product product : products) {
            double similarity = this.util.cosineSimilarity(embedding, product.getEmbedding());
            product.setScore(similarity);
        }
        Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
        Collections.sort(products, scoreComparator);
        for (int i = 0; i < 2; ++i) {
            String prompt = i + 1 + "):Nombre: " + ((Product)products.get(i)).getName() + " Descripcion: " + ((Product)products.get(i)).getDescription() + "\n";
            this.log.info("PRODUCTO:" + ((Product)products.get(i)).getName() + "/ SCORE:" + ((Product)products.get(i)).getScore());
            promptPrincipal = ((Product)products.get(i)).getScore() >= 0.8 ? ((String)promptPrincipal).concat(prompt) : ((String)promptPrincipal).concat(i + 1 + ")No disponemos de ese producto, en TWS2 nos dedicamos a la venta de equipos tecnol\u00f3gicos de alta calidad. Si desea hacer una compra puede contactarnos al Telf:072897845 Cel:0996625708 o visitar nuestra tienda en Sergio Ortega y Fransisco Paredes cuarto piso edificio los rios oficina 404.\n");
        }
        lstConversation.add(new Conversacion("user", (String)promptPrincipal));
        String answer = this.respondePreguntasV2(lstConversation);
        return answer;
    }

    public String chatCliente(String question, String identificador) throws Exception {
        String System_prompt = "Actua como un asistente llamada Lhia desarrollada por la empresa TWS2, el asistente sera uno de recursos humanos de la empresa Indurama CON LOS SIGUIENTES Datos, existen los empleados Isaac Arteaga con la cedula 0104597846 y percibe un sueldo de 600 dolares al mes que no cuenta con vaciones y Juan Pablo Am\u00f3n Salinas con la cedula 0104597845 y percibe un sueldo de 700 dolares al mes que cuenta con vaciones ademas cada uno tiene 5 y 6 a\u00f1os en la empresa";
        List conversacionUsuario = this.historialUsuarios.computeIfAbsent(identificador, k -> new ArrayList());
        if (conversacionUsuario.isEmpty()) {
            conversacionUsuario.add(new Conversacion("system", System_prompt));
        }
        conversacionUsuario.add(new Conversacion("user", question));
        if (question.toUpperCase().contains("MI CERTIFICADO") && question.toUpperCase().contains("VACA")) {
            return this.enviarCertificado();
        }
        if (question.toUpperCase().contains("MI CERTIFICADO") && question.toUpperCase().contains("INGRE")) {
            return this.enviarCertificado2();
        }
        String respuesta = this.respondePreguntasV2(conversacionUsuario);
        conversacionUsuario.add(new Conversacion("assistant", respuesta));
        return respuesta;
    }

    public String enviarCertificado() {
        try {
            ArrayList<String> destinatarios = new ArrayList<String>();
            destinatarios.add("juanitocaisapanta@gmail.com");
            this.enviarCorreo(destinatarios, "Certificado de Vacaciones Indurama", "Estimado Juan Pablo Am\u00f3n Salinas se adjunta su Certificado de Vacaciones", this.rutaCarpetaCertificados + "vacaciones.pdf");
            return "El Certificado de Vacaciones fue enviado a tu correo electr\u00f3nico";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Ocurrio un problema al generar tu Certificado de Vacaciones";
        }
    }

    public String enviarCertificado2() {
        try {
            ArrayList<String> destinatarios = new ArrayList<String>();
            destinatarios.add("juanitocaisapanta@gmail.com");
            this.enviarCorreo(destinatarios, "Certificado de Ingresos Indurama", "Estimado Juan Pablo Am\u00f3n Salinas se adjunta su Certificado de Ingresos", this.rutaCarpetaCertificados + "ingreso.pdf");
            return "El Certificado de Ingresos fue enviado a tu correo electr\u00f3nico";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Ocurrio un problema al generar tu Certificado de Ingresos";
        }
    }

    public void generateEmbeddingsForProducts() {
        List products = this.productoDAO.listadoProductosNG();
        for (Product product : products) {
            String prompt = "Nombre: " + product.getName() + " Descripcion: " + product.getDescription();
            this.log.info(prompt);
            String response = this.generateEmbedding(prompt);
            this.log.info("Embedding=" + response);
            product.setEmbedding(response);
            product.setGenerado(Long.valueOf(1L));
            this.productoDAO.save((Object)product);
        }
    }

    private String respondePreguntasV2(List<Conversacion> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 260);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-ada-002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    public List<Product> obtenerPrompts() {
        return this.productoDAO.findAll();
    }

    public String enviaCorreo(String question) {
        this.log.info("--entra a enviar correo:");
        String prompt = "Extrae los datos del texto:" + question + ". Y responde unicamente en formato JSON como ejemplo: {\n  \"correo destinatario\": \"\",\n  \"nombre destinatario\": \"\",\n  \"tipo de correo\": \"\",\n  \"remitente\": \"\",\n  \"costo\": \"\",\n  \"producto\": \"\"\n}\nCon los campos: producto(codigo o nombre buscalo en el texto), correo destinatario, nombre destinatario, tipo de correo, remitente:Tienda de Tecnolog\u00eda TWS2, costo. Sin ninguna explicacion adicional.\n Si no encuentras algun dato no lo agregues al JSON, el producto es obligatorio.";
        String objeto = this.respondePreguntas(prompt, Double.valueOf(0.4));
        String productoBuscado = this.obtenerProducto(objeto);
        String questionPrompt = "Dame informacion sobre el producto " + productoBuscado;
        if (productoBuscado.isEmpty()) {
            return "Debe ampliar las caracteristicas del Producto para el envio del Correo";
        }
        String embedding = this.generateEmbedding(questionPrompt);
        List products = this.obtenerPrompts();
        for (Product product : products) {
            double similarity = this.util.cosineSimilarity(embedding, product.getEmbedding());
            product.setScore(similarity);
        }
        Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
        Collections.sort(products, scoreComparator);
        String contexto = "";
        for (int i = 0; i < 2; ++i) {
            String promptIn = i + 1 + "):Nombre: " + ((Product)products.get(i)).getName() + " Descripcion: " + ((Product)products.get(i)).getDescription() + " Precio:" + ((Product)products.get(i)).getPrice() + "\n";
            this.log.info("PRODUCTO:" + ((Product)products.get(i)).getName() + "/ SCORE:" + ((Product)products.get(i)).getScore());
            if (!(((Product)products.get(i)).getScore() >= 0.79)) continue;
            contexto = contexto.concat(promptIn);
        }
        String promptEnvio = "Redacta un correo electr\u00f3nico con fecha: " + LocalDate.now() + " para un cliente En el cuerpo del correo, incluye un apartado con detalles relevantes del producto utilizando la informaci\u00f3n del siguiente JSON:" + objeto + "\nTen en cuenta el contexto con los datos del producto y la informaci\u00f3n de contacto del remitente proporcionada:\nCONTEXTO:" + contexto + "\nInformaci\u00f3n remitente:\nRemitente: Tienda de Tecnolog\u00eda TWS2, Nombre del remitente: Juan Pablo Am\u00f3n, Telefono del remitente: +593980269327, Informaci\u00f3n de contacto del remitente jpamon@tws2.io";
        String cuerpo = this.respondePreguntas(promptEnvio, Double.valueOf(0.8));
        String destinatario = this.obtenerDestinatario(objeto);
        EnvioCorreo envioCorreo = new EnvioCorreo();
        envioCorreo.fnNotificarSA(destinatario, "gerencia@tws2.io", "Envio Correo Autom\u00e1tico LHIA", cuerpo);
        return "Correo procesado le llegara en breve al destinatario";
    }

    private String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 350);
        requestBody.put("temperature", temp);
        requestBody.put("top_p", 1);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    private String obtenerProducto(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        String producto = "";
        Correo correo = null;
        try {
            correo = (Correo)objectMapper.readValue(json, Correo.class);
            System.out.println(correo.getProducto());
            System.out.println(correo.getCorreoDestinatario());
            System.out.println(correo.getNombreDestinatario());
            System.out.println(correo.getTipoDeCorreo());
            System.out.println(correo.getRemitente());
            System.out.println(correo.getCosto());
            producto = correo.getProducto();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return producto;
    }

    private String obtenerDestinatario(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        String destinatario = "";
        Correo correo = null;
        try {
            correo = (Correo)objectMapper.readValue(json, Correo.class);
            System.out.println(correo.getProducto());
            System.out.println(correo.getCorreoDestinatario());
            System.out.println(correo.getNombreDestinatario());
            System.out.println(correo.getTipoDeCorreo());
            System.out.println(correo.getRemitente());
            System.out.println(correo.getCosto());
            destinatario = correo.getCorreoDestinatario();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return destinatario;
    }

    public void enviarCorreo(List<String> destinatarios, String asunto, String contenido, String file) throws Exception {
        String url = "https://back.correos.tws2.io/correo-service/correo/send";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.fetchAccessToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("destinatarios", destinatarios);
        requestBody.put("contentisHtml", true);
        requestBody.put("asunto", asunto);
        requestBody.put("contenido", contenido);
        requestBody.put("codigoEmail", "roSNrXU0bv2xRQlJvqOQkkNBo12XB3wQ");
        HashMap<String, String> archivo = new HashMap<String, String>();
        archivo.put("fileBase64", this.base64(file));
        archivo.put("fileName", "Documento.pdf");
        ArrayList<HashMap<String, String>> archivos = new ArrayList<HashMap<String, String>>();
        archivos.add(archivo);
        requestBody.put("archivos", archivos);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        String responseBody = (String)responseEntity.getBody();
        System.out.println("Cuerpo de la respuesta: " + responseBody);
    }

    public String base64(String file) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(file, new String[0]));
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        return base64String;
    }

    public String fetchAccessToken() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "password");
        parameters.put("client_id", "logueoBack");
        parameters.put("username", "emailservice");
        parameters.put("password", "X}5E&fY\\ca#Y)u*Q");
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://login.tws2.io/auth/realms/administracion/protocol/openid-connect/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.getFormDataString(parameters))).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            JSONObject jsonObject = new JSONObject(response.body());
            System.out.println(jsonObject.getString("access_token"));
            return jsonObject.getString("access_token");
        }
        throw new RuntimeException("Failed to fetch access token: " + response.statusCode() + " " + response.body());
    }

    private String getFormDataString(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sj.add(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
        }
        return sj.toString();
    }
}

