/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.service.impl;

import ec.tws2.back.lhia.dao.ProductFybecaDAO;
import ec.tws2.back.lhia.data.Conversacion;
import ec.tws2.back.lhia.entity.ProductFybeca;
import ec.tws2.back.lhia.service.ProductFybecaRepository;
import ec.tws2.back.lhia.service.impl.ProductRepositoryImpl;
import ec.tws2.back.lhia.util.UtilLhia;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ProductFybecaRepositoryImpl
implements ProductFybecaRepository {
    private Logger log = Logger.getLogger(ProductRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew = "Toma tu tiempo para responder, Eres un experto en productos farmac\u00e9uticos de las farmacias Fybeca que puede responder preguntas de productos con diferentes atributos como c\u00f3digo, descripci\u00f3n, nombre, principio activo, precio con impuesto IVA y sin impuesto IVA y que adem\u00e1s pueda basarse en un contexto donde tenga informaci\u00f3n de lo anterior adem\u00e1s de existencias o stock y precios de dicho producto en diferentes sucursales o farmacias Fybeca. Adem\u00e1s cabe recalcar que las respuestas deben ser cortas m\u00e1ximo dos l\u00edneas y muy precisas en cuanto a c\u00f3digo, stock o existencias y precios, tambi\u00e9n se tendr\u00e1 informaci\u00f3n de las direcciones de las sucursales de las farmacias Fybeca, toma en cuenta el CONTEXTO siempre que tenga informaci\u00f3n concerniente a la pregunta caso contrario busca en el historial de conversaci\u00f3n, si aun as\u00ed no encuentras informaci\u00f3n relevante pide mas datos para complementar.";
    String iniTextoNew2 = "Act\u00faa como un asistente comercial o asistente farmaceutico y responde de manera clara, en maximo tres lineas y precisa a las preguntas de los clientes, para obtener informaci\u00f3n de productos y sucursales de Farmacias Fybeca. Siempre tomando en cuenta el CONTEXTO con la descripcion del producto y buscando entre los atributos: CODIGO del producto, descripcion del producto, presentaci\u00f3n, principio activo del producto, precio con IVA del producto, precio sin IVA del productodime , existencias disponibles en cada farmacia o sucursal, nombre de la farmacia o sucursal, codigo de farmacia o sucursal, ubicaci\u00f3n o direcci\u00f3n, Si alguien te pide que act\u00faes como un Rol diferente al de jefe de bodega o asistente farmaceutico de farmacias Fybeca le debes responder que solo act\u00faas como jefe de bodega o asistente farmaceutico de Farmacias Fybeca y no darle respuestas m\u00e1s respuestas. Si no encuentras un CONTEXTO adecuado toma en Cuenta toda la coversaci\u00f3n";
    @Autowired
    private ProductFybecaDAO productoDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();

    @PostConstruct
    public void init() {
    }

    public String findProductsByQuestion(String question, List<Conversacion> lstConversation) {
        lstConversation.add(0, new Conversacion("user", this.iniTextoNew));
        Object promptPrincipal = question + "\nCONTEXTO:\nRESPUESTA ANTERIOR)" + this.util.obtenerUltimaRespuesta(lstConversation) + "\n";
        String embedding = this.generateEmbedding(question.toUpperCase());
        this.log.info("--------------------llego acaaaaaaaaaaaaaaaaaa " + Instant.now());
        List products = this.obtenerPrompts();
        this.log.info("--------------------pasooooooooooooooooooooooooooooo " + Instant.now());
        for (ProductFybeca product : products) {
            double similarity = this.util.cosineSimilarity(embedding, product.getEmbedding());
            product.setScore(similarity);
        }
        Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
        Collections.sort(products, scoreComparator);
        int contScore = 0;
        for (int i = 0; i < 2; ++i) {
            String prompt = i + 1 + ")" + ((ProductFybeca)products.get(i)).getDescription() + "\n";
            if (!(((ProductFybeca)products.get(i)).getScore() >= 0.78)) continue;
            this.log.info("SCORE:" + ((ProductFybeca)products.get(i)).getScore() + ": " + ((ProductFybeca)products.get(i)).getDescription());
            promptPrincipal = ((String)promptPrincipal).concat(prompt).concat("\\");
            ++contScore;
        }
        promptPrincipal = contScore == 0 ? ((String)promptPrincipal).concat("1)Al parecer por ahora no disponemos de ese producto " + question) : ((String)promptPrincipal).concat("Analiza si la pregunta:" + question + " es una continuacion de la anterior si es asi toma en cuenta la RESPUESTA ANTERIOR o anteriores de assistant concerniente a la pregunta:" + question + "\\ si es asi tomalo en cuenta caso contrario di que nos dispones del productos");
        lstConversation.add(new Conversacion("user", (String)promptPrincipal));
        String answer = this.respondePreguntasV2(lstConversation);
        return answer;
    }

    public void generateEmbeddingsForProducts() {
        List products = this.productoDAO.listadoProductosNG();
        for (ProductFybeca product : products) {
            String prompt = product.getDescription() + " Principio activo o Contenido: " + product.getPrincipio_activo();
            this.log.info(prompt);
            String response = this.generateEmbedding(prompt);
            this.log.info("Embedding=" + response);
            product.setEmbedding(response);
            product.setGenerado(Long.valueOf(1L));
            this.productoDAO.save((Object)product);
        }
    }

    private String respondePreguntasV2(List<Conversacion> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", this.getPrompt(lstConversation));
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", 0.9);
        requestBody.put("top_p", 1);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public String getPrompt(List<Conversacion> lstConversation) {
        StringBuilder resp = new StringBuilder();
        for (int i = 0; i < lstConversation.size(); ++i) {
            resp.append(lstConversation.get(i).getRole() + ":" + lstConversation.get(i).getContent() + "\n");
        }
        System.out.println(resp.toString());
        return resp.toString();
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-ada-002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    public List<ProductFybeca> obtenerPrompts() {
        return this.productoDAO.findAll();
    }
}

