/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class PdfExtractor {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void extractAndStorePdfText(String pdfPath) throws IOException {
        File pdfFile = new File(pdfPath);
        PDDocument document = PDDocument.load((File)pdfFile);
        PDFTextStripper pdfTextStripper = new PDFTextStripper();
        String text = pdfTextStripper.getText(document);
        String filename = pdfFile.getName();
        String query = "INSERT INTO pdfs (filename, text) VALUES (?, ?)";
        this.jdbcTemplate.update(query, new Object[]{filename, text});
    }

    public void extractAndStorePdfTexts(List<String> pdfPaths) throws IOException {
        for (String pdfPath : pdfPaths) {
            this.extractAndStorePdfText(pdfPath);
        }
    }
}

