/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.controller;

import ec.tws2.back.lhia.data.ClienteConsumo;
import ec.tws2.back.lhia.data.RespuestaRobot;
import ec.tws2.back.lhia.service.ProductLartizcoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"lartizco"})
public class ProductLartizcoController {
    @Autowired
    private ProductLartizcoRepository productRepository;

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.productRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getLstConversation());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('admin')")
    public void generaEmb() {
        this.productRepository.generateEmbeddingsForProducts();
    }
}

