/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.controller;

import ec.tws2.back.lhia.data.ClienteConsumo;
import ec.tws2.back.lhia.data.RespuestaRobot;
import ec.tws2.back.lhia.service.ProductRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"indurama"})
public class ProductInduramaController {
    @Autowired
    private ProductRepository productRepository;

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        try {
            String answer = this.productRepository.chatCliente(cliente.getQuestion(), "001");
            robot.setRespuesta(answer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('admin')")
    public void generaEmb() {
        this.productRepository.generateEmbeddingsForProducts();
    }
}

