/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.controller;

import ec.tws2.back.lhia.data.ClienteConsumo;
import ec.tws2.back.lhia.data.RespuestaRobot;
import ec.tws2.back.lhia.service.ProductFybecaNewRepository;
import ec.tws2.back.lhia.service.ProductFybecaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fybeca"})
public class ProductFybecaController {
    @Autowired
    private ProductFybecaRepository productRepository;
    @Autowired
    private ProductFybecaNewRepository productNewRepository;

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.productRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getLstConversation());
        robot.setRespuesta(answer);
        return robot;
    }

    @PostMapping(value={"/questionV3"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductV3(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.productNewRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getId());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    public void generaEmb() {
        this.productRepository.generateEmbeddingsForProducts();
    }

    @GetMapping(value={"/getCliente"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('admin')")
    public ClienteConsumo getCliente() {
        ClienteConsumo cliente = new ClienteConsumo();
        cliente.setQuestion("Tienen finalin?");
        cliente.setId("6b8f052e-37f1-4e7c-8f2c-48c0b9f986c7");
        return cliente;
    }
}

