/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.ja.util;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import ec.tws2.back.lhia.ja.data.ConversacionUsuario;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.json.JSONArray;
import org.json.JSONObject;

public class UtilLhia {
    private Logger log = Logger.getLogger(UtilLhia.class.getName());

    public void mostrarLista(List<ConversacionUsuario> lstConversation) {
        this.log.info("------------------------------------------------------------------------");
        for (int i = 0; i < lstConversation.size(); ++i) {
            this.log.info("rol:" + lstConversation.get(i).getRole());
            this.log.info("mensaje:" + lstConversation.get(i).getContent());
            this.log.info("------------------------------------------------------------------------");
        }
        this.log.info("------------------------------------------------------------------------");
    }

    public String obtenerUltimaRespuesta(List<ConversacionUsuario> lstConversation) {
        String resp = "";
        for (int i = lstConversation.size() - 1; i > 0; --i) {
            if (!lstConversation.get(i).getRole().equals("assistant")) continue;
            resp = lstConversation.get(i).getContent();
            break;
        }
        return resp;
    }

    public String parseEmbedding(String response) {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray("embedding");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringBuilder.append(jsonArray.getDouble(i));
            if (i == jsonArray.length() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public double cosineSimilarity(String embedding1, String embedding2) {
        double[] arr1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        double[] arr2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray();
        ArrayRealVector vectorA = new ArrayRealVector(arr1);
        ArrayRealVector vectorB = new ArrayRealVector(arr2);
        double dotProduct = vectorA.dotProduct((RealVector)vectorB);
        double magnitude1 = vectorA.getNorm();
        double magnitude2 = vectorB.getNorm();
        if (magnitude1 == 0.0 || magnitude2 == 0.0) {
            return 0.0;
        }
        double similarity = dotProduct / (magnitude1 * magnitude2);
        return Math.min(1.0, Math.max(-1.0, similarity));
    }

    public double calculateEuclideanDistance(String embedding1, String embedding2) {
        double[] vector2;
        double[] vector1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        if (vector1.length != (vector2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray()).length) {
            throw new IllegalArgumentException("Los vectores deben tener la misma longitud");
        }
        EuclideanDistance euclideanDistance = new EuclideanDistance();
        double distance = euclideanDistance.compute(vector1, vector2);
        return distance;
    }

    public Integer conteoTokens(String palabra) {
        EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
        Encoding encoding = registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
        return encoding.countTokens(palabra);
    }

    public double calculateDistance(double lat1, double lon1, double lat2, double lon2) {
        double EARTH_RADIUS = 6371.0;
        double lat1Rad = Math.toRadians(lat1);
        double lon1Rad = Math.toRadians(lon1);
        double lat2Rad = Math.toRadians(lat2);
        double lon2Rad = Math.toRadians(lon2);
        double dLat = lat2Rad - lat1Rad;
        double dLon = lon2Rad - lon1Rad;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c;
        return distance;
    }

    public Date fechaEcuador() {
        ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
        LocalDateTime fechaHoraEcuador = LocalDateTime.now(zonaEcuador);
        return Date.from(fechaHoraEcuador.toInstant(ZoneOffset.UTC));
    }

    public String quitarTildes(String texto) {
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinTildes = textoNormalizado.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        String fraseFinal = textoSinTildes.replaceAll("\\?+", "");
        String fraseFinal1 = fraseFinal.replaceAll("\\n+", " ");
        String fraseFinal2 = fraseFinal1.replaceAll("\\(+", "");
        String fraseFinal3 = fraseFinal2.replaceAll("\\)+", "");
        String fraseFinal4 = fraseFinal3.replaceAll("\\-+", "");
        String fraseFinal5 = fraseFinal4.replaceAll("\\:+", "");
        String fraseFinal6 = fraseFinal5.replaceAll("\\*+", "");
        String fraseFinal7 = fraseFinal6.replaceAll("\\.+", " ");
        String fraseFinal8 = fraseFinal7.replaceAll("\\,+", " ");
        String fraseFinal9 = fraseFinal8.replaceAll("\\\u00bf+", "");
        String fraseFinal10 = fraseFinal9.replaceAll("\\s+", " ");
        String fraseFinal11 = fraseFinal10.replaceAll("\\s{3,}", " ");
        return fraseFinal11;
    }
}

