/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.ja.service.impl;

import ec.tws2.back.lhia.ja.dao.ActividadDAO;
import ec.tws2.back.lhia.ja.dao.CalificacionDAO;
import ec.tws2.back.lhia.ja.dao.CarpetaDAO;
import ec.tws2.back.lhia.ja.dao.ConversacionDAO;
import ec.tws2.back.lhia.ja.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.ja.dao.RolesDAO;
import ec.tws2.back.lhia.ja.dao.SeccionDocumentoDAO;
import ec.tws2.back.lhia.ja.data.CalificacionConsumo;
import ec.tws2.back.lhia.ja.data.ConversacionUsuario;
import ec.tws2.back.lhia.ja.data.RolesPreguntas;
import ec.tws2.back.lhia.ja.data.TemasConsumo;
import ec.tws2.back.lhia.ja.entity.Actividad;
import ec.tws2.back.lhia.ja.entity.Calificacion;
import ec.tws2.back.lhia.ja.entity.Carpeta;
import ec.tws2.back.lhia.ja.entity.Conversacion;
import ec.tws2.back.lhia.ja.entity.ConversacionDetalle;
import ec.tws2.back.lhia.ja.entity.Roles;
import ec.tws2.back.lhia.ja.entity.SeccionDocumento;
import ec.tws2.back.lhia.ja.service.JaSocioRepository;
import ec.tws2.back.lhia.ja.service.impl.JaRepositoryImpl;
import ec.tws2.back.lhia.ja.util.UtilLhia;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class JaSocioRepositoryImpl
implements JaSocioRepository {
    private Logger log = Logger.getLogger(JaRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private SeccionDocumentoDAO seccionDAO;
    @Autowired
    private RolesDAO rolesDAO;
    @Autowired
    private CarpetaDAO carpetaDAO;
    @Autowired
    private CalificacionDAO calificacionDAO;
    @Autowired
    private ActividadDAO actividadDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();
    private int tokens_conversacion = 0;
    private String textSystem = "";

    public String findProductsByQuestion(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaOpenIa(question, descripcion, identificador, usuario, lstConversation);
        return respuestaRobot;
    }

    public String respuestaOpenIa(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "Responde en espa\u00f1ol de manera clara y precisa solo preguntas acerca de la cooperativa Jardin azuayo que lo entienda un cliente en 250 tokens, actuando como asistente virtual llamado JARVI de la cooperativa Jard\u00edn Azuayo donde debes realizar las siguientes acciones: - entregar codigos markdown en la respuesta en caso de que sea necesario - usar siempre el mismo estilo de texto- solo si la pregunta trata sobre queja o reclamo decir que puede llenar el formulario que se encuentra en el siguiente link: [Formulario](https://www.jardinazuayo.fin.ec/reclamo/enviar?tknfv=678B28F49C7FC94969B309F4F2C8F7A9&tknfv=678ADAD2DEFGHIJKLMNOPQRSTVWX5876) - al entregar respuestas estas deben ser enlistada con vi\u00f1etas - si la pregunta trata sobre ahorros entregar el seguiente link para realizar calculos [Calculadora de Ahorro](https://servicios.jardinazuayo.fin.ec/calculadora-ja-app/calculadoraAhorros)- si la pregunta trata sobre creditos o credito entregar el siguiente link para realizar calculos [Calculadora de Cr\u00e9dito](https://calculadora.jardinazuayo.fin.ec)- si no se logra dar una respuesta, indicar que no cuentas con esa informacion y recomendar que puede comunicar con nuestro Call Center: (07) 4134503 o al Whatsapp Oficial: +593 95 918 1350 y Para llamadas desde EEUU, CANAD\u00c1 y PUERTO RICO llamar al: 908 809 2264- si la pregunta es Hola responder con 'Hola, soy JARVI tu asistente de Inteligencia Artificial, \u00bfQue necesitas?, no realices actividades extras, solo responde preguntas del contexto entregado y si no existe contexto entrega que recomendar que puede comunicar con nuestro Call Center: (07) 4134503 o al Whatsapp Oficial: +593 95 918 1350 y Para llamadas desde EEUU, CANAD\u00c1 y PUERTO RICO llamar al: 908 809 2264\n\npara responder las preguntas usa el siguiente ";
        String answer = "";
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replace("DPF", "Dep\u00f3sito a Plazo fijo O DPF").replace("CDP", "Certificado de Dep\u00f3sito a Plazo O CDP").replace("CHANCHITO", "Ahorro Programado Mi Ahorro Chanchito").replace("EMPRESA", "PERSONA JURIDICA O EMPRESA").replace("PJ", "PERSONA JURIDICA O PJ").replace("ORGANIZACIONES DE HECHO", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS").replace("OH", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS U OH");
        String corresponsales = this.respondePreguntas("verifica si la palabra 'corresponsal' est\u00e1 presente en la frase " + pregunta + " y responde con 'encontrado' si est\u00e1 presente y 'no' si no lo est\u00e1.", Double.valueOf(0.2));
        System.out.println(corresponsales);
        String preguntaUsuario = "pregunta: " + pregunta + " ?";
        String embedding = this.generateEmbedding(this.util.quitarTildes(pregunta.toUpperCase()).replace("\u00bf", "").replace("?", ""));
        this.log.info("--------------------llego acaaaaaaaaaaaaaaaaaa " + String.valueOf(Instant.now()));
        List secciones = new ArrayList();
        secciones = corresponsales.toUpperCase().contains("NO") ? this.obtenerPrompts(descripcion) : this.obtenerPromptsCorresponsales(descripcion);
        this.log.info("--------------------pasooooooooooooooooooooooooooooo " + String.valueOf(Instant.now()));
        double maxSimilarity = -1.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        ArrayList<SeccionDocumento> masSimilar = new ArrayList<SeccionDocumento>();
        for (SeccionDocumento seccion : secciones) {
            double similarity = this.util.cosineSimilarity(seccion.getEmbedding(), embedding);
            if (!(similarity > maxSimilarity)) continue;
            maxSimilarity = similarity;
            seccion.setScore(maxSimilarity);
            if (!(maxSimilarity >= 0.85)) continue;
            masSimilar.add(seccion);
            System.out.println(seccion.getTexto() + "\n Score:  " + seccion.getScore());
        }
        if (masSimilar.size() > 0) {
            boolean count = false;
            StringBuilder resultadoBusqueda = new StringBuilder();
            for (SeccionDocumento seccion : masSimilar) {
                resultadoBusqueda.append("\n" + seccion.getTexto()).append("\n");
            }
            prompt = "Contexto: \n" + String.valueOf(resultadoBusqueda) + "\n";
            String promptCompleto = this.iniTextoNew.concat((String)prompt);
            conversacionUsuario.add(0, new ConversacionUsuario("system", promptCompleto));
            conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
            for (ConversacionDetalle c : conversacion) {
                if (c.getActor().equals("user")) {
                    conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getAdicional()));
                }
                if (!c.getActor().equals("assistant")) continue;
                conversacionUsuario.add(new ConversacionUsuario(c.getActor(), ""));
            }
            conversacionUsuario.add(new ConversacionUsuario("user", preguntaUsuario));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(pregunta.replaceAll("\n", ""), answer, ((SeccionDocumento)masSimilar.get(masSimilar.size() - 1)).getDocumento().getCarpeta().getNombre(), identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", pregunta.replaceAll("\n", ""), (String)prompt, scoreFinal, this.util.conteoTokens(promptCompleto.concat(preguntaUsuario)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        } else {
            conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(pregunta.replaceAll("\n", ""), answer, "ADICIONAL", identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", pregunta.replaceAll("\n", ""), this.textSystem.concat(pregunta), scoreFinal, this.util.conteoTokens(this.textSystem.concat(pregunta)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        }
        return answer;
    }

    public void guardarActividad(String pregunta, String respuesta, String tema, String identificador) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            Carpeta carpeta = this.carpetaDAO.findByNombre(tema);
            Actividad actividad = new Actividad();
            actividad.setTexto_pregunta(pregunta);
            actividad.setTexto_respuesta(respuesta);
            actividad.setFecha(this.util.fechaEcuador());
            actividad.setCarpetas(carpeta);
            actividad.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
            this.actividadDAO.save((Object)actividad);
        }
    }

    public void guardarConversacion(String identificador, String usuario, String actor, String respuesta, String adicional, double score, int tokens, String descripcion) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!actor.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setActor(actor);
                conversacion_detalle.setRespuesta(respuesta);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens(tokens);
                conversacion_detalle.setAdicional(adicional);
                conversacion_detalle.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(this.util.fechaEcuador());
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setRoles((Roles)this.rolesDAO.findByDescripcion(descripcion).get());
            nueva_conversacion.setFecha(this.util.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setActor("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setRespuesta(this.textSystem);
            conversacion_detalle.setTokens(0);
            conversacion_detalle.setId_conversacion(aux);
            conversacion_detalle.setFecha(this.util.fechaEcuador());
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseEntity<?> guardarCalificacion(String identificador, String calificacion) {
        try {
            if (this.conversacionDAO.existsByIdentificador(identificador)) {
                Calificacion calificacion_ = new Calificacion();
                calificacion_.setCalificacion(calificacion);
                calificacion_.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                calificacion_.setFecha(this.util.fechaEcuador());
                return ResponseEntity.ok((Object)((Calificacion)this.calificacionDAO.save((Object)calificacion_)));
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    public List<CalificacionConsumo> obtenerCalificaciones(Date fecha1, Date fecha2, String rol) {
        return this.calificacionDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol);
    }

    public List<RolesPreguntas> obtenerNumeroPreguntasRol(Date fecha1, Date fecha2) {
        return this.rolesDAO.obtenerNumeroPreguntasRol(fecha1, fecha2);
    }

    public List<Actividad> listadoActividadCarpetas(Long id) {
        return this.actividadDAO.listadoActividadCarpetas(id);
    }

    public List<TemasConsumo> obtenerTemas(Date fecha1, Date fecha2, String rol) {
        return this.actividadDAO.listadoTemasFrecuencia(fecha1, fecha2, rol);
    }

    public List<ConversacionDetalle> obtenerConversacion(String identificador) {
        return this.conversacionDetalleDAO.obtenerConversacion(identificador);
    }

    public int obtenerTokens(Date fecha1, Date fecha2, String rol) {
        if (this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2, rol) != null) {
            return Integer.valueOf(this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2, rol));
        }
        return 0;
    }

    public List<Calificacion> listadoCalificacionConversacion(Long id_conversacion) {
        return this.calificacionDAO.listadoCalificacionConversacion(id_conversacion);
    }

    public List<SeccionDocumento> obtenerPrompts(String descripcion) {
        this.log.info("LLego a pedir productos ------------------------------**************************");
        return this.seccionDAO.findAllRolSocio(descripcion);
    }

    public List<SeccionDocumento> obtenerPromptsCorresponsales(String descripcion) {
        this.log.info("LLego a pedir corresponsales ------------------------------**************************");
        return this.seccionDAO.findAllRolSocioCorresponsales(descripcion);
    }

    public String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 250);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONObject usage = responseJson.getJSONObject("usage");
        for (ConversacionUsuario seccion : lstConversation) {
            System.out.println(seccion.getRole());
            System.out.println(seccion.getContent());
        }
        this.tokens_conversacion = Integer.valueOf(usage.get("total_tokens").toString());
        System.out.println();
        System.out.println(this.tokens_conversacion);
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-ada-002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    public String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", temp);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public void generateEmbeddingsForProducts() {
        List lstSeccion = this.seccionDAO.listadoProductosNG();
        for (SeccionDocumento seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            String response = this.generateEmbedding(this.util.quitarTildes(prompt.toUpperCase()));
            System.out.println(this.util.quitarTildes(prompt.toUpperCase()));
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionDAO.save((Object)seccion);
        }
    }
}

