/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.ja.service.impl;

import ec.tws2.back.lhia.ja.dao.ActividadDAO;
import ec.tws2.back.lhia.ja.dao.CalificacionDAO;
import ec.tws2.back.lhia.ja.dao.CalificacionRespuestaUsuarioDAO;
import ec.tws2.back.lhia.ja.dao.CarpetaDAO;
import ec.tws2.back.lhia.ja.dao.ConversacionDAO;
import ec.tws2.back.lhia.ja.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.ja.dao.DocumentoDAO;
import ec.tws2.back.lhia.ja.dao.RolesDAO;
import ec.tws2.back.lhia.ja.dao.SeccionDocumentoDAO;
import ec.tws2.back.lhia.ja.data.CalificacionConsumo;
import ec.tws2.back.lhia.ja.data.CalificacionRespuesta;
import ec.tws2.back.lhia.ja.data.ConversacionUsuario;
import ec.tws2.back.lhia.ja.data.RespuestaPython;
import ec.tws2.back.lhia.ja.data.RespuestaVector;
import ec.tws2.back.lhia.ja.data.RolesPreguntas;
import ec.tws2.back.lhia.ja.data.TemasConsumo;
import ec.tws2.back.lhia.ja.data.UsuariosConsumo;
import ec.tws2.back.lhia.ja.entity.Actividad;
import ec.tws2.back.lhia.ja.entity.Calificacion;
import ec.tws2.back.lhia.ja.entity.CalificacionRespuestaUsuario;
import ec.tws2.back.lhia.ja.entity.Carpeta;
import ec.tws2.back.lhia.ja.entity.Conversacion;
import ec.tws2.back.lhia.ja.entity.ConversacionDetalle;
import ec.tws2.back.lhia.ja.entity.Documento;
import ec.tws2.back.lhia.ja.entity.Roles;
import ec.tws2.back.lhia.ja.entity.SeccionDocumento;
import ec.tws2.back.lhia.ja.service.JaRepository;
import ec.tws2.back.lhia.ja.util.UtilLhia;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class JaRepositoryImpl
implements JaRepository {
    private Logger log = Logger.getLogger(JaRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private CalificacionRespuestaUsuarioDAO calificacionRespuestaUsuarioDAO;
    @Autowired
    private SeccionDocumentoDAO seccionDAO;
    @Autowired
    private RolesDAO rolesDAO;
    @Autowired
    private CarpetaDAO carpetaDAO;
    @Autowired
    private CalificacionDAO calificacionDAO;
    @Autowired
    private ActividadDAO actividadDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();
    private int tokens_conversacion = 0;
    private String textSystem = "";

    public String findProductsByQuestion(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaOpenIa(question, descripcion, identificador, usuario, lstConversation);
        return respuestaRobot;
    }

    public String preguntaPython(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaPythonLhia(question, descripcion, identificador, usuario, lstConversation);
        return respuestaRobot;
    }

    public String preguntaPgVector(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaPgVector(question, descripcion, identificador, usuario, lstConversation);
        return respuestaRobot;
    }

    public String preguntaMilvus(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaMilvus(question, descripcion, identificador, usuario, lstConversation);
        return respuestaRobot;
    }

    public String respuestaOpenIa(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "Debes realizar lo siguientes:1. Responde resumiendo la informacion lo mas posible y de una manera clara y precisa en estilo de texto plano enfocandote en la pregunta realizada por el usuario y no agregando informacion extra2. actua como asistente virtual de la cooperativa Jardin Azuayo del Ecuador llamado JARVI usando el rol colaborador de la cooperativa3. usa solo la informacion proporcionada en el contexto entregado, no accedas a la informacion de openia y tampoco menciones que eres de Ecuador4. enfocate en responder la pregunta usando la informacion porporcionada en el contexto entregado y en una manera informal conocido como tutear5. no agreges a la respuesta informacion adicional, adem\u00e1s no aumentes mas informaci\u00f3n que cabe ser mencionada 6. en caso que la pregunta no se pueda responder o no se tenga informacion con la cual responder a la pregunta en el contexto entregado recomendar llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico ya que los usuarios que porporcionan la pregunta son parte de la cooperativa7. si el contexto entregado no es suficiente, solicita mas informacion al usuario para poder entregar una respuesta8. si existe la informacion necesaria en el contexto entregado para responder las preguntas no recomiendes llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico 9. si la pregunta es Hola responder con que eres un asistente virtual llamado JARVI de la cooperativa Jardin Azuayo en que puedes ayudar o con 'Hola, soy JARVI tu asistente de Inteligencia Artificial, \u00bfQue necesitas?'10. entregar en la respuesta enlistandola con vi\u00f1etas o lineas -, solo lo neccesario11. entregar en la respuesta codigos markdown si existen en el contexto12. unicamente cuando el usuario pregunte de donde se obtuvo la informaci\u00f3n entrega esa informacion, caso contrario no entregue de donde obtuviste la informacion13. en preguntas de cargos que desempe\u00f1an los empleados dentro de la cooperativa solo si encuentras informacion relacionada al cargo preguntado en especifico entrega la repsuesta caso contrario solicita mas informacion ya que no pueden haber 2 empleados con el mismo cargo esto en gerentes, responsable, directores , etc";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getActor().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getAdicional()));
            }
            if (!c.getActor().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getRespuesta()));
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replace("DPF", "Dep\u00f3sito a Plazo fijo O DPF O Certificado de Dep\u00f3sito a Plazo O CDP o Poliza").replace("CDP", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("POLIZA", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("CJ", "Costo Judicial O CJ").replace("CHANCHITO", "Ahorro Programado Mi Ahorro Chanchito").replace("EMPRESA", "PERSONA JURIDICA O EMPRESA").replace("PJ", "PERSONA JURIDICA O PJ").replace("ORGANIZACIONES DE HECHO", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS").replace("OH", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS U OH").replace("OFICINA", "AGENCIA O SUCURSAL").replace("AGENCIA", "OFICINA O SUCURSAL").replace("SUCURSAL", "AGENCIA O AGENCIA");
        System.out.println("********idea*********");
        String idea = this.respondePreguntasV3("frase : " + pregunta + ", devuelve la palabra 'si' si la frase contiene conectores como 'y' al inicio de la conversacion o no tiene una idea completa caso contrario devuelve la palabra 'no, ademas entrega solo las palabras sin explicaciones", Double.valueOf(0.2));
        System.out.println(idea);
        if (idea.toUpperCase().contains("SI")) {
            String oracion = this.respondePreguntasV3("frase 1: " + (conversacion.size() > 0 ? ((ConversacionDetalle)conversacion.get(conversacion.size() - 2)).getAdicional() : "") + ", frase 2: " + pregunta + ", forma una sola frase tomando la informacion de la frase 2 y reemplazandola en la frase 1 donde ademas solamente sera reemplazando el sujeto de la frase 2 en la frase 1 ", Double.valueOf(0.2));
            System.out.println(oracion);
            idea = oracion;
        } else {
            idea = pregunta;
        }
        System.out.println("********idea*********");
        String corresponsales = this.respondePreguntasV3("verifica si la palabra 'corresponsal' est\u00e1 presente en la frase " + idea + " y responde con 'corresponsal' si est\u00e1 presente y 'no' si no lo est\u00e1.", Double.valueOf(0.2));
        System.out.println(corresponsales);
        String jaTiendas = this.respondePreguntasV3("verifica si la palabra 'tienda' o la palabra 'ja tienda' o la palabra 'jatienda'  est\u00e1 presente en la frase " + idea + " y responde con 'tienda' si est\u00e1 presente y 'no' si no lo est\u00e1.", Double.valueOf(0.2));
        System.out.println(jaTiendas);
        System.out.println(pregunta);
        String embedding = this.generateEmbedding(this.util.quitarTildes(idea.toUpperCase()).replace("\u00bf", "").replace("?", "").strip());
        this.log.info("Inicio de actividad" + String.valueOf(Instant.now()));
        List secciones = new ArrayList();
        secciones = corresponsales.toUpperCase().contains("CORRESPONSAL") ? this.obtenerPromptsCorresponsales(descripcion) : (jaTiendas.toUpperCase().contains("TIENDA") ? this.obtenerPromptsJaTiendas(descripcion) : this.obtenerPromptsGeneral(descripcion));
        String promptPrincipal = "pregunta del usuario: " + idea.replaceAll("\n", " ");
        this.log.info("Procesando " + String.valueOf(Instant.now()));
        System.out.println(promptPrincipal);
        double maxSimilarity = 0.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        ArrayList<SeccionDocumento> masSimilar = new ArrayList<SeccionDocumento>();
        for (SeccionDocumento seccion : secciones) {
            double similarity = this.util.cosineSimilarity(seccion.getEmbedding(), embedding);
            if (!(similarity > maxSimilarity)) continue;
            maxSimilarity = similarity;
            seccion.setScore(maxSimilarity);
            if (!(maxSimilarity >= 0.55)) continue;
            masSimilar.add(seccion);
            System.out.println(seccion.getTexto() + "\n Score:  " + seccion.getScore());
        }
        if (masSimilar.size() > 0) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + ((SeccionDocumento)masSimilar.get(masSimilar.size() - 1)).getDocumento().getNombre();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            for (SeccionDocumento seccion : masSimilar) {
                resultadoBusqueda.append(seccion.getTexto()).append("\n\n");
            }
            prompt = "contexto entregado: " + String.valueOf(resultadoBusqueda) + "\n";
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, ((SeccionDocumento)masSimilar.get(masSimilar.size() - 1)).getDocumento().getNombre(), identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptCompleto, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptCompleto)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer + " " + documentoInformacion, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        } else {
            conversacionUsuario.add(new ConversacionUsuario("user", promptPrincipal));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, "ADICIONAL", identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptPrincipal, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptPrincipal)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        }
        this.log.info("Finalizado " + String.valueOf(Instant.now()));
        return answer;
    }

    public String respuestaPythonLhia(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        String answer = "";
        this.textSystem = "Debes realizar lo siguientes:1. Responde de manera clara y precisa en estilo de texto plano enfocandote en la pregunta realizada por el usuario no agregando informacion extra2. actua como asistente virtual de la cooperativa Jardin Azuayo del Ecuador llamado JARVI usando el rol colaborador de la cooperativa3. usa solo la informacion proporcionada en el contexto, no accedas a la informacion de openia y tampoco menciones que eres de Ecuador4. enfocate en responder la pregunta en 350 tokens usando la informacion porporcionada en el contexto y en una manera informal conocido como tutear5. no agreges a la respuesta informacion adicional, adem\u00e1s no aumentes mas informaci\u00f3n que cabe ser mencionada 6. en caso que la pregunta no se pueda responder o no se tenga informacion recomendar llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico ya que los usuarios que porporcionan la pregunta son parte de la cooperativa7. solicita mas informacion para poder entregar una respuesta si el contexto entregado no es suficiente8. si existe la informacion necesaria para responder las preguntas no recomiendes llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico 9. si la pregunta es Hola responder con que eres un asistente virtual llamado JARVI de la cooperativa Jardin Azuayo en que puedes ayudar o con 'Hola, soy JARVI tu asistente de Inteligencia Artificial, \u00bfQue necesitas?'";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.textSystem));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getActor().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getAdicional()));
            }
            if (!c.getActor().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getRespuesta()));
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replace("CJ", "Costo Judicial").replace("EMPRESA", "PERSONA JURIDICA O EMPRESA").replace("PJ", "PERSONA JURIDICA O PJ").replace("ORGANIZACIONES DE HECHO", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS").replace("OH", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS U OH");
        RespuestaPython respuestaPython = (RespuestaPython)this.respondePreguntasPython(pregunta, identificador).getBody();
        if (respuestaPython.getDocumento().size() > 0) {
            answer = respuestaPython.getRespuesta();
            String promptCompleto = "hola" + pregunta + (String)respuestaPython.getDocumento().get(0);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            this.guardarActividad(pregunta.replaceAll("\n", ""), answer, (String)respuestaPython.getDocumento().get(0), identificador);
            this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
            this.guardarConversacion(identificador, usuario, "user", promptCompleto, pregunta.replaceAll("\n", ""), 0.0, this.util.conteoTokens(this.textSystem.concat(promptCompleto)) + this.tokens_conversacion, descripcion);
            this.guardarConversacion(identificador, usuario, "assistant", answer + " " + (String)respuestaPython.getDocumento().get(0), "", 0.0, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            return answer;
        }
        answer = respuestaPython.getRespuesta();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        this.guardarActividad(pregunta.replaceAll("\n", ""), answer, "ADICIONAL", identificador);
        this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
        this.guardarConversacion(identificador, usuario, "user", "nada" + pregunta, pregunta.replaceAll("\n", ""), 0.0, this.util.conteoTokens(this.textSystem.concat("nada" + pregunta)) + this.tokens_conversacion, descripcion);
        this.guardarConversacion(identificador, usuario, "assistant", answer, "", 0.0, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
        return answer;
    }

    public String respuestaPgVector(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "Debes realizar lo siguientes:1. Responde resumiendo la informacion lo mas posible y de una manera clara y precisa en estilo de texto plano enfocandote en la pregunta realizada por el usuario y no agregando informacion extra2. actua como asistente virtual de la cooperativa Jardin Azuayo del Ecuador llamado JARVI usando el rol colaborador de la cooperativa3. usa solo la informacion proporcionada en el contexto entregado, no accedas a la informacion de openia y tampoco menciones que eres de Ecuador4. enfocate en responder la pregunta usando la informacion porporcionada en el contexto entregado y en una manera informal conocido como tutear5. no agreges a la respuesta informacion adicional, adem\u00e1s no aumentes mas informaci\u00f3n que cabe ser mencionada 6. en caso que la pregunta no se pueda responder o no se tenga informacion con la cual responder a la pregunta en el contexto entregado recomendar llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico ya que los usuarios que porporcionan la pregunta son parte de la cooperativa7. si el contexto entregado no es suficiente, solicita mas informacion al usuario para poder entregar una respuesta8. si existe la informacion necesaria en el contexto entregado para responder las preguntas no recomiendes llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico 9. si la pregunta es Hola responder con que eres un asistente virtual llamado JARVI de la cooperativa Jardin Azuayo en que puedes ayudar o con 'Hola, soy JARVI tu asistente de Inteligencia Artificial, \u00bfQue necesitas?'10. entregar en la respuesta enlistandola con vi\u00f1etas o lineas -, solo lo neccesario11. entregar en la respuesta codigos markdown si existen en el contexto12. unicamente cuando el usuario pregunte de donde se obtuvo la informaci\u00f3n entrega esa informacion, caso contrario no entregue de donde obtuviste la informacion";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getActor().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getAdicional()));
            }
            if (!c.getActor().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getRespuesta()));
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replace("DPF", "Dep\u00f3sito a Plazo fijo O DPF O Certificado de Dep\u00f3sito a Plazo O CDP o Poliza").replace("CDP", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("POLIZA", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("CJ", "Costo Judicial O CJ").replace("CHANCHITO", "Ahorro Programado Mi Ahorro Chanchito").replace("EMPRESA", "PERSONA JURIDICA O EMPRESA").replace("PJ", "PERSONA JURIDICA O PJ").replace("ORGANIZACIONES DE HECHO", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS").replace("OH", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS U OH").replace("OFICINA", "AGENCIA O SUCURSAL").replace("AGENCIA", "OFICINA O SUCURSAL").replace("SUCURSAL", "AGENCIA O AGENCIA");
        System.out.println("********idea*********");
        String idea = this.respondePreguntasV3("frase : " + pregunta + ", devuelve la palabra 'si' si la frase contiene conectores como 'y' al inicio de la conversacion o no tiene una idea completa caso contrario devuelve la palabra 'no, ademas entrega solo las palabras sin explicaciones", Double.valueOf(0.2));
        System.out.println(idea);
        if (idea.toUpperCase().contains("SI")) {
            String oracion = this.respondePreguntasV3("frase 1: " + (conversacion.size() > 0 ? ((ConversacionDetalle)conversacion.get(conversacion.size() - 2)).getAdicional() : "") + ", frase 2: " + pregunta + ", forma una sola frase tomando la informacion de la frase 2 y reemplazandola en la frase 1 donde ademas solamente sera reemplazando el sujeto de la frase 2 en la frase 1 ", Double.valueOf(0.2));
            System.out.println(oracion);
            idea = oracion;
        } else {
            idea = pregunta;
        }
        String promptPrincipal = "pregunta del usuario: " + idea.replaceAll("\n", " ");
        double maxSimilarity = 0.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasPgVector(pregunta).getBody();
        if (respuestaVector != null) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n";
            System.out.println(respuestaVector.getContenido());
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, respuestaVector.getDocumento(), identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptCompleto, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptCompleto)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer + " " + documentoInformacion, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        } else {
            conversacionUsuario.add(new ConversacionUsuario("user", promptPrincipal));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, "ADICIONAL", identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptPrincipal, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptPrincipal)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        }
        this.log.info("Finalizado " + String.valueOf(Instant.now()));
        return answer;
    }

    public String respuestaMilvus(String question, String descripcion, String identificador, String usuario, List<ConversacionUsuario> lstConversation) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "Debes realizar lo siguientes:1. Responde resumiendo la informacion lo mas posible y de una manera clara y precisa en estilo de texto plano enfocandote en la pregunta realizada por el usuario y no agregando informacion extra2. actua como asistente virtual de la cooperativa Jardin Azuayo del Ecuador llamado JARVI usando el rol colaborador de la cooperativa3. usa solo la informacion proporcionada en el contexto entregado, no accedas a la informacion de openia y tampoco menciones que eres de Ecuador4. enfocate en responder la pregunta usando la informacion porporcionada en el contexto entregado y en una manera informal conocido como tutear5. no agreges a la respuesta informacion adicional, adem\u00e1s no aumentes mas informaci\u00f3n que cabe ser mencionada 6. en caso que la pregunta no se pueda responder o no se tenga informacion con la cual responder a la pregunta en el contexto entregado recomendar llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico ya que los usuarios que porporcionan la pregunta son parte de la cooperativa7. si el contexto entregado no es suficiente, solicita mas informacion al usuario para poder entregar una respuesta8. si existe la informacion necesaria en el contexto entregado para responder las preguntas no recomiendes llamar al 55555 de la Mesa de Servicios, opci\u00f3n 2 Soporte Operativo u opci\u00f3n 3 Soporte T\u00e9cnico 9. si la pregunta es Hola responder con que eres un asistente virtual llamado JARVI de la cooperativa Jardin Azuayo en que puedes ayudar o con 'Hola, soy JARVI tu asistente de Inteligencia Artificial, \u00bfQue necesitas?'10. entregar en la respuesta enlistandola con vi\u00f1etas o lineas -, solo lo neccesario11. entregar en la respuesta codigos markdown si existen en el contexto12. unicamente cuando el usuario pregunte de donde se obtuvo la informaci\u00f3n entrega esa informacion, caso contrario no entregue de donde obtuviste la informacion";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getActor().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getAdicional()));
            }
            if (!c.getActor().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getActor(), c.getRespuesta()));
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replace("DPF", "Dep\u00f3sito a Plazo fijo O DPF O Certificado de Dep\u00f3sito a Plazo O CDP o Poliza").replace("CDP", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("POLIZA", "Certificado de Dep\u00f3sito a Plazo O CDP O Dep\u00f3sito a Plazo fijo O DPF o Poliza").replace("CJ", "Costo Judicial O CJ").replace("CHANCHITO", "Ahorro Programado Mi Ahorro Chanchito").replace("EMPRESA", "PERSONA JURIDICA O EMPRESA").replace("PJ", "PERSONA JURIDICA O PJ").replace("ORGANIZACIONES DE HECHO", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS").replace("OH", "ORGANIZACIONES POPULARES Y ENTES COLECTIVOS U OH").replace("OFICINA", "AGENCIA O SUCURSAL").replace("COSEDE", "Corporaci\u00f3n del Seguro de Dep\u00f3sitos o COSEDE");
        System.out.println("********idea*********");
        String idea = this.respondePreguntasV3("frase : " + pregunta + ", devuelve la palabra 'si' si la frase contiene conectores como 'y' al inicio de la conversacion o no tiene una idea completa es decir sujeto, verbo y predicado caso contrario devuelve la palabra 'no, ademas entrega solo las palabras sin explicaciones", Double.valueOf(0.2));
        System.out.println(idea);
        if (idea.toUpperCase().contains("SI")) {
            String oracion = this.respondePreguntasV3("frase 1: " + (conversacion.size() > 0 ? ((ConversacionDetalle)conversacion.get(conversacion.size() - 2)).getAdicional() : "") + ", frase 2: " + pregunta + ", forma una sola frase tomando la informacion de la frase 2 y reemplazandola en la frase 1 donde ademas solamente sera reemplazando el sujeto de la frase 2 en la frase 1 ", Double.valueOf(0.2));
            System.out.println(oracion);
            idea = oracion.toUpperCase();
        } else {
            idea = pregunta;
        }
        String promptPrincipal = "pregunta del usuario: " + idea.replaceAll("\n", "");
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvus(idea).getBody();
        if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n";
            System.out.println(respuestaVector.getContenido());
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, respuestaVector.getDocumento(), identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptCompleto, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptCompleto)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer + " " + documentoInformacion, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        } else {
            conversacionUsuario.add(new ConversacionUsuario("user", promptPrincipal));
            answer = this.respondePreguntasV2(conversacionUsuario);
            if (!answer.isEmpty()) {
                this.guardarActividad(idea.replaceAll("\n", ""), answer, "ADICIONAL", identificador);
                this.guardarConversacion(identificador, usuario, "", "", "", 0.0, 0, descripcion);
                this.guardarConversacion(identificador, usuario, "user", promptPrincipal, idea.replaceAll("\n", ""), scoreFinal, this.util.conteoTokens(this.textSystem.concat(promptPrincipal)) + this.tokens_conversacion, descripcion);
                this.guardarConversacion(identificador, usuario, "assistant", answer, "", scoreFinal, this.util.conteoTokens(answer) + this.tokens_conversacion, descripcion);
            }
        }
        this.log.info("Finalizado " + String.valueOf(Instant.now()));
        return answer;
    }

    public void guardarActividad(String pregunta, String respuesta, String nombre_documento, String identificador) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            Documento documento = this.documentoDAO.buscarPorNombre(nombre_documento);
            Carpeta carpeta = documento != null ? (Carpeta)this.carpetaDAO.findById((Object)documento.getCarpeta().getId_carpeta()).get() : this.carpetaDAO.findByNombre(nombre_documento);
            Actividad actividad = new Actividad();
            actividad.setTexto_pregunta(pregunta);
            actividad.setTexto_respuesta(respuesta);
            actividad.setFecha(this.util.fechaEcuador());
            actividad.setCarpetas(carpeta);
            actividad.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
            this.actividadDAO.save((Object)actividad);
        }
    }

    public void guardarConversacion(String identificador, String usuario, String actor, String respuesta, String adicional, double score, int tokens, String descripcion) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!actor.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setActor(actor);
                conversacion_detalle.setRespuesta(respuesta);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens(tokens);
                conversacion_detalle.setAdicional(adicional);
                conversacion_detalle.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(this.util.fechaEcuador());
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setRoles((Roles)this.rolesDAO.findByDescripcion(descripcion).get());
            nueva_conversacion.setFecha(this.util.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setActor("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setRespuesta(this.textSystem);
            conversacion_detalle.setTokens(0);
            conversacion_detalle.setId_conversacion(aux);
            conversacion_detalle.setFecha(this.util.fechaEcuador());
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseEntity<?> guardarCalificacion(String identificador, String calificacion) {
        try {
            if (this.conversacionDAO.existsByIdentificador(identificador)) {
                Calificacion calificacion_ = new Calificacion();
                calificacion_.setCalificacion(calificacion);
                calificacion_.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                calificacion_.setFecha(this.util.fechaEcuador());
                return ResponseEntity.ok((Object)((Calificacion)this.calificacionDAO.save((Object)calificacion_)));
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    public ResponseEntity<?> guardarCalificacionRespuestaUsuario(String identificador, String calificacion) {
        try {
            if (this.conversacionDAO.existsByIdentificador(identificador)) {
                CalificacionRespuestaUsuario calificacion_ = new CalificacionRespuestaUsuario();
                calificacion_.setCalificacion(calificacion);
                calificacion_.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                calificacion_.setFecha(this.util.fechaEcuador());
                return ResponseEntity.ok((Object)((CalificacionRespuestaUsuario)this.calificacionRespuestaUsuarioDAO.save((Object)calificacion_)));
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    public List<CalificacionConsumo> obtenerCalificacionesRespuestaUsuario(Date fecha1, Date fecha2, String rol) {
        return this.calificacionRespuestaUsuarioDAO.listadoCalificacionRespuestaFrecuencia(fecha1, fecha2, rol);
    }

    public List<CalificacionConsumo> obtenerCalificaciones(Date fecha1, Date fecha2, String rol) {
        return this.calificacionDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol);
    }

    public List<RolesPreguntas> obtenerNumeroPreguntasRol(Date fecha1, Date fecha2) {
        return this.rolesDAO.obtenerNumeroPreguntasRol(fecha1, fecha2);
    }

    public List<Actividad> listadoActividadCarpetas(Long id) {
        return this.actividadDAO.listadoActividadCarpetas(id);
    }

    public List<TemasConsumo> obtenerTemas(Date fecha1, Date fecha2, String rol) {
        return this.actividadDAO.listadoTemasFrecuencia(fecha1, fecha2, rol);
    }

    public List<ConversacionDetalle> obtenerConversacion(String identificador) {
        return this.conversacionDetalleDAO.obtenerConversacion(identificador);
    }

    public int obtenerTokens(Date fecha1, Date fecha2, String rol) {
        if (this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2, rol) != null) {
            return Integer.valueOf(this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2, rol));
        }
        return 0;
    }

    public List<UsuariosConsumo> obtenerlistadoUsuarios(Date fecha1, Date fecha2) {
        return this.conversacionDAO.listadoUsuarios(fecha1, fecha2);
    }

    public List<Calificacion> listadoCalificacionConversacion(Long id_conversacion) {
        return this.calificacionDAO.listadoCalificacionConversacion(id_conversacion);
    }

    public List<SeccionDocumento> obtenerPromptsGeneral(String descripcion) {
        this.log.info("LLego a pedir productos ------------------------------**************************");
        return this.seccionDAO.findAllRoles(descripcion);
    }

    public List<SeccionDocumento> obtenerPromptsCorresponsales(String descripcion) {
        this.log.info("LLego a pedir corresponsales ------------------------------**************************");
        return this.seccionDAO.findAllRolesColaboradorCorresponsal(descripcion);
    }

    public List<SeccionDocumento> obtenerPromptsJaTiendas(String descripcion) {
        this.log.info("LLego a pedir ja tiendas ------------------------------**************************");
        return this.seccionDAO.findAllRolesColaboradorTiendas(descripcion);
    }

    public ResponseEntity<RespuestaPython> respondePreguntasPython(String pregunta, String sesion) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"sesion", (Object)sesion);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta", (Object)request, RespuestaPython.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasPgVector(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_pgvector", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvus(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_milvus", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 600);
        requestBody.put("temperature", 0.5);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONObject usage = responseJson.getJSONObject("usage");
        this.tokens_conversacion = Integer.valueOf(usage.get("total_tokens").toString());
        System.out.println(this.tokens_conversacion);
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    private String respondePreguntasV3(String pregunta, Double temp) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("messages", conversacionUsuario);
        requestBody.put("max_tokens", 240);
        requestBody.put("temperature", temp);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public List<String> findClosestLocation(List<SeccionDocumento> locations, double targetLat, double targetLon) {
        List<SeccionDocumento> sortedLocations = locations;
        sortedLocations.sort(Comparator.comparingDouble(location -> this.util.calculateDistance(targetLat, targetLon, Double.parseDouble(location.getLatitud()), Double.parseDouble(location.getLongitud()))));
        ArrayList<String> closestLocations = new ArrayList<String>();
        int i = 0;
        while (i < Math.min(5, sortedLocations.size())) {
            closestLocations.add(sortedLocations.get(i).getTexto());
            ++i;
        }
        return closestLocations;
    }

    public String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", temp);
        requestBody.put("top_p", 1);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public void generateEmbeddingsForProducts() {
        List lstSeccion = this.seccionDAO.listadoProductosNG();
        for (SeccionDocumento seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            String response = this.generateEmbedding(this.util.quitarTildes(prompt.toUpperCase()));
            System.out.println("\n" + this.util.quitarTildes(prompt.toUpperCase()));
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionDAO.save((Object)seccion);
        }
    }

    public String calificacionRespuesta(CalificacionRespuesta calificacionRespuesta) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"username", (Object)"calificador-ja");
        formData.add((Object)"password", (Object)"calificador-ja.2012");
        formData.add((Object)"client_id", (Object)"logueoBack");
        formData.add((Object)"grant_type", (Object)"password");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)formData, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("https://login.tws2.io/auth/realms/services/protocol/openid-connect/token", (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        String acces_token = responseJson.getString("access_token");
        System.out.println(acces_token);
        HttpHeaders headersCalificacion = new HttpHeaders();
        headersCalificacion.setContentType(MediaType.APPLICATION_JSON);
        headersCalificacion.set("Authorization", "Bearer " + acces_token);
        HttpEntity requestEntity = new HttpEntity((Object)calificacionRespuesta, (MultiValueMap)headersCalificacion);
        ResponseEntity responseCalificacion = this.restTemplate.postForEntity("https://services.lhia.ai/proceso/nuevoProcesoBt", (Object)requestEntity, String.class, new Object[0]);
        return (String)responseCalificacion.getBody();
    }
}

