/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.ja.controller;

import ec.tws2.back.lhia.ja.data.CalificacionConsumo;
import ec.tws2.back.lhia.ja.data.ClienteConsumo;
import ec.tws2.back.lhia.ja.data.RespuestaRobot;
import ec.tws2.back.lhia.ja.data.RolesPreguntas;
import ec.tws2.back.lhia.ja.data.TemasConsumo;
import ec.tws2.back.lhia.ja.entity.Actividad;
import ec.tws2.back.lhia.ja.entity.Calificacion;
import ec.tws2.back.lhia.ja.service.JaSocioRepository;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ja-socio"})
public class ProductControllerSocio {
    @Autowired
    JaSocioRepository jaSocioRepository;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProduct(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            String answer = this.jaSocioRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
            robot.setRespuesta(answer);
            return robot;
        });
    }

    @PostMapping(value={"/lista/temas"}, produces={"application/json"})
    @CrossOrigin
    public List<TemasConsumo> obtenerPreguntas(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.jaSocioRepository.obtenerTemas(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/preguntas"}, produces={"application/json"})
    public List<Actividad> listadoActividadCarpetas(@RequestParam Long id) {
        return this.jaSocioRepository.listadoActividadCarpetas(id);
    }

    @PostMapping(value={"/lista/calificaciones"}, produces={"application/json"})
    @CrossOrigin
    public List<CalificacionConsumo> obtenerCalificaciones(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.jaSocioRepository.obtenerCalificaciones(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/rol/total_preguntas"}, produces={"application/json"})
    @CrossOrigin
    public List<RolesPreguntas> obtenerNumeroPreguntasRol(@RequestParam Date fecha1, Date fecha2) {
        return this.jaSocioRepository.obtenerNumeroPreguntasRol(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/conversacion/tokens"}, produces={"application/json"})
    public int obtenerTokens(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.jaSocioRepository.obtenerTokens(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/calificacion_conversacion"}, produces={"application/json"})
    public List<Calificacion> obtenerConversacion(@RequestParam Long id_conversacion) {
        return this.jaSocioRepository.listadoCalificacionConversacion(id_conversacion);
    }

    @PostMapping(value={"/servicio/calificacion"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacion(@RequestParam String identificador, @RequestParam String calificacion) {
        return this.jaSocioRepository.guardarCalificacion(identificador, calificacion);
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.jaSocioRepository.generateEmbeddingsForProducts();
    }
}

