/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.contfiables.controller;

import ec.tws2.back.lhia.contfiables.data.ClienteConsumo;
import ec.tws2.back.lhia.contfiables.data.RespuestaRobot;
import ec.tws2.back.lhia.contfiables.service.JaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ja"})
public class ProductController_ja {
    @Autowired
    JaRepository jaRepository;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.jaRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.jaRepository.generateEmbeddingsForProducts();
    }

    @GetMapping(value={"/generaNumTokens"})
    @CrossOrigin
    public void generaNumTokens() {
        this.jaRepository.generateNumTokens();
    }
}

