/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.contfiables.controller;

import ec.tws2.back.lhia.contfiables.data.ClienteConsumo;
import ec.tws2.back.lhia.contfiables.data.RespuestaRobot;
import ec.tws2.back.lhia.contfiables.service.ErcoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"erco"})
public class ProductController_erco {
    @Autowired
    ErcoRepository ercoRepository;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.ercoRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.ercoRepository.generateEmbeddingsForProducts();
    }

    @GetMapping(value={"/generaNumTokens"})
    @CrossOrigin
    public void generaNumTokens() {
        this.ercoRepository.generateNumTokens();
    }
}

