/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.contfiables.config;

import ec.tws2.back.lhia.contfiables.config.JwtAuthConverterProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
    private JwtGrantedAuthoritiesConverter jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    private final JwtAuthConverterProperties properties;

    public JwtAuthConverter(JwtAuthConverterProperties properties) {
        this.properties = properties;
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = this.extractResourceRoles(jwt);
        return new JwtAuthenticationToken(jwt, authorities, this.getPrincipalClaimName(jwt));
    }

    private String getPrincipalClaimName(Jwt jwt) {
        String claimName = "sub";
        if (this.properties.getPrincipalAttribute() != null) {
            claimName = this.properties.getPrincipalAttribute();
        }
        return (String)jwt.getClaim(claimName);
    }

    private Collection<GrantedAuthority> extractResourceRoles(Jwt jwt) {
        Collection resourceRoles;
        Map resourceAccess = (Map)jwt.getClaim("realm_access");
        if (resourceAccess == null || (resourceRoles = (Collection)resourceAccess.get("roles")) == null) {
            return Collections.emptySet();
        }
        return resourceRoles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).collect(Collectors.toSet());
    }
}

