/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.base.back.lhia.util;

import ec.tws2.base.back.lhia.data.ConversacionUsuario;
import ec.tws2.base.back.lhia.util.Content;
import ec.tws2.base.back.lhia.util.ImageUrl;
import ec.tws2.base.back.lhia.util.Message;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public class UtilLhia {
    private Logger log = Logger.getLogger(UtilLhia.class.getName());

    public void mostrarLista(List<ConversacionUsuario> lstConversation) {
        this.log.info("------------------------------------------------------------------------");
        for (int i = 0; i < lstConversation.size(); ++i) {
            this.log.info("rol:" + lstConversation.get(i).getRole());
            this.log.info("mensaje:" + lstConversation.get(i).getContent());
            this.log.info("------------------------------------------------------------------------");
        }
        this.log.info("------------------------------------------------------------------------");
    }

    public String obtenerUltimaRespuesta(List<ConversacionUsuario> lstConversation) {
        String resp = "";
        for (int i = lstConversation.size() - 1; i > 0; --i) {
            if (!lstConversation.get(i).getRole().equals("assistant")) continue;
            resp = lstConversation.get(i).getContent();
            break;
        }
        return resp;
    }

    public String parseEmbedding(String response) {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray("embedding");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringBuilder.append(jsonArray.getDouble(i));
            if (i == jsonArray.length() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public double cosineSimilarity(String embedding1, String embedding2) {
        double[] arr1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        double[] arr2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray();
        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < arr1.length; ++i) {
            dotProduct += arr1[i] * arr2[i];
            norm1 += Math.pow(arr1[i], 2.0);
            norm2 += Math.pow(arr2[i], 2.0);
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return 0.0;
        }
        return dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    public Date fechaEcuador() {
        ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
        LocalDateTime fechaHoraEcuador = LocalDateTime.now(zonaEcuador);
        return Date.from(fechaHoraEcuador.toInstant(ZoneOffset.UTC));
    }

    public String quitarTildes(String texto) {
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinTildes = textoNormalizado.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        textoSinTildes = textoSinTildes.replaceAll("\n", " ");
        return textoSinTildes;
    }

    public List<Message> createMessageImagenJson(String prompt, String url_imagen) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Content[] contents1 = new Content[]{new Content("text", "What's in this image?"), new Content("image_url", new ImageUrl("https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/Gfp-wisconsin-madison-the-nature-boardwalk.jpg/2560px-Gfp-wisconsin-madison-the-nature-boardwalk.jpg"))};
        Message message1 = new Message("user", contents1);
        messages.add(message1);
        return messages;
    }
}

