/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.base.back.lhia.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import ec.tws2.base.back.lhia.dao.ConversacionDAO;
import ec.tws2.base.back.lhia.dao.ConversacionDetalleDAO;
import ec.tws2.base.back.lhia.dao.SeccionDocumentoDAO;
import ec.tws2.base.back.lhia.data.ConversacionUsuario;
import ec.tws2.base.back.lhia.data.RespuestaVector;
import ec.tws2.base.back.lhia.entity.Conversacion;
import ec.tws2.base.back.lhia.entity.ConversacionDetalle;
import ec.tws2.base.back.lhia.entity.SeccionDocumento;
import ec.tws2.base.back.lhia.service.BaseRepository;
import ec.tws2.base.back.lhia.util.UtilLhia;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseRepositoryImpl
implements BaseRepository {
    private Logger log = Logger.getLogger(BaseRepositoryImpl.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private SeccionDocumentoDAO seccionDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    private String textSystem = "";

    public String preguntaMilvus(String question, String descripcion, String identificador, String usuario) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaMilvus(question, descripcion, identificador, usuario);
        return respuestaRobot;
    }

    public String preguntaMilvusVentasDanec(String question, String descripcion, String identificador, String usuario) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaMilvusVentasDanec(question, descripcion, identificador, usuario);
        return respuestaRobot;
    }

    public String preguntaMilvusVCisne(String question, String descripcion, String identificador, String usuario) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaMilvusVCisne(question, descripcion, identificador, usuario);
        return respuestaRobot;
    }

    public String preguntaMilvusAcademico(String question, String descripcion, String identificador, String usuario) {
        String respuestaRobot = "";
        respuestaRobot = this.respuestaMilvusAcademico(question, descripcion, identificador, usuario);
        return respuestaRobot;
    }

    public String respuestaMilvus(String question, String descripcion, String identificador, String usuario) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "entrega respuestas consisas y directas agregando de que document, seccion y pagina se obtuvo la informacion ademas actua como un asistente de la empresa DANEC S.A la cual se dedica a atender las necesidades del mercado nacional en Ecuador Nos caracterizamos por tener un constante mejoramiento tanto en modernos equipos para la planta, como en el desarrollo de los procesos y actividades del personal, enmarcados en el modelo de gesti\u00f3n de calidad de la ISO 9001., ademas no respondas preguntas que se salgan del tema de DANEC S.A, para responder las preguntas usa solamente el contexto entregado1. si en el contexto entregado se encuentra codigo markdown entregalo en las repsuestas tal y como esta en el contexto entregado sin realizar cambios ni aumentar palabras si el codigo esta asi por ejemplo ![]() envialo en la respuesta tal y como esta no hagas cambios ya que enviarlo son modificaciones es necesario para procesarlo despues";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.toUpperCase();
        String promptPrincipal = "pregunta del usuario: " + pregunta;
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvus(pregunta).getBody();
        if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n";
            System.out.println((String)prompt);
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
        }
        this.log.info("Finalizado " + Instant.now());
        return answer;
    }

    public String respuestaMilvusVentasDanec(String question, String descripcion, String identificador, String usuario) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "reponde de una manera resumida y actua como un asistente de ventas que entrega un historico de compras de un cliente dependiendo de un producto buscado donde si se consulta acerca del historico de compras de un cliente se recomiende la compra del producto con mas ventas de unidades acorde al historico de compras y si es una consulta en base a bodegas entregar la informacion espeifica de esa bodega en el histico";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.toUpperCase();
        String promptPrincipal = "pregunta del usuario: " + pregunta;
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvusDanecVentas(pregunta).getBody();
        if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "historico de compras: " + respuestaVector.getContenido() + "\n";
            System.out.println((String)prompt);
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2Larga(conversacionUsuario);
        }
        this.log.info("Finalizado " + Instant.now());
        return answer;
    }

    public String respuestaMilvusVCisne(String question, String descripcion, String identificador, String usuario) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "actua como un asistente de la Cooperativa Virgen del Cisne llamado Lhia experto en operaciones financieras creado por la empresa 'Think web services and security S.A.S' (TWS2) empresa ubicada en el Ecuador entregando respuestas consisas y directas contestando las preguntas usando el contexto entregado";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.toUpperCase();
        String promptPrincipal = "pregunta del usuario: " + pregunta;
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvusVCisnes(pregunta.toUpperCase()).getBody();
        if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n";
            System.out.println((String)prompt);
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
        }
        this.log.info("Finalizado " + Instant.now());
        return answer;
    }

    public String respuestaMilvusAcademico(String question, String descripcion, String identificador, String usuario) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "actua como un asistente experto en Marketing entregando respuestas consisas y directas contestando las preguntas usando el contexto entregado";
        String answer = "";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.toUpperCase();
        String promptPrincipal = "pregunta del usuario: " + pregunta;
        Object prompt = "";
        double scoreFinal = 0.0;
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvusAcademico(pregunta.toUpperCase()).getBody();
        if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
            StringBuilder resultadoBusqueda = new StringBuilder();
            String documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
            resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
            prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n";
            System.out.println((String)prompt);
            String promptCompleto = ((String)prompt).concat(promptPrincipal);
            conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
            answer = this.respondePreguntasV2(conversacionUsuario);
        }
        this.log.info("Finalizado " + Instant.now());
        return answer;
    }

    public String findProductsByQuestion(String question, String descripcion, String identificador, String usuario) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = this.iniTextoNew = "Responde de manera clara y precisa actuando como una persona experta en la empresa 'Think web services and security S.A.S' (TWS2)antes de responder las preguntas sigue las siguientes indicaciones: 1. responde utilizando solamente 250 tokens2. enfocate en solo repsonder preguntas sobre la empresa TWS2 si se relaizan preguntas no referentes al contexto entregado no las respondas";
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_conversacion_detalle(), objeto2.getId_conversacion_detalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase() + " ";
        String promptPrincipal = pregunta.replaceAll("\n", "");
        String embedding = this.generateEmbedding(this.util.quitarTildes(pregunta.toUpperCase()).replace("\u00bf", "").replace("?", ""));
        this.log.info("--------------------llego acaaaaaaaaaaaaaaaaaa " + Instant.now());
        List secciones = this.obtenerPrompts(descripcion);
        this.log.info("--------------------pasooooooooooooooooooooooooooooo " + Instant.now());
        double maxSimilarity = 0.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        ArrayList<SeccionDocumento> masSimilar = new ArrayList<SeccionDocumento>();
        for (SeccionDocumento seccion : secciones) {
            double similarity = this.util.cosineSimilarity(embedding, seccion.getEmbedding());
            if (!(similarity > maxSimilarity)) continue;
            System.out.println("similar: " + similarity);
            System.out.println("mas similar: " + maxSimilarity);
            maxSimilarity = similarity;
            seccion.setScore(maxSimilarity);
            System.out.println("mas similar final: " + maxSimilarity);
            if (!(maxSimilarity >= 0.5)) continue;
            masSimilar.add(seccion);
        }
        if (masSimilar.size() > 0) {
            Comparator scoreComparator = (p1, p2) -> Double.compare(p2.getScore(), p1.getScore());
            Collections.sort(masSimilar, scoreComparator);
            List primerosCinco = masSimilar.subList(0, masSimilar.size());
            StringBuilder resultadoBusqueda = new StringBuilder();
            int count = 0;
            for (SeccionDocumento seccion : primerosCinco) {
                resultadoBusqueda.append("el resultado de la informacion " + count++ + " es el siguiente:\n");
                resultadoBusqueda.append(seccion.getTexto()).append("\n\n");
                System.out.println(seccion.getTexto() + " " + seccion.getScore());
            }
            scoreFinal = ((SeccionDocumento)masSimilar.get(0)).getScore();
            prompt = "contexto: el resultado de " + ((SeccionDocumento)masSimilar.get(0)).getDocumento().getNombre() + " es el siguiente: \n" + resultadoBusqueda + "\n";
            for (SeccionDocumento seccion : primerosCinco) {
                seccion.setScore(0.0);
            }
        } else {
            prompt = "contexto: no se encontro la informacion\n";
        }
        String promptCompleto = ((String)prompt).concat("pregunta: " + promptPrincipal);
        System.out.println(promptCompleto);
        conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
        String answer = this.respondePreguntasV2(conversacionUsuario);
        if (!answer.isEmpty()) {
            this.guardarConversacion(identificador, usuario, "", "", 0.0, 0, "");
            this.guardarConversacion(identificador, usuario, "user", promptCompleto, scoreFinal, this.encoding.countTokens(promptCompleto), pregunta);
            this.guardarConversacion(identificador, usuario, "assistant", answer, scoreFinal, this.encoding.countTokens(answer), "");
        }
        return answer;
    }

    public void guardarConversacion(String identificador, String usuario, String rol, String mensaje, double score, int prompts, String pregunta) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens(prompts);
                conversacion_detalle.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(this.util.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setFecha(this.util.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setRol("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(this.textSystem);
            conversacion_detalle.setTokens(0);
            conversacion_detalle.setId_conversacion(aux);
            conversacion_detalle.setFecha(this.util.fechaEcuador());
            conversacion_detalle.setPregunta("");
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvus(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_milvus", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusDanecVentas(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_milvus_danec_ventas", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusVCisnes(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_milvus_vcisne", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusAcademico(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_milvus_academico", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public void generateEmbeddingsForProducts() {
        List lstSeccion = this.seccionDAO.listadoProductosNG();
        for (SeccionDocumento seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            System.out.println(prompt);
            String response = this.generateEmbedding(this.util.quitarTildes(prompt.toUpperCase()));
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionDAO.save((Object)seccion);
        }
    }

    public String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", temp);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public void generateNumTokens() {
        List listaConversacionDetalle = this.conversacionDetalleDAO.findAll();
        for (ConversacionDetalle conversacionDetalle : listaConversacionDetalle) {
            if (!conversacionDetalle.getRol().equals("user") && !conversacionDetalle.getRol().equals("assistant")) continue;
            conversacionDetalle.setTokens(this.encoding.countTokens(conversacionDetalle.getMensaje()));
            this.conversacionDetalleDAO.save((Object)conversacionDetalle);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    private String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("temperature", 0.5);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 500);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public ResponseEntity<?> respuestaImagen() {
        return this.reconocimientoImagen();
    }

    private ResponseEntity<?> reconocimientoImagen() {
        String url = "https://api.openai.com/v1/chat/completions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.apiKey);
        HashMap<String, String> message1 = new HashMap<String, String>();
        message1.put("type", "text");
        message1.put("text", "verifica si la imagen corresponde a un comprobante de pago, si es asi devuelve en formato json como respuesta con el parametro respuesta: true ,caso contrario respuesta: false");
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("url", "https://upload.wikimedia.org/wikipedia/commons/thumb/6/64/Collage_of_Six_Cats-02.jpg/500px-Collage_of_Six_Cats-02.jpg");
        HashMap<String, Object> message2 = new HashMap<String, Object>();
        message2.put("type", "image_url");
        message2.put("image_url", image);
        HashMap<String, Object> userMessage = new HashMap<String, Object>();
        userMessage.put("role", "user");
        userMessage.put("content", Arrays.asList(message1, message2));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", "gpt-4o");
        requestBody.put("messages", Collections.singletonList(userMessage));
        requestBody.put("max_tokens", 10);
        HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (!response.getHeaders().getContentType().includes(MediaType.APPLICATION_JSON)) {
                throw new IllegalArgumentException("Invalid content type received: " + response.getHeaders().getContentType());
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree((String)response.getBody());
            String content = rootNode.path("choices").get(0).path("message").path("content").asText();
            int promptTokens = rootNode.path("usage").path("prompt_tokens").asInt();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("content", content);
            result.put("prompt_tokens", promptTokens);
            return ResponseEntity.ok(result);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body(Collections.singletonMap("error", e.getResponseBodyAsString()));
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(Collections.singletonMap("error", "An unexpected error occurred: " + e.getMessage()));
        }
    }

    private String respondePreguntasV2Larga(List<ConversacionUsuario> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("temperature", 0.5);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 1000);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    private String respondePreguntasV3(String pregunta, Double temp) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", conversacionUsuario);
        requestBody.put("max_tokens", 240);
        requestBody.put("temperature", temp);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public List<SeccionDocumento> obtenerPrompts(String descripcion) {
        this.log.info("LLego a pedir productos ------------------------------**************************");
        return this.seccionDAO.findAllRoles(descripcion);
    }

    public int obtenerTokens(Date fecha1, Date fecha2) {
        if (this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2) != null) {
            return Integer.valueOf(this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2));
        }
        return 0;
    }
}

