/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.base.back.lhia.controller;

import ec.tws2.base.back.lhia.data.ClienteConsumo;
import ec.tws2.base.back.lhia.data.RespuestaRobot;
import ec.tws2.base.back.lhia.service.BaseRepository;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"base"})
public class ProductController {
    @Autowired
    BaseRepository baseRepository;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.baseRepository.preguntaMilvus(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        return robot;
    }

    @PostMapping(value={"/questionV3DanecVentas"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductVentaDanec(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.baseRepository.preguntaMilvusVentasDanec(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        return robot;
    }

    @PostMapping(value={"/questionV3VCisne"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductVCisne(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.baseRepository.preguntaMilvusVCisne(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        return robot;
    }

    @PostMapping(value={"/questionV3Academico"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductAcademico(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.baseRepository.preguntaMilvusAcademico(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.baseRepository.generateEmbeddingsForProducts();
    }

    @GetMapping(value={"/generaNumTokens"})
    @CrossOrigin
    public void generaNumTokens() {
        this.baseRepository.generateNumTokens();
    }

    @PostMapping(value={"/lista/conversacion/tokens"}, produces={"application/json"})
    public int obtenerTokens(@RequestParam Date fecha1, Date fecha2) {
        return this.baseRepository.obtenerTokens(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/imagen"}, produces={"application/json"})
    public ResponseEntity<?> obtenerDescripcionImagen() {
        return this.baseRepository.respuestaImagen();
    }
}

