/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.coop.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import ec.tws2.back.lhia.coop.dao.ca.SeccionDocumentoCaDAO;
import ec.tws2.back.lhia.coop.dao.ca.T_CuentasCaDAO;
import ec.tws2.back.lhia.coop.dao.ca.T_MovimientosCaDAO;
import ec.tws2.back.lhia.coop.data.Conversacion;
import ec.tws2.back.lhia.coop.data.Credito;
import ec.tws2.back.lhia.coop.data.Cuenta;
import ec.tws2.back.lhia.coop.data.RespuestaVector;
import ec.tws2.back.lhia.coop.entity.ca.SeccionDocumentoCa;
import ec.tws2.back.lhia.coop.entity.ca.T_CuentasCa;
import ec.tws2.back.lhia.coop.entity.ca.T_MovimientosCa;
import ec.tws2.back.lhia.coop.service.CopCaRepository;
import ec.tws2.back.lhia.coop.util.EnvioCorreo;
import ec.tws2.back.lhia.coop.util.UtilLhia;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CopCaRepositoryImp
implements CopCaRepository {
    private Logger log = Logger.getLogger(CopCaRepositoryImp.class.getName());
    UtilLhia util = new UtilLhia();
    String iniTextoNew = "Eres un asistente virtual de la cooperativa de ahorro y credito ambato llamado Lhia, fuiste creado o desarollada por la empresa TWS2. reglas:1. no debes repsonder a temas que se salgan del contexto de la informacion de una cooperativa de ahorro y credito2. repsonderas usando el contexto entregado3. repsonderas de una manera amigable4. debes tener en cuenta esta informacion para dar repsuesta sobre creditos que tenemos estos tipos para relaizar claculos CR\u00c9DITO COMERCIAL PRIORITARIO - PYMES de 1 a 36 meses desde 20000 hasta 150000 dolares Destinado para capital de trabajo y adquisici\u00f3n de activos CR\u00c9DITO DE CONSUMO de 1 a 72 meses desde 300 hasta 100000 dolares Su destino es la adquisici\u00f3n de bienes de consumo, pago de servicios, adquisici\u00f3n o remodelaci\u00f3n de vivienda con garant\u00eda personal, o consolidaci\u00f3n de deudas, sus tipos son: - AUTOMOTRIZ de 1 a 72 meses desde 5000 hasta 100000 dolares Es el otorgado a personas naturales destinados a la adquisici\u00f3n o comercializaci\u00f3n de vehiculos. - PRIORITARIO de 1 a 72 meses desde 300 hasta 100000 dolares Destinado para la compra de bienes, servicioso gastos no relacionados con una actividad productiva, comercial y otras compras y gastos no incluidos en el segmento de consumo ordinario. MICRO CREDITO de 1 a 18, 36, 60, 72  meses desde 300 hasta 100000 dolares Es destinado para capital de trabajo, adquisici\u00f3n de activos, y adquisici\u00f3n de servicios, sus tipos son: - AGRICOLA Y GANADERO de 3 a 36 meses desde 300 hasta 10000 dolares Microcr\u00e9dito agricola y ganadero, otorgado a socios que se dedican a actividades agr\u00edcolas y ganaderas. - INVERSI\u00d3N de 1 a 72 meses desde 10000 hasta 100000 dolares Destinado para capital de trabajo, adquisici\u00f3n de activos (Maquinaria agricola y equipo caminero) y adquisci\u00f3n de servicios. - EMPRENDEDOR de 1 a 60 meses desde 1000 hasta 10000 dolares Destinado para capital de trabajo, adquisici\u00f3n de activos y adquisci\u00f3n de servicios. - FAMILIAR de 1 a 18 meses desde 300 hasta 1000 dolares Destinado para capital de trabajo, adquisici\u00f3n de activos y adquisci\u00f3n de servicios. CR\u00c9DITO VIVIENDA INMOVILIARIO de 60 a 180 meses desde 30000 hasta 100000 dolares Cumple con Cooperativa de Ahorro y Cr\u00e9dito Ambato tus objetivos y los de tus seres queridos, tu vivienda propia.5. responde con vi\u00f1etas de ser necesario para mejorar el entendimiento en un solo formato de texto, PAR ALISTAR ELEMEMENTOS O INFORMACION NO USES NUMEROS6. si no tienes la informacion necesaria en el contexto entregado indica que aun no tiene esa informacion pero puedes aprenderla7. si la pregunta es 'hola' responde con '\u00a1Hola! Soy Lhia, tu asistente virtual de la Cooperativa de Ahorro y Cr\u00e9dito Ambato. Estoy aqu\u00ed para ayudarte con informaci\u00f3n sobre nuestros productos y servicios financieros. Si tienes alguna pregunta sobre cuentas de ahorro, cr\u00e9ditos o cualquier otro servicio, \u00a1no dudes en preguntar!'8. si te preguntan sobre creditos muestra la varidad que tenemos";
    @Autowired
    private SeccionDocumentoCaDAO seccionCaDAO;
    @Autowired
    private T_CuentasCaDAO cuentasCaDAO;
    @Autowired
    private T_MovimientosCaDAO movimientosCaDAO;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private final RestTemplate restTemplate = new RestTemplate();
    private Cuenta cuentaCaJSON;
    private Credito creditoCaJSON;
    private String userLogin = "";
    private String rutaCarpetaCertificados = "/opt/spring_back/lhia/policia/ca/";
    private String otp = "";

    public String findProductsByQuestion(String question, List<Conversacion> lstConversation, String user) {
        this.userLogin = user;
        this.log.info("--------------------pregunta:" + user);
        if ((question.toUpperCase().contains("REALIZA") || question.toUpperCase().contains("REALIZAR") || question.toUpperCase().contains("HAZ") || question.toUpperCase().contains("ENVIA") || question.toUpperCase().contains("ENV\u00cdA")) && question.toUpperCase().contains("UNA") && question.toUpperCase().contains("TRANSFERENCIA")) {
            return this.realizarTransferencia(question);
        }
        if (question.toUpperCase().contains("QUIERO UN CREDITO") || question.toUpperCase().contains("QUIERO UN CR\u00c9DITO")) {
            return this.solicitarCredito(question);
        }
        if ((question.toUpperCase().contains("MU\u00c9STRAME") || question.toUpperCase().contains("MUESTRAME") || question.toUpperCase().contains("OBTEN") || question.toUpperCase().contains("OBT\u00c9N") || question.toUpperCase().contains("ENTREGAME")) && (question.toUpperCase().contains("LOS") || question.toUpperCase().contains("MIS")) && question.toUpperCase().contains("10")) {
            return this.obtenerListaMovimientos();
        }
        if ((question.toUpperCase().contains("MU\u00c9STRAME") || question.toUpperCase().contains("MUESTRAME") || question.toUpperCase().contains("OBTEN") || question.toUpperCase().contains("OBT\u00c9N") || question.toUpperCase().contains("ENTREGAME")) && question.toUpperCase().contains("MI") && question.toUpperCase().contains("SALDO")) {
            return this.obtenerSaldo();
        }
        if ((question.toUpperCase().contains("ENVIAME") || question.toUpperCase().contains("ENV\u00cdAME") || question.toUpperCase().contains("ENTREGAME") || question.toUpperCase().contains("DAME")) && question.toUpperCase().contains("MI") && question.toUpperCase().contains("CERTIFICADO") && question.toUpperCase().contains("DE") && question.toUpperCase().contains("CUENTA") && question.toUpperCase().contains("ACTIVA")) {
            return this.enviarCertificado();
        }
        if (this.contieneNumeros(question) && question.equals("1980")) {
            return this.verificarOTP(question);
        }
        return this.respuestaOpenIa(question, lstConversation);
    }

    public String solicitarCredito(String question) {
        String prompt = "extrae los datos de monto, interes anual donde 15.25 es para credito de cosumo y 9.25 para credito inmobiliario, y el plazo en meses del siguiente texto: " + question + " si el monto, el plazo no son entregados agregar 0 y presentamelo en formato json donde el monto en jason sera monto, el interes anual sera interesAnual, el plazo en meses plazoMeses y entrega solo el json";
        String objeto = this.respondePreguntas(prompt, Double.valueOf(0.2));
        this.creditoCaJSON = this.obtenerCredito(objeto);
        double montoPrestamo = this.creditoCaJSON.getMonto();
        double tasaInteresAnual = this.creditoCaJSON.getInteres();
        double plazoMeses = this.creditoCaJSON.getPlazo();
        System.out.println(tasaInteresAnual);
        System.out.println(montoPrestamo);
        if (this.creditoCaJSON.getInteres() == 0.0) {
            return "Falta el Articulo ingreselo por favor";
        }
        if (this.creditoCaJSON.getMonto() == 0.0) {
            return "Falta el Monto del Cr\u00e9dito ingreselo por favor";
        }
        if (this.creditoCaJSON.getPlazo() == 0.0) {
            return "Falta el Plazo del Cr\u00e9dito ingreselo por favor";
        }
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.rutaCarpetaCertificados + "tabla/TablaAmortizacion-" + this.userLogin + ".pdf"));
            document.open();
            Font font = FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f);
            Image chartImage = Image.getInstance((String)(this.rutaCarpetaCertificados + "images/logo-ca.png"));
            chartImage.setAlignment(1);
            chartImage.scaleAbsolute(300.0f, 100.0f);
            document.add((Element)chartImage);
            document.add((Element)new Paragraph("\n"));
            Paragraph title = new Paragraph("Tabla de Amortizaci\u00f3n\n", new Font(Font.FontFamily.HELVETICA, 18.0f, 1));
            title.setAlignment(1);
            document.add((Element)title);
            document.add((Element)new Paragraph("\n"));
            Paragraph montoPDF = new Paragraph("Monto: $" + montoPrestamo, font);
            montoPDF.setAlignment(0);
            document.add((Element)montoPDF);
            Paragraph interestRate = new Paragraph("Tasa de Inter\u00e9s: " + tasaInteresAnual + "%", font);
            interestRate.setAlignment(0);
            document.add((Element)interestRate);
            document.add((Element)new Paragraph("\n"));
            PdfPTable table = new PdfPTable(5);
            table.setWidthPercentage(100.0f);
            table.setWidths(new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f});
            PdfPCell cell = new PdfPCell(new Phrase("Mes", font));
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Abono a Capital", font));
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Inter\u00e9s Mensual", font));
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Cuota Mensual", font));
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Saldo Restante", font));
            table.addCell(cell);
            double tasaInteresMensual = tasaInteresAnual / 12.0 / 100.0;
            double cuotaAmortizacionCapital = montoPrestamo / plazoMeses;
            double saldoPendiente = montoPrestamo;
            int mes = 1;
            while ((double)mes <= plazoMeses) {
                double intereses = saldoPendiente * tasaInteresMensual;
                double pagoTotal = cuotaAmortizacionCapital + intereses;
                saldoPendiente -= cuotaAmortizacionCapital;
                table.addCell(String.valueOf(mes));
                PdfPCell cellRight = new PdfPCell();
                cellRight = new PdfPCell((Phrase)new Paragraph(String.format("%.2f", cuotaAmortizacionCapital)));
                cellRight.setHorizontalAlignment(2);
                table.addCell(cellRight);
                cellRight = new PdfPCell((Phrase)new Paragraph(String.format("%.2f", intereses)));
                cellRight.setHorizontalAlignment(2);
                table.addCell(cellRight);
                cellRight = new PdfPCell((Phrase)new Paragraph(String.format("%.2f", pagoTotal)));
                cellRight.setHorizontalAlignment(2);
                table.addCell(cellRight);
                cellRight = new PdfPCell((Phrase)new Paragraph(String.format("%.2f", Math.abs(saldoPendiente))));
                cellRight.setHorizontalAlignment(2);
                table.addCell(cellRight);
                ++mes;
            }
            document.add((Element)table);
            document.close();
            EnvioCorreo envioCorreo = new EnvioCorreo();
            ArrayList<String> destinatarios = new ArrayList<String>();
            destinatarios.add(((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getCorreo_electronico());
            this.enviarCorreo(destinatarios, "Tabla de Amortizaci\u00f3n Generado por la Cooperativa De Ahorro y Credito Ambato", "Estimado " + ((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getNombre().toUpperCase() + " se adjunta su Tabla de Amortizaci\u00f3n", this.rutaCarpetaCertificados + "tabla/TablaAmortizacion-" + this.userLogin + ".pdf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Tabla de Amortizaci\u00f3n Enviada a su correo electr\u00f3nico";
    }

    public void generateEmbeddingsForProducts() {
        List lstSeccion = this.seccionCaDAO.listadoProductosNG();
        for (SeccionDocumentoCa seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            String response = this.generateEmbedding(prompt);
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionCaDAO.save((Object)seccion);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }

    private String respuestaOpenIa(String question, List<Conversacion> lstConversation) {
        lstConversation.add(0, new Conversacion("system", this.iniTextoNew));
        String promptPrincipal = "pregunta del usuario: " + (question.isEmpty() ? "hola" : question);
        RespuestaVector respuestaVector = (RespuestaVector)this.respondePreguntasMilvus((question.isEmpty() ? "hola" : question).toUpperCase()).getBody();
        String prompt = "contexto entregado: " + respuestaVector.getContenido() + "\n\n";
        String promptCompleto = prompt.concat(promptPrincipal);
        lstConversation.add(new Conversacion("user", promptCompleto));
        String answer = this.respondePreguntasV2(lstConversation);
        return answer;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvus(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("http://localhost:8000/pregunta_coop_ambato", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    private String obtenerSaldo() {
        try {
            return "Tu saldo actualmente es de: " + ((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getSaldo();
        }
        catch (Exception e) {
            return "Podr\u00edas amplicar la pregunta";
        }
    }

    public String enviarCertificado() {
        try {
            EnvioCorreo envioCorreo = new EnvioCorreo();
            ArrayList<String> destinatarios = new ArrayList<String>();
            destinatarios.add(((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getCorreo_electronico());
            this.enviarCorreo(destinatarios, "Certificado Cuenta Activa Cooperativa De Ahorro y Credito Ambato", "Estimado " + ((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getNombre().toUpperCase() + " se adjunta su Certificado de Cuenta Activa", this.rutaCarpetaCertificados + ((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getCertificado());
            return "Tu Certificado de Cuenta Activa fue enviado a tu correo electr\u00f3nico";
        }
        catch (Exception e) {
            return "Ocurrio un problema al generar tu Certificado de Cuenta Activa";
        }
    }

    public String realizarTransferencia(String question) {
        this.log.info("--entra a realizar transferencia:");
        try {
            String prompt = "extrae los datos de la persona y la cantidad de dinero o monto del siguiente texto: " + question + " y presentamelo en formato json donde persona seria el primer dato y monto el segundo  donde el monto sea solo numeros y entrega solo el json";
            String objeto = this.respondePreguntas(prompt, Double.valueOf(0.2));
            this.cuentaCaJSON = this.obtenerProducto(objeto);
            this.log.info("respuesta de la pregunta para transferencia" + objeto);
            if (((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getIdentificacion().equals(((T_CuentasCa)this.cuentasCaDAO.findByNombre(this.cuentaCaJSON.getPersona()).get()).getIdentificacion())) {
                return "No puede realizar la transferencia, ya que esta usando la cuenta del usuario a transferir. Necesita algo mas? Estoy aqui para ayudarle.";
            }
            T_CuentasCa cuenta = (T_CuentasCa)this.cuentasCaDAO.findByIdentificacion(((T_CuentasCa)this.cuentasCaDAO.findByNombre(this.cuentaCaJSON.getPersona()).get()).getIdentificacion()).get();
            this.otp = "1980";
            return "Agrege OTP para realizar la transferencia de " + this.cuentaCaJSON.getMonto() + " a " + this.cuentaCaJSON.getPersona() + " portador de la cedula " + this.util.enmascararCedula(cuenta.getIdentificacion()) + " con la cuenta de tipo " + cuenta.getTipo_cuenta() + " con el n\u00famero " + this.util.enmascararNumeroCuenta(cuenta.getCuenta());
        }
        catch (Exception e) {
            return "Podr\u00edas ampliar la pregunta";
        }
    }

    public String obtenerListaMovimientos() {
        this.log.info("--entra a realizar la lista:");
        StringBuilder lista = new StringBuilder();
        try {
            List movimientos = this.movimientosCaDAO.obtenerUltimos10Movimientos(((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getIdentificacion());
            int contador = 1;
            for (T_MovimientosCa lista_movimientos : movimientos) {
                lista.append(contador).append(": ").append(lista_movimientos.getMovimiento()).append(" de ").append(lista_movimientos.getMonto()).append(" dolares de tipo ").append(lista_movimientos.getTipo()).append(" realizada a ").append(lista_movimientos.getT_cuentas().getNombre()).append(" el ").append(lista_movimientos.getFecha()).append("\n");
                ++contador;
            }
            return lista.toString();
        }
        catch (Exception e) {
            return "Debe ampliar las caracteristicas del Producto para el envio del Correo";
        }
    }

    public String verificarOTP(String question) {
        this.log.info("--entra a realizar otp:" + this.userLogin);
        T_MovimientosCa movimientos = new T_MovimientosCa();
        try {
            if (!question.equals(this.otp)) {
                return "El otp ingresado es incorrecto";
            }
            EnvioCorreo envioCorreo = new EnvioCorreo();
            LocalDate fechaActual = LocalDate.now();
            DateTimeFormatter formato = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            String fechaFormateada = fechaActual.format(formato);
            T_CuentasCa cuenta_usuario = (T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get();
            System.out.println(cuenta_usuario.getNombre());
            cuenta_usuario.setId(cuenta_usuario.getId());
            cuenta_usuario.setSaldo(Double.valueOf(cuenta_usuario.getSaldo() - this.cuentaCaJSON.getMonto()));
            this.cuentasCaDAO.save((Object)cuenta_usuario);
            T_CuentasCa cuenta = (T_CuentasCa)this.cuentasCaDAO.findByNombre(this.cuentaCaJSON.getPersona()).get();
            cuenta.setId(cuenta.getId());
            cuenta.setSaldo(Double.valueOf(cuenta.getSaldo() + this.cuentaCaJSON.getMonto()));
            this.cuentasCaDAO.save((Object)cuenta);
            movimientos.setMovimiento("Transferencia");
            movimientos.setMonto(Double.valueOf(this.cuentaCaJSON.getMonto()));
            movimientos.setTipo("Debito");
            movimientos.setFecha(fechaFormateada);
            movimientos.setT_cuentas(cuenta);
            movimientos.setT_cuentas_usuario(cuenta_usuario);
            this.movimientosCaDAO.save((Object)movimientos);
            ArrayList<String> destinatarios = new ArrayList<String>();
            destinatarios.add(((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getCorreo_electronico());
            destinatarios.add("gerencia@tws2.io");
            System.out.println(((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getCorreo_electronico());
            this.enviarCorreo2(destinatarios, "Envio Correo Autom\u00e1tico LHIA COOPERATIVA AMBATO", "Estimado " + ((T_CuentasCa)this.cuentasCaDAO.findByUsuario(this.userLogin).get()).getNombre().toUpperCase() + ",\r\n \r\n Nos complace informarte que la transferencia de $" + this.cuentaCaJSON.getMonto() + " d\u00f3lares ha sido realizada exitosamente. A continuaci\u00f3n, te proporcionamos los detalles de la transacci\u00f3n:\r\n \r\n C\u00e9dula: " + this.util.enmascararCedula(cuenta.getIdentificacion()) + "\r\n Nombre y Apellido: " + cuenta.getNombre().toUpperCase() + "\r\n N\u00famero de cuenta: " + this.util.enmascararNumeroCuenta(cuenta.getCuenta()) + "\r\n Tipo de cuenta: " + cuenta.getTipo_cuenta() + "\r\n Si tienes alguna pregunta o requieres m\u00e1s informaci\u00f3n, no dudes en contactarnos, Si no has sido tu.\r\n \r\n Atentamente,\r\n Cooperativa De Ahorro y Credito Ambato.");
            this.otp = "";
            return "Transferencia en proceso, se enviar\u00e1 el detalle de la transferencia a su correo electronico";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 350);
        requestBody.put("temperature", temp);
        requestBody.put("top_p", 1);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    private String respondePreguntasV2(List<Conversacion> lstConversation) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", lstConversation);
        requestBody.put("max_tokens", 600);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    private Cuenta obtenerProducto(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        Cuenta cuenta = null;
        try {
            cuenta = (Cuenta)objectMapper.readValue(json, Cuenta.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cuenta;
    }

    public boolean contieneNumeros(String input) {
        Pattern pattern = Pattern.compile(".*\\d.*");
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private Credito obtenerCredito(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        Credito credito = null;
        try {
            credito = (Credito)objectMapper.readValue(json, Credito.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return credito;
    }

    public String fetchAccessToken() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "password");
        parameters.put("client_id", "logueoBack");
        parameters.put("username", "emailservice");
        parameters.put("password", "X}5E&fY\\ca#Y)u*Q");
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://login.tws2.io/auth/realms/administracion/protocol/openid-connect/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.getFormDataString(parameters))).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            JSONObject jsonObject = new JSONObject(response.body());
            System.out.println(jsonObject.getString("access_token"));
            return jsonObject.getString("access_token");
        }
        throw new RuntimeException("Failed to fetch access token: " + response.statusCode() + " " + response.body());
    }

    private String getFormDataString(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sj.add(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
        }
        return sj.toString();
    }

    public void enviarCorreo(List<String> destinatarios, String asunto, String contenido, String file) throws Exception {
        String url = "https://back.correos.tws2.io/correo-service/correo/send";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.fetchAccessToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("destinatarios", destinatarios);
        requestBody.put("contentisHtml", true);
        requestBody.put("asunto", asunto);
        requestBody.put("contenido", contenido);
        requestBody.put("codigoEmail", "roSNrXU0bv2xRQlJvqOQkkNBo12XB3wQ");
        HashMap<String, String> archivo = new HashMap<String, String>();
        archivo.put("fileBase64", this.base64(file));
        archivo.put("fileName", "Documento.pdf");
        ArrayList<HashMap<String, String>> archivos = new ArrayList<HashMap<String, String>>();
        archivos.add(archivo);
        requestBody.put("archivos", archivos);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        String responseBody = (String)responseEntity.getBody();
        System.out.println("Cuerpo de la respuesta: " + responseBody);
    }

    public void enviarCorreo2(List<String> destinatarios, String asunto, String contenido) throws Exception {
        String url = "https://back.correos.tws2.io/correo-service/correo/send";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.fetchAccessToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("destinatarios", destinatarios);
        requestBody.put("contentisHtml", true);
        requestBody.put("asunto", asunto);
        requestBody.put("contenido", contenido);
        requestBody.put("codigoEmail", "roSNrXU0bv2xRQlJvqOQkkNBo12XB3wQ");
        ArrayList archivos = new ArrayList();
        requestBody.put("archivos", archivos);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        String responseBody = (String)responseEntity.getBody();
        System.out.println("Cuerpo de la respuesta: " + responseBody);
    }

    public String base64(String file) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(file, new String[0]));
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        return base64String;
    }

    public List<SeccionDocumentoCa> obtenerPrompts() {
        this.log.info("LLego a pedir productos ------------------------------**************************");
        return this.seccionCaDAO.findAll();
    }
}

