/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.coop.config;

import ec.tws2.back.lhia.coop.config.JwtAuthConverterProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final JwtGrantedAuthoritiesConverter jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    private final JwtAuthConverterProperties properties;

    public JwtAuthConverter(JwtAuthConverterProperties properties) {
        this.properties = properties;
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = Stream.concat(this.jwtGrantedAuthoritiesConverter.convert(jwt).stream(), this.extractResourceRoles(jwt).stream()).collect(Collectors.toSet());
        return new JwtAuthenticationToken(jwt, authorities, this.getPrincipalClaimName(jwt));
    }

    private String getPrincipalClaimName(Jwt jwt) {
        String claimName = "sub";
        if (this.properties.getPrincipalAttribute() != null) {
            claimName = this.properties.getPrincipalAttribute();
        }
        return (String)jwt.getClaim(claimName);
    }

    private Collection<? extends GrantedAuthority> extractResourceRoles(Jwt jwt) {
        Collection resourceRoles;
        Map resource;
        Map resourceAccess = (Map)jwt.getClaim("resource_access");
        if (resourceAccess == null || (resource = (Map)resourceAccess.get(this.properties.getResourceId())) == null || (resourceRoles = (Collection)resource.get("roles")) == null) {
            return Set.of();
        }
        return resourceRoles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).collect(Collectors.toSet());
    }
}

