/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.models.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

@Entity
@Table(name="t_subscription")
public class Subscription {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="description", nullable=false)
    private String description;
    @Column(name="type", nullable=false)
    private String type;
    @Column(name="count_free", nullable=false)
    private Integer countFree = 200;
    @Column(name="count_use", nullable=false)
    private Integer countUse = 0;
    @Column(name="active", nullable=false)
    private Boolean active = false;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="start_date")
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="end_date")
    private Date endDate;
    @Column(name="month", nullable=false)
    private Integer month;
    @Column(name="year", nullable=false)
    private Integer year;
    @Column(name="unit_cost")
    private BigDecimal unitCost;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
        Calendar calendar = Calendar.getInstance();
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        calendar.set(5, 1);
        this.startDate = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        this.endDate = calendar.getTime();
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Integer getCountFree() {
        return this.countFree;
    }

    public Integer getCountUse() {
        return this.countUse;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getYear() {
        return this.year;
    }

    public BigDecimal getUnitCost() {
        return this.unitCost;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCountFree(Integer countFree) {
        this.countFree = countFree;
    }

    public void setCountUse(Integer countUse) {
        this.countUse = countUse;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public void setUnitCost(BigDecimal unitCost) {
        this.unitCost = unitCost;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$countFree = this.getCountFree();
        Integer other$countFree = other.getCountFree();
        if (this$countFree == null ? other$countFree != null : !((Object)this$countFree).equals(other$countFree)) {
            return false;
        }
        Integer this$countUse = this.getCountUse();
        Integer other$countUse = other.getCountUse();
        if (this$countUse == null ? other$countUse != null : !((Object)this$countUse).equals(other$countUse)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Integer this$month = this.getMonth();
        Integer other$month = other.getMonth();
        if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        BigDecimal this$unitCost = this.getUnitCost();
        BigDecimal other$unitCost = other.getUnitCost();
        if (this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $countFree = this.getCountFree();
        result = result * 59 + ($countFree == null ? 43 : ((Object)$countFree).hashCode());
        Integer $countUse = this.getCountUse();
        result = result * 59 + ($countUse == null ? 43 : ((Object)$countUse).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Integer $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        BigDecimal $unitCost = this.getUnitCost();
        result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Subscription(id=" + this.getId() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", countFree=" + this.getCountFree() + ", countUse=" + this.getCountUse() + ", active=" + this.getActive() + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", month=" + this.getMonth() + ", year=" + this.getYear() + ", unitCost=" + String.valueOf(this.getUnitCost()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    public Subscription() {
    }

    public Subscription(Long id, String description, String type, Integer countFree, Integer countUse, Boolean active, Date startDate, Date endDate, Integer month, Integer year, BigDecimal unitCost, Date createdAt) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.countFree = countFree;
        this.countUse = countUse;
        this.active = active;
        this.startDate = startDate;
        this.endDate = endDate;
        this.month = month;
        this.year = year;
        this.unitCost = unitCost;
        this.createdAt = createdAt;
    }
}

