/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.models.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import ec.tws2.back.lhia.marcimex.models.entity.PurchaseDetail;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="t_purchase")
public class Purchase {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Double totalAmount;
    private String paymentMethod;
    @Column(name="conversation_id")
    private String conversationId;
    @Column(name="observation")
    private String observation;
    @Column(name="platform")
    private String platform;
    @Column(name="platform_id")
    private String platformId;
    @Column(name="completed", nullable=false)
    private Boolean completed;
    @Column(name="url_purchase")
    private String urlPurchase;
    @Column(name="status", nullable=false)
    private Boolean status;
    @Column(name="order_id")
    private String orderId;
    @Column(name="order_form_id")
    private String orderFormId;
    @Column(name="invoiced", nullable=false)
    private Boolean invoiced;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;
    @OneToMany(mappedBy="purchase", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private List<PurchaseDetail> purchaseDetails;

    @PrePersist
    protected void onCreate() {
        if (this.status == null) {
            this.status = true;
        }
        if (this.completed == null) {
            this.completed = false;
        }
        if (this.invoiced == null) {
            this.invoiced = false;
        }
        this.createdAt = new Date();
    }

    public void addPurchaseDetail(PurchaseDetail detail) {
        this.purchaseDetails.add(detail);
        detail.setPurchase(this);
    }

    public void removePurchaseDetail(PurchaseDetail detail) {
        this.purchaseDetails.remove(detail);
        detail.setPurchase(null);
    }

    public String toString() {
        return "Purchase [id=" + this.id + ", totalAmount=" + this.totalAmount + ", paymentMethod=" + this.paymentMethod + ", conversationId=" + this.conversationId + ", observation=" + this.observation + ", platform=" + this.platform + ", platformId=" + this.platformId + ", completed=" + this.completed + ", urlPurchase=" + this.urlPurchase + ", status=" + this.status + ", orderId=" + this.orderId + ", orderFormId=" + this.orderFormId + ", invoiced=" + this.invoiced + ", createdAt=" + String.valueOf(this.createdAt) + ", purchaseDetails=" + String.valueOf(this.purchaseDetails) + "]";
    }

    public Long getId() {
        return this.id;
    }

    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getObservation() {
        return this.observation;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public String getUrlPurchase() {
        return this.urlPurchase;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOrderFormId() {
        return this.orderFormId;
    }

    public Boolean getInvoiced() {
        return this.invoiced;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public List<PurchaseDetail> getPurchaseDetails() {
        return this.purchaseDetails;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public void setUrlPurchase(String urlPurchase) {
        this.urlPurchase = urlPurchase;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOrderFormId(String orderFormId) {
        this.orderFormId = orderFormId;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public void setPurchaseDetails(List<PurchaseDetail> purchaseDetails) {
        this.purchaseDetails = purchaseDetails;
    }

    public Purchase() {
    }

    public Purchase(Long id, Double totalAmount, String paymentMethod, String conversationId, String observation, String platform, String platformId, Boolean completed, String urlPurchase, Boolean status, String orderId, String orderFormId, Boolean invoiced, Date createdAt, List<PurchaseDetail> purchaseDetails) {
        this.id = id;
        this.totalAmount = totalAmount;
        this.paymentMethod = paymentMethod;
        this.conversationId = conversationId;
        this.observation = observation;
        this.platform = platform;
        this.platformId = platformId;
        this.completed = completed;
        this.urlPurchase = urlPurchase;
        this.status = status;
        this.orderId = orderId;
        this.orderFormId = orderFormId;
        this.invoiced = invoiced;
        this.createdAt = createdAt;
        this.purchaseDetails = purchaseDetails;
    }
}

