/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.models.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

@Entity
@Table(name="t_document_file")
public class DocumentFile {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="name", nullable=false, unique=true)
    private String name;
    @Column(name="year", nullable=false)
    private Integer year;
    @Column(name="month", nullable=false)
    private Integer month;
    @Column(name="file_data", nullable=false)
    private byte[] fileData;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.createdAt);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
    }

    public DocumentFile(String name, byte[] fileData) {
        this.name = name;
        this.fileData = fileData;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentFile)) {
            return false;
        }
        DocumentFile other = (DocumentFile)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Integer this$month = this.getMonth();
        Integer other$month = other.getMonth();
        if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getFileData(), other.getFileData())) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Integer $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getFileData());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentFile(id=" + this.getId() + ", name=" + this.getName() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", fileData=" + Arrays.toString(this.getFileData()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    public DocumentFile() {
    }

    public DocumentFile(Long id, String name, Integer year, Integer month, byte[] fileData, Date createdAt) {
        this.id = id;
        this.name = name;
        this.year = year;
        this.month = month;
        this.fileData = fileData;
        this.createdAt = createdAt;
    }
}

