/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.scheduled;

import ec.tws2.back.lhia.marcimex.infrastructure.facade.MarcimexOrderFacade;
import ec.tws2.back.lhia.marcimex.infrastructure.facade.ScheduleAssignmentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Profile(value={"prod"})
@Component
public class OrdersScheduler {
    private static final Logger log = LoggerFactory.getLogger(OrdersScheduler.class);
    private final MarcimexOrderFacade marcimexOrderFacade;
    private final ScheduleAssignmentFacade scheduleAssignmentFacade;

    @Scheduled(cron="0 55 * * * *", zone="America/Guayaquil")
    public void processEstablishmentPurchasedInvoiced() {
        try {
            log.info("Inicio Tarea [processEstablishmentPurchasedInvoiced]");
            this.marcimexOrderFacade.getYesterdayInvoicedOrdersExecute();
            log.info("Finaliza Tarea [processEstablishmentPurchasedInvoiced]");
        }
        catch (Exception e) {
            log.error("Error al ejecutar tarea [processEstablishmentPurchasedInvoiced]: " + e.getMessage());
        }
    }

    @Scheduled(cron="0 0 * * * *", zone="America/Guayaquil")
    public void processRedirectConversations() {
        try {
            log.info("Inicio Tarea [processRedirectConversations]");
            this.scheduleAssignmentFacade.executerAssignation();
            log.info("Finaliza Tarea [processRedirectConversations]");
        }
        catch (Exception e) {
            log.error("Error al ejecutar tarea [processRedirectConversations]: " + e.getMessage());
        }
    }

    public OrdersScheduler(MarcimexOrderFacade marcimexOrderFacade, ScheduleAssignmentFacade scheduleAssignmentFacade) {
        this.marcimexOrderFacade = marcimexOrderFacade;
        this.scheduleAssignmentFacade = scheduleAssignmentFacade;
    }
}

