/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.WhatsappRepository;
import ec.tws2.back.lhia.marcimex.models.dto.WhatsappDTO;
import java.net.URI;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class WhatsappRepositoryImpl
implements WhatsappRepository {
    private static final Logger log = LoggerFactory.getLogger(WhatsappRepositoryImpl.class);
    @Value(value="${whatsapp.api.token}")
    private String token;

    public Optional<WhatsappDTO> downloadImageAndConvertToBase64(String imageUrl) {
        try {
            log.info("Iniciando descarga de imagen desde WhatsApp. URL: {}", (Object)imageUrl);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + this.token);
            RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, new URI(imageUrl));
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(request, byte[].class);
            log.debug("Respuesta HTTP status: {}", (Object)response.getStatusCode().value());
            if (response.getStatusCode().value() == 200) {
                byte[] fileContent = (byte[])response.getBody();
                String base64File = Base64.getEncoder().encodeToString(fileContent);
                log.info("Imagen descargada correctamente y convertida a Base64 (tama\u00f1o: {} bytes)", (Object)fileContent.length);
                return Optional.of(new WhatsappDTO(base64File, fileContent));
            }
            log.warn("La respuesta no fue exitosa. C\u00f3digo HTTP: {}", (Object)response.getStatusCode().value());
            return Optional.empty();
        }
        catch (HttpClientErrorException e) {
            log.error("Error HTTP al descargar imagen de WhatsApp. Status: {}, Body: {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("Error inesperado al descargar imagen de WhatsApp: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }
}

