/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.FileUtils;
import ec.tws2.back.lhia.marcimex.common.util.PromptsUtil;
import ec.tws2.back.lhia.marcimex.common.util.SecurityUtils;
import ec.tws2.back.lhia.marcimex.common.util.VoucherUtil;
import ec.tws2.back.lhia.marcimex.common.util.VoucherValidUtil;
import ec.tws2.back.lhia.marcimex.infrastructure.client.FileApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.VoucherDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.EmailRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.EmailUserRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ImageRecognitionRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.SubscriptionRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.VoucherRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.WhatsappRepository;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.BankTransferDto;
import ec.tws2.back.lhia.marcimex.models.dto.BankTransferNotValidDto;
import ec.tws2.back.lhia.marcimex.models.dto.EmailUserDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ProcessVoucherDto;
import ec.tws2.back.lhia.marcimex.models.dto.SubscriptionDTO;
import ec.tws2.back.lhia.marcimex.models.dto.VoucherBankPaymentDto;
import ec.tws2.back.lhia.marcimex.models.dto.WhatsappDTO;
import ec.tws2.back.lhia.marcimex.models.entity.EmailUser;
import ec.tws2.back.lhia.marcimex.models.entity.Subscription;
import ec.tws2.back.lhia.marcimex.models.entity.Voucher;
import ec.tws2.back.lhia.marcimex.models.request.FileUploadRequest;
import ec.tws2.back.lhia.marcimex.models.response.FileUploadResponse;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;

@Service
public class VoucherRepositoryImpl
implements VoucherRepository {
    private static final Logger log = LoggerFactory.getLogger(VoucherRepositoryImpl.class);
    @Autowired
    private WhatsappRepository whatsappRepository;
    @Autowired
    private EmailRepository emailRepository;
    @Autowired
    private ImageRecognitionRepository imageRecognitionRepository;
    @Autowired
    private VoucherDAO voucherDAO;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private EmailUserRepository emailUserRepository;
    @Autowired
    private FileApiClient fileApiClient;

    public Voucher saveVoucher(Voucher voucher) {
        return (Voucher)this.voucherDAO.save((Object)voucher);
    }

    public ResponseEntity<ResponseResult<?>> listVoucher() {
        List listVoucher = this.voucherDAO.findAll();
        return TransactionCustom.ok((Object)listVoucher);
    }

    public ResponseEntity<ResponseResult<?>> registerVoucherBankPayment(VoucherBankPaymentDto voucherBank, BindingResult resultBinding) {
        try {
            String analysisDocument = "";
            List listEmail = this.getListEmailDevelopmentActive();
            if (listEmail.size() <= 0) {
                log.error("List email empty");
                return TransactionCustom.error((String)"List email empty.");
            }
            Optional responseWhatsapp = this.whatsappRepository.downloadImageAndConvertToBase64(voucherBank.getDocumentUrl());
            if (!responseWhatsapp.isPresent()) {
                log.error("Error downloading image from WhatsApp");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            byte[] fileContentBytes = ((WhatsappDTO)responseWhatsapp.get()).getFileContentBytes();
            FileUploadResponse.FilePayload filePayload = this.getFilePayload(FileUtils.toBase64String((byte[])fileContentBytes));
            if (filePayload == null) {
                log.error("Error saving image");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            String customPrompt = PromptsUtil.getPromptValidVoucherBankPromp((VoucherBankPaymentDto)voucherBank);
            Optional processVoucher = this.imageRecognitionRepository.checkImageDocumentPrompt(filePayload.getPath(), voucherBank, customPrompt);
            if (!processVoucher.isPresent()) {
                log.error("Error analyzing image from WhatsApp");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            Voucher.VoucherBuilder voucherBuilder = Voucher.builder().conversationId(voucherBank.getConversationId()).nameFile(filePayload.getId()).urlImage(filePayload.getPath()).firstName(voucherBank.getFirstName()).lastName(voucherBank.getLastName()).identification(voucherBank.getIdentification());
            if (((ProcessVoucherDto)processVoucher.get()).getDescription().contains("documento_no_valido")) {
                log.info("Image not valid");
                BankTransferNotValidDto bankTransferDto = VoucherUtil.jsonStringBankTransferNotValidDto((String)((ProcessVoucherDto)processVoucher.get()).getDescription());
                if (bankTransferDto != null) {
                    analysisDocument = bankTransferDto.getDocumentoNoValido();
                    voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                    this.saveVoucher(voucherBuilder.build());
                    return TransactionCustom.error((String)analysisDocument);
                }
                log.info("Image not valid.");
                analysisDocument = "La imagen que subiste no parece ser v\u00e1lida. Aseg\u00farate de que sea un comprobante claro y bien enfocado. Int\u00e9ntalo nuevamente.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            BankTransferDto bankTransferDto = VoucherUtil.jsonStringBankTransferDto((String)((ProcessVoucherDto)processVoucher.get()).getDescription());
            if (bankTransferDto == null) {
                log.info("Error en la convercion a JSON de Objeto response.");
                return TransactionCustom.error((String)"Ocurri\u00f3 un error al procesar la informaci\u00f3n. Por favor, intenta nuevamente o contacta a soporte si el problema persiste.");
            }
            if (bankTransferDto.getBancoOrigenValue().equalsIgnoreCase("INVALIDO")) {
                log.info("No fue posible determinar banco origen.");
                analysisDocument = "La entidad financiera origen ingresada no coincide con el registrado en el documento. Por favor, verif\u00edquelo y actual\u00edcelo si es necesario.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            if (bankTransferDto.getBancoDestinoValue().equalsIgnoreCase("INVALIDO")) {
                log.info("No fue posible determinar banco destino.");
                analysisDocument = "La entidad financiera destino ingresada no coincide con el registrado en el documento. Por favor, verif\u00edquelo y actual\u00edcelo si es necesario.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            if (bankTransferDto.getFecha() == null || bankTransferDto.getFecha().isEmpty()) {
                log.info("No fue posible determinar la fecha en el documento.");
                analysisDocument = "No pudimos encontrar la fecha en el comprobante. Aseg\u00farate de que sea legible y vuelve a subir la imagen.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            if (bankTransferDto.getEstadoDocumento().equals("PENDIENTE")) {
                log.info("Documento pendiente de verificaci\u00f3n.");
                analysisDocument = "Hemos recibido tu comprobante, pero a\u00fan est\u00e1 pendiente de validaci\u00f3n. Una vez que est\u00e9 confirmado, por favor, vuelve a subirlo para completar el proceso.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            if ("SIMPLE_PACIFICO".equals(bankTransferDto.getVoucherType())) {
                log.info("VOUCHER SIMPLE PACIFICO.....");
                analysisDocument = "Comprobante validado correctamente.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(((ProcessVoucherDto)processVoucher.get()).isValid())).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return this.sendEmailUserRegisters(listEmail, voucherBank, bankTransferDto, ((WhatsappDTO)responseWhatsapp.get()).getFileContent(), filePayload.getPath());
            }
            Set<String> cuentasMarcimex = Set.of("3089234104", "6436927", "015806", "4000010843", "1150125045");
            String numeroCuenta = bankTransferDto.getNumeroCuenta();
            if (numeroCuenta != null && cuentasMarcimex.contains(numeroCuenta.trim())) {
                bankTransferDto.setVoucher("MARCIMEX");
            }
            if (bankTransferDto.getVoucher() == null || !"MARCIMEX".equals(bankTransferDto.getVoucher())) {
                log.info("El documento no est\u00e1 destinado a Marcimex.");
                analysisDocument = "Parece que el comprobante no corresponde a Marcimex. Verifica los datos y vuelve a intentarlo.";
                voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(false)).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
                this.saveVoucher(voucherBuilder.build());
                return TransactionCustom.error((String)analysisDocument);
            }
            analysisDocument = "Comprobante validado correctamente.";
            voucherBuilder.description(analysisDocument).valid(Boolean.valueOf(((ProcessVoucherDto)processVoucher.get()).isValid())).totalTokens(Integer.valueOf(((ProcessVoucherDto)processVoucher.get()).getTotalTokens())).idSubscription(Long.valueOf(1L));
            this.saveVoucher(voucherBuilder.build());
            return this.sendEmailUserRegisters(listEmail, voucherBank, bankTransferDto, ((WhatsappDTO)responseWhatsapp.get()).getFileContent(), filePayload.getPath());
        }
        catch (Exception e) {
            log.error("Error registering voucher: " + e.getMessage());
            return TransactionCustom.error((String)"Error al registrar comprobante.");
        }
    }

    private FileUploadResponse.FilePayload getFilePayload(String imageBase64) {
        try {
            String tokenHttp = SecurityUtils.extractToken();
            FileUploadRequest request = new FileUploadRequest();
            request.setContentType("png");
            request.setFolder("VOUCHER");
            request.setBase64(imageBase64);
            ResponseEntity dataResponse = this.fileApiClient.uploadFile(request, tokenHttp);
            if (dataResponse.getStatusCode().value() == 200) {
                return ((FileUploadResponse)dataResponse.getBody()).getPayload();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ResponseEntity<ResponseResult<?>> sendEmailUserRegisters(List<EmailUser> listEmail, VoucherBankPaymentDto voucherBank, BankTransferDto bankTransferDto, String fileContent, String urlImage) throws Exception {
        List listEmailString = listEmail.stream().map(EmailUser::getUserEmail).collect(Collectors.toList());
        boolean sendEmail = this.emailRepository.sendEmailBank(voucherBank, bankTransferDto, fileContent, listEmailString, urlImage);
        if (!sendEmail) {
            log.error("Error sending voucher email");
            return TransactionCustom.error((String)"Error al registrar comprobante.");
        }
        return TransactionCustom.ok();
    }

    private List<EmailUser> getListEmailDevelopmentActive() {
        EmailUserDTO emailUserDTO = new EmailUserDTO();
        emailUserDTO.setTypeEmail("voucher");
        emailUserDTO.setDevelopment(Boolean.valueOf(true));
        emailUserDTO.setProduction(Boolean.valueOf(false));
        List listEmail = this.emailUserRepository.findUsers(emailUserDTO);
        return listEmail;
    }

    public Long countByCreatedAtBetween(java.util.Date startDate, java.util.Date endDate) {
        return this.voucherDAO.countByCreatedAtBetween(startDate, endDate);
    }

    public Long countByCreatedAtBetweenAndTotalTokens(java.util.Date startDate, java.util.Date endDate) {
        return this.voucherDAO.countByCreatedAtBetweenAndTotalTokens(startDate, endDate);
    }

    public SubscriptionDTO getLastSubscription(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            LocalDate now = LocalDate.now();
            LocalDate firstDayOfMonth = now.withDayOfMonth(1);
            LocalDate lastDayOfMonth = now.withDayOfMonth(now.lengthOfMonth());
            date1 = Date.valueOf(firstDayOfMonth);
            date2 = Date.valueOf(lastDayOfMonth);
        }
        Long countUse = this.countByCreatedAtBetween(date1, date2);
        Long countAnalyzed = this.countByCreatedAtBetweenAndTotalTokens(date1, date2);
        Optional dataSubscription = this.subscriptionRepository.getSubscriptionCurrent();
        SubscriptionDTO subscriptionDTO = new SubscriptionDTO();
        if (dataSubscription.isPresent()) {
            BigDecimal totalDiscountCost = BigDecimal.valueOf(0.0);
            BigDecimal totalCost = BigDecimal.valueOf(0.0);
            if (countAnalyzed > (long)((Subscription)dataSubscription.get()).getCountFree().intValue()) {
                BigDecimal unitCost = ((Subscription)dataSubscription.get()).getUnitCost();
                totalCost = unitCost.multiply(BigDecimal.valueOf(countAnalyzed));
                long quantityAnalyzedDiscount = countAnalyzed - (long)((Subscription)dataSubscription.get()).getCountFree().intValue();
                totalDiscountCost = unitCost.multiply(BigDecimal.valueOf(quantityAnalyzedDiscount));
            }
            subscriptionDTO.setId(((Subscription)dataSubscription.get()).getId());
            subscriptionDTO.setDescription(((Subscription)dataSubscription.get()).getDescription());
            subscriptionDTO.setType(((Subscription)dataSubscription.get()).getType());
            subscriptionDTO.setCountFree(((Subscription)dataSubscription.get()).getCountFree());
            subscriptionDTO.setCountUse(Integer.valueOf(Integer.parseInt(countUse.toString())));
            subscriptionDTO.setCountAnalyzed(Integer.valueOf(Integer.parseInt(countAnalyzed.toString())));
            subscriptionDTO.setActive(((Subscription)dataSubscription.get()).getActive());
            subscriptionDTO.setUnitCost(((Subscription)dataSubscription.get()).getUnitCost());
            subscriptionDTO.setTotalDiscountCost(totalDiscountCost);
            subscriptionDTO.setTotalCost(totalCost);
            subscriptionDTO.setCreatedAt(((Subscription)dataSubscription.get()).getCreatedAt());
            return subscriptionDTO;
        }
        return null;
    }

    public ResponseEntity<ResponseResult<?>> registerVoucherBankPaymentV2(VoucherBankPaymentDto voucherBank, BindingResult resultBinding) {
        log.info("Iniciando registro de comprobante - Conversaci\u00f3n ID: {}", (Object)voucherBank.getConversationId());
        try {
            List listEmail = this.getListEmailDevelopmentActive();
            if (listEmail.size() <= 0) {
                log.error("Lista de correos para notificaci\u00f3n vac\u00eda");
                return TransactionCustom.error((String)"Lista de correo electr\u00f3nico vac\u00eda.");
            }
            log.debug("Correos de notificaci\u00f3n cargados: {}", (Object)listEmail.size());
            log.info("Descargando imagen desde WhatsApp: {}", (Object)voucherBank.getDocumentUrl());
            Optional responseWhatsapp = this.whatsappRepository.downloadImageAndConvertToBase64(voucherBank.getDocumentUrl());
            if (!responseWhatsapp.isPresent()) {
                log.error("Error al descargar la imagen desde WhatsApp");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            log.debug("Guardando imagen en servidor como base64");
            FileUploadResponse.FilePayload filePayload = this.getFilePayload(FileUtils.toBase64String((byte[])((WhatsappDTO)responseWhatsapp.get()).getFileContentBytes()));
            if (filePayload == null) {
                log.error("Error al guardar la imagen en el servidor");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            String customPrompt = PromptsUtil.getPromptValidVoucherBankPrompV2((VoucherBankPaymentDto)voucherBank);
            log.info("Analizando imagen con prompt generado...");
            Optional processVoucher = this.imageRecognitionRepository.checkImageDocumentPrompt(filePayload.getPath(), voucherBank, customPrompt);
            if (!processVoucher.isPresent()) {
                log.error("Error al analizar la imagen desde WhatsApp");
                return TransactionCustom.error((String)"Error al registrar comprobante.");
            }
            Voucher.VoucherBuilder voucherBuilder = this.buildVoucher(voucherBank, filePayload, (ProcessVoucherDto)processVoucher.get());
            if (((ProcessVoucherDto)processVoucher.get()).getDescription().contains("documento_no_valido")) {
                log.warn("Documento detectado como NO v\u00e1lido");
                BankTransferNotValidDto bankTransferDto = VoucherUtil.jsonStringBankTransferNotValidDto((String)((ProcessVoucherDto)processVoucher.get()).getDescription());
                if (bankTransferDto != null) {
                    return this.registerInvalidVoucher(voucherBuilder, bankTransferDto.getDocumentoNoValido());
                }
                return this.registerInvalidVoucher(voucherBuilder, "La imagen que subiste no parece ser v\u00e1lida. Aseg\u00farate de que sea un comprobante claro y bien enfocado. Int\u00e9ntalo nuevamente.");
            }
            BankTransferDto bankTransferDto = VoucherUtil.jsonStringBankTransferDto((String)((ProcessVoucherDto)processVoucher.get()).getDescription());
            if (bankTransferDto == null) {
                log.error("Error al convertir la respuesta JSON a objeto BankTransferDto");
                return TransactionCustom.error((String)"Ocurri\u00f3 un error al procesar la informaci\u00f3n. Por favor, intenta nuevamente o contacta a soporte si el problema persiste.");
            }
            log.debug("Objeto de transferencia bancaria generado: {}", (Object)bankTransferDto);
            if ("INVALIDO".equalsIgnoreCase(bankTransferDto.getBancoOrigenValue())) {
                log.warn("Banco origen inv\u00e1lido detectado");
                return this.registerInvalidVoucher(voucherBuilder, "La entidad financiera origen ingresada no coincide con el registrado en el documento. Por favor, verif\u00edquelo y actual\u00edcelo si es necesario.");
            }
            if ("INVALIDO".equalsIgnoreCase(bankTransferDto.getBancoDestinoValue())) {
                log.warn("Banco destino inv\u00e1lido detectado");
                return this.registerInvalidVoucher(voucherBuilder, "La entidad financiera destino ingresada no coincide con el registrado en el documento. Por favor, verif\u00edquelo y actual\u00edcelo si es necesario.");
            }
            if (bankTransferDto.getFecha() == null || bankTransferDto.getFecha().isEmpty() || bankTransferDto.getFecha().equalsIgnoreCase("null")) {
                log.warn("Fecha no encontrada en el documento");
                return this.registerInvalidVoucher(voucherBuilder, "No pudimos encontrar la fecha en el comprobante. Aseg\u00farate de que sea legible y vuelve a subir la imagen.");
            }
            if ("PENDIENTE".equals(bankTransferDto.getEstadoDocumento())) {
                log.warn("Comprobante se encuentra en estado pendiente");
                return this.registerInvalidVoucher(voucherBuilder, "Hemos recibido tu comprobante, pero a\u00fan est\u00e1 pendiente de validaci\u00f3n. Una vez que est\u00e9 confirmado, por favor, vuelve a subirlo para completar el proceso.");
            }
            if ("SIMPLE_PACIFICO".equals(bankTransferDto.getVoucherType())) {
                log.info("Comprobante identificado como SIMPLE_PACIFIC v\u00e1lido");
                this.registerValidVoucher(voucherBuilder, "\u00a1Listo! Se ha registrado tu comprobante exitosamente, y el valor se reflejar\u00e1 en tu cr\u00e9dito en las pr\u00f3ximas 48 horas.");
                return this.sendEmailUserRegistersV2(listEmail, voucherBank, bankTransferDto, ((WhatsappDTO)responseWhatsapp.get()).getFileContent(), filePayload.getPath());
            }
            if (!VoucherValidUtil.isCompany((BankTransferDto)bankTransferDto)) {
                log.warn("Nombre de empresa no v\u00e1lido");
                return this.registerInvalidVoucher(voucherBuilder, "Parece que el comprobante no corresponde a Marcimex. Verifica los datos y vuelve a intentarlo.");
            }
            log.info("Registrando comprobante v\u00e1lido");
            this.registerValidVoucher(voucherBuilder, "\u00a1Listo! Se ha registrado tu comprobante exitosamente, y el valor se reflejar\u00e1 en tu cr\u00e9dito en las pr\u00f3ximas 48 horas.");
            return this.sendEmailUserRegistersV2(listEmail, voucherBank, bankTransferDto, ((WhatsappDTO)responseWhatsapp.get()).getFileContent(), filePayload.getPath());
        }
        catch (Exception e) {
            log.error("Error registering voucher: " + e.getMessage());
            return TransactionCustom.error((String)"Error al registrar comprobante.");
        }
    }

    private Voucher.VoucherBuilder buildVoucher(VoucherBankPaymentDto dto, FileUploadResponse.FilePayload payload, ProcessVoucherDto processDto) {
        return Voucher.builder().conversationId(dto.getConversationId()).nameFile(payload.getId()).urlImage(payload.getPath()).firstName(dto.getFirstName()).lastName(dto.getLastName()).identification(dto.getIdentification()).totalTokens(Integer.valueOf(processDto.getTotalTokens())).idSubscription(Long.valueOf(1L));
    }

    private void registerValidVoucher(Voucher.VoucherBuilder builder, String message) {
        builder.description(message).valid(Boolean.valueOf(true));
        this.saveVoucher(builder.build());
    }

    private ResponseEntity<ResponseResult<?>> registerInvalidVoucher(Voucher.VoucherBuilder builder, String message) {
        builder.description(message).valid(Boolean.valueOf(false));
        this.saveVoucher(builder.build());
        return TransactionCustom.error((String)message);
    }

    private ResponseEntity<ResponseResult<?>> sendEmailUserRegistersV2(List<EmailUser> listEmail, VoucherBankPaymentDto voucherBank, BankTransferDto bankTransferDto, String fileContent, String urlImage) throws Exception {
        List listEmailString = listEmail.stream().map(EmailUser::getUserEmail).collect(Collectors.toList());
        boolean sendEmail = this.emailRepository.sendEmailBank(voucherBank, bankTransferDto, fileContent, listEmailString, urlImage);
        if (!sendEmail) {
            log.error("Error sending voucher email.");
            return TransactionCustom.error((String)"Error sending voucher email.");
        }
        return TransactionCustom.ok((String)"\u00a1Listo! Se ha registrado tu comprobante exitosamente, y el valor se reflejar\u00e1 en tu cr\u00e9dito en las pr\u00f3ximas 48 horas.");
    }
}

