/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.dao.SubscriptionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.SubscriptionRepository;
import ec.tws2.back.lhia.marcimex.models.dto.SubscriptionDTO;
import ec.tws2.back.lhia.marcimex.models.dto.SubscriptionStatusDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Subscription;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubscriptionRepositoryImpl
implements SubscriptionRepository {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionRepositoryImpl.class);
    @Autowired
    private SubscriptionDAO subscriptionDAO;

    public Optional<Subscription> getSubscriptionCurrent() {
        try {
            Optional subscriptionFind = this.subscriptionDAO.findFirstByOrderByCreatedAtDesc();
            if (subscriptionFind.isPresent()) {
                return subscriptionFind;
            }
            Subscription subscriptionNew = new Subscription();
            subscriptionNew.setDescription("Subscripci\u00f3n de validaci\u00f3n de comprobantes");
            subscriptionNew.setType("VOUCHER");
            Subscription subscriptionCreated = (Subscription)this.subscriptionDAO.save((Object)subscriptionNew);
            return Optional.of(subscriptionCreated);
        }
        catch (Exception e) {
            log.info("Error al obtener subscripcion actual: " + e.getMessage());
            return Optional.empty();
        }
    }

    @Transactional
    public boolean incrementCountUse(Long subscriptionId) {
        try {
            int updatedRows = this.subscriptionDAO.incrementCountUse(subscriptionId);
            return updatedRows == 1;
        }
        catch (Exception e) {
            log.info("Error al incrementar el contador de comprobantes: " + e.getMessage());
            return false;
        }
    }

    @Transactional
    public Boolean updateStatusSubscription(SubscriptionStatusDTO subscription) {
        try {
            int updatedRows = this.subscriptionDAO.updateSubscriptionStatus(subscription.getId(), subscription.getActive());
            if (updatedRows == 1) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.info("Error al actualizar status de subscripcion: " + e.getMessage());
            return false;
        }
    }

    public SubscriptionDTO getLastSubscription() {
        Optional lastSubscription = this.subscriptionDAO.findFirstSubscriptionAsDTOOrderByCreatedAtDesc();
        return (SubscriptionDTO)lastSubscription.get();
    }
}

