/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.dao.ShortLinkDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ShortLinkRepository;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.entity.ShortLink;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkRepositoryImpl
implements ShortLinkRepository {
    private static final String BASE62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String lhiaDomainUrl;
    private final ShortLinkDAO shortLinkDAO;

    public ShortLinkRepositoryImpl(@Value(value="${lhia.domain.url}") String lhiaDomainUrl, ShortLinkDAO shortLinkDAO) {
        this.lhiaDomainUrl = lhiaDomainUrl;
        this.shortLinkDAO = shortLinkDAO;
    }

    private String encodeBase62(long id) {
        StringBuilder sb = new StringBuilder();
        while (id > 0L) {
            sb.append(BASE62.charAt((int)(id % 62L)));
            id /= 62L;
        }
        return sb.reverse().toString();
    }

    public ShortLink createShortLink(String originalUrl) {
        ShortLink shortLink = new ShortLink();
        shortLink.setOriginalUrl(originalUrl);
        shortLink = (ShortLink)this.shortLinkDAO.save((Object)shortLink);
        String code = this.encodeBase62(shortLink.getId().longValue());
        shortLink.setCode(code);
        return (ShortLink)this.shortLinkDAO.save((Object)shortLink);
    }

    public Optional<String> getOriginalUrl(String code) {
        return this.shortLinkDAO.findByCode(code).map(ShortLink::getOriginalUrl);
    }

    public ResponseRobot process(ResponseRobot responseRobot) {
        if (responseRobot.getListProductVectorial() == null) {
            return responseRobot;
        }
        List<CompletableFuture> futures = responseRobot.getListProductVectorial().stream().map(product -> CompletableFuture.runAsync(() -> this.processShortLink(product))).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return responseRobot;
    }

    private void processShortLink(ProductVectorial product) {
        String originalLink = product.getLink();
        if (originalLink == null || originalLink.isBlank()) {
            return;
        }
        ShortLink shortLink = this.createShortLink(originalLink);
        String shortUrl = this.lhiaDomainUrl + "/s/" + shortLink.getCode();
        product.setLink(shortUrl);
    }
}

