/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.dao.PurchaseDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.UserPurchaseDetailViewDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PurchaseStatsRepository;
import ec.tws2.back.lhia.marcimex.models.dto.PurchaseStatsDTO;
import ec.tws2.back.lhia.marcimex.models.dto.PurchasesDTO;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseByPaymentMethodProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseDailySummaryProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseHourRangeProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.RedirectSummaryProjection;
import ec.tws2.back.lhia.marcimex.models.view.UserPurchaseDetailView;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PurchaseStatsRepositoryImpl
implements PurchaseStatsRepository {
    private static final Logger log = LoggerFactory.getLogger(PurchaseStatsRepositoryImpl.class);
    private final PurchaseDAO purchaseDAO;
    private final UserPurchaseDetailViewDAO userPurchaseDetailViewDAO;

    public PurchaseStatsRepositoryImpl(PurchaseDAO purchaseDAO, UserPurchaseDetailViewDAO userPurchaseDetailViewDAO) {
        this.purchaseDAO = purchaseDAO;
        this.userPurchaseDetailViewDAO = userPurchaseDetailViewDAO;
    }

    public List<PurchasesDTO> getTotalPurchases(LocalDate start, LocalDate end) {
        ArrayList<PurchasesDTO> listPurchases = new ArrayList<PurchasesDTO>();
        log.info("Consultando compras iniciadas entre {} y {}", (Object)start, (Object)end);
        List purchases = this.purchaseDAO.findAllInRange(start.atStartOfDay(), end.atTime(LocalTime.MAX));
        log.info("Se recuperaron {} compras en el rango proporcionado", (Object)purchases.size());
        long completed = purchases.stream().filter(p -> Boolean.TRUE.equals(p.getCompleted())).count();
        long invoiced = purchases.stream().filter(p -> Boolean.TRUE.equals(p.getInvoiced())).count();
        long notCompletedAll = (long)purchases.size() - completed;
        long completedAll = completed - invoiced;
        listPurchases.add(new PurchasesDTO("started", "Iniciados", "Carritos iniciados", notCompletedAll));
        listPurchases.add(new PurchasesDTO("completed", "Completados", "Carritos completados", completedAll));
        listPurchases.add(new PurchasesDTO("invoiced", "Facturados", "Carritos que ya fueron facturados", invoiced));
        return listPurchases;
    }

    public PurchaseStatsDTO getTotalPurchasesStarted(LocalDate start, LocalDate end) {
        log.info("Consultando compras iniciadas entre {} y {}", (Object)start, (Object)end);
        List purchases = this.purchaseDAO.findAllInRange(start.atStartOfDay(), end.atTime(LocalTime.MAX));
        log.info("Se recuperaron {} compras en el rango proporcionado", (Object)purchases.size());
        long completed = purchases.stream().filter(p -> Boolean.TRUE.equals(p.getCompleted())).count();
        long notCompleted = purchases.stream().filter(p -> Boolean.FALSE.equals(p.getCompleted())).count();
        long started = completed + notCompleted;
        log.info("Total compras iniciadas: {}, Completadas: {}, No completadas: {}", new Object[]{started, completed, notCompleted});
        return new PurchaseStatsDTO(started, completed, notCompleted);
    }

    public List<PurchaseHourRangeProjection> getPurchasesByHourRange(LocalDate start, LocalDate end) {
        log.info("Consultando compras agrupadas por rango horario entre {} y {}", (Object)start, (Object)end);
        List result = this.purchaseDAO.getPurchasesByHourRange(start.atStartOfDay(), end.atTime(LocalTime.MAX));
        log.info("Se encontraron {} registros de compras por rango horario", (Object)result.size());
        return result;
    }

    public List<PurchaseDailySummaryProjection> getDailySummaryProjection(LocalDate start, LocalDate end) {
        LocalDateTime startDateTime = start.atStartOfDay();
        LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
        log.info("Consultando resumen diario de compras entre {} y {}", (Object)startDateTime, (Object)endDateTime);
        List summaryList = this.purchaseDAO.getDailySummaryProjection(startDateTime, endDateTime);
        log.info("Resumen diario obtenido con {} registros", (Object)summaryList.size());
        return summaryList;
    }

    public List<PurchaseByPaymentMethodProjection> getPurchasesByPaymentMethod(LocalDate start, LocalDate end) {
        LocalDateTime startDateTime = start.atStartOfDay();
        LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
        log.info("Consultando compras por m\u00e9todo de pago entre {} y {}", (Object)startDateTime, (Object)endDateTime);
        List result = this.purchaseDAO.getPurchasesByPaymentMethod(startDateTime, endDateTime);
        log.info("Se encontraron {} registros de compras agrupadas por m\u00e9todo de pago", (Object)result.size());
        return result;
    }

    public RedirectSummaryProjection getRedirectConversationToAsesor(LocalDate start, LocalDate end) {
        LocalDateTime startDateTime = start.atStartOfDay();
        LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
        log.info("Consultando redirecciones de conversaci\u00f3n a asesor entre {} y {}", (Object)startDateTime, (Object)endDateTime);
        RedirectSummaryProjection summary = this.purchaseDAO.getRedirectConversationToAsesor(startDateTime, endDateTime);
        if (summary != null) {
            log.info("Redirecciones encontradas: total={}, redirigidas={}", (Object)summary.getTotalPurchase(), (Object)summary.getPurchaseWithRedirectAsesor());
        } else {
            log.warn("No se obtuvo resumen de redirecciones para el rango especificado.");
        }
        return summary;
    }

    public List<UserPurchaseDetailView> findUserPurchaseCSV(LocalDate start, LocalDate end) {
        LocalDateTime startDateTime = start.atStartOfDay();
        LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
        log.info("Consultando detalles de compras de usuario (formato CSV) entre {} y {}", (Object)startDateTime, (Object)endDateTime);
        List result = this.userPurchaseDetailViewDAO.findByLastInteractionDateBetweenOrderByLastInteractionDateDesc(startDateTime, endDateTime);
        log.info("Se encontraron {} registros de detalle de compras de usuario para exportar a CSV", (Object)result.size());
        return result;
    }

    public Page<UserPurchaseDetailView> findUserPurchaseItem(LocalDate start, LocalDate end, Pageable pageable) {
        LocalDateTime startDateTime = start.atStartOfDay();
        LocalDateTime endDateTime = end.atTime(LocalTime.MAX);
        log.info("Consultando \u00edtems de detalle de compras de usuario entre {} y {} - P\u00e1gina: {}, Tama\u00f1o: {}", new Object[]{startDateTime, endDateTime, pageable.getPageNumber(), pageable.getPageSize()});
        PageRequest pageableUpdate = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastInteractionDate"}));
        Page page = this.userPurchaseDetailViewDAO.findByLastInteractionDateBetween(startDateTime, endDateTime, (Pageable)pageableUpdate);
        log.debug("Total elementos encontrados: {}, Total p\u00e1ginas: {}", (Object)page.getTotalElements(), (Object)page.getTotalPages());
        return page;
    }
}

