/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.nimbusds.jose.shaded.gson.Gson;
import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.PurchaseUtils;
import ec.tws2.back.lhia.marcimex.infrastructure.client.LhiaV3Client;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ProductSuggestDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.PurchaseDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MarcimexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductMongoRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductSuggestRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PurchaseRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.VtexRepository;
import ec.tws2.back.lhia.marcimex.models.data.OrderForm;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.ActivityResponseDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ActivitySaveDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ProductMongo;
import ec.tws2.back.lhia.marcimex.models.entity.ProductSuggest;
import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import ec.tws2.back.lhia.marcimex.models.entity.PurchaseDetail;
import ec.tws2.back.lhia.marcimex.models.response.LhiaV3ApiResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PurchaseRepositoryImpl
implements PurchaseRepository {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRepositoryImpl.class);
    @Autowired
    private PurchaseDAO purchaseDAO;
    @Autowired
    private ProductSuggestDAO productSuggestDAO;
    @Autowired
    private ProductSuggestRepository productSuggestRepository;
    @Autowired
    private VtexRepository vtexRepository;
    @Autowired
    private ProductMongoRepository productMongoRepository;
    @Autowired
    private MarcimexRepository marcimexRepository;
    @Autowired
    private LhiaV3Client lhiaV3Client;
    @Value(value="${vtex.url.purchase}")
    private String vtexPurchaseUrl;

    public ResponseEntity<ResponseResult<?>> save(Purchase purchase) {
        try {
            Purchase purchaseSave;
            if (purchase.getPurchaseDetails() != null) {
                for (PurchaseDetail detail : purchase.getPurchaseDetails()) {
                    detail.setPurchase(purchase);
                }
            }
            if ((purchaseSave = (Purchase)this.purchaseDAO.save((Object)purchase)).getId() != null) {
                return TransactionCustom.ok();
            }
            return TransactionCustom.error((String)"Error al crear compra.");
        }
        catch (Exception e) {
            log.info("Error al generar la compra: " + e.getMessage());
            return TransactionCustom.error((String)("Error al crear compra: " + e.getMessage()));
        }
    }

    public Page<Purchase> findListPurchase(Date startDate, Date endDate, int page, int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        LocalDate startLocalDate = startDate.toInstant().atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.of("UTC")).toLocalDate();
        Date startDateUTC = Date.from(startLocalDate.atStartOfDay(ZoneId.of("UTC")).toInstant());
        Date endDateUTC = Date.from(endLocalDate.atTime(LocalTime.MAX).atZone(ZoneId.of("UTC")).toInstant());
        return this.purchaseDAO.findListPurchase(startDateUTC, endDateUTC, (Pageable)pageable);
    }

    public ResponseEntity<ResponseResult<?>> saveActivity(ActivitySaveDTO activitySaveDTO, String token) {
        String activity = activitySaveDTO.getActivity().trim().toUpperCase();
        log.info("Activity : {}", (Object)activity);
        String activityEvent = this.extractActivityEvent(activity);
        log.info("ActivityEvent : {}", (Object)activityEvent);
        String idProduct = "";
        if (activityEvent.equals("ADD_CART")) {
            idProduct = PurchaseRepositoryImpl.getNumberFromEvent((String)activity);
        } else if (activityEvent.equals("DETAIL")) {
            idProduct = PurchaseRepositoryImpl.getNumberFromEvent((String)activity);
        }
        log.info("IdProduct : {}", (Object)idProduct);
        log.info("EventDetail : {}", (Object)"DETAIL");
        log.info("ActivityEvent : {}", (Object)activityEvent);
        switch (activityEvent) {
            case "ADD_CART": {
                return this.addProductInCart(activitySaveDTO, idProduct, token);
            }
            case "ADD_PRODUCT": {
                return this.addProduct(activitySaveDTO);
            }
            case "VER_CARRITO": {
                return this.viewDetailPurchase(activitySaveDTO);
            }
            case "COMPRAR": {
                return this.setUpPurchase(activitySaveDTO);
            }
            case "DETAIL": {
                return this.detailPurchase(idProduct);
            }
            case "FINALIZAR": {
                return this.finishPurchase();
            }
        }
        return this.createResponse("NOT FOUND INSTRUCTION", false, "", Collections.emptyList());
    }

    public ResponseEntity<ResponseResult<?>> addProductInCart(ActivitySaveDTO activitySaveDTO, String idProduct, String token) {
        if (idProduct == null || idProduct.trim().isEmpty()) {
            return this.createResponse("PRODUCT ID NOT VALID", false, "", Collections.emptyList());
        }
        Optional findConversation = this.marcimexRepository.getConversationByIdentificationLast(activitySaveDTO.getIdPlatform());
        if (!findConversation.isPresent()) {
            return this.createResponse("CONVERSATION ID NOT FOUND", false, "", Collections.emptyList());
        }
        LhiaV3ApiResponse.Product lhiaProduct = this.lhiaV3Client.getProductById(idProduct, token);
        if (lhiaProduct == null) {
            return this.createResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.", false, "", Collections.emptyList());
        }
        ProductMongo findProduct = ProductMongo.builder().productId(lhiaProduct.getProductId()).skuId(lhiaProduct.getSkuId()).title(lhiaProduct.getName()).productPriceWithTax(lhiaProduct.getPrice()).imageLink(lhiaProduct.getImage()).link(lhiaProduct.getLink()).brand(lhiaProduct.getBrand()).category(lhiaProduct.getCategory()).productDescription(lhiaProduct.getDescription()).inStock(String.valueOf(lhiaProduct.isInStock())).build();
        this.productSuggestRepository.saveProductMongo(activitySaveDTO.getIdPlatform(), activitySaveDTO.getPlatform(), ((Conversacion)findConversation.get()).getIdentificador(), findProduct);
        return this.addProduct(ActivitySaveDTO.builder().platform(activitySaveDTO.getPlatform()).idPlatform(activitySaveDTO.getIdPlatform()).activity("ADD_PRODUCT").build());
    }

    public ResponseEntity<ResponseResult<?>> detailPurchase(String idProduct) {
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("Detalle Producto...." + idProduct).hasEvent(Boolean.valueOf(false)).titleEvent("").events(Collections.emptyList()).build());
    }

    public ResponseEntity<ResponseResult<?>> finishPurchase() {
        String messageFinish = "Gracias por confiar en *Marcimex*, fue un placer atenderte.\n\nMarcimex piensa en ti.";
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(messageFinish).hasEvent(Boolean.valueOf(false)).titleEvent("").events(Collections.emptyList()).build());
    }

    public ResponseEntity<ResponseResult<?>> addProduct(ActivitySaveDTO activitySaveDTO) {
        ProductSuggest productSuggestTemp = (ProductSuggest)this.productSuggestDAO.findById((Object)activitySaveDTO.getIdPlatform()).orElseThrow(() -> new RuntimeException("PRODUCT NOT FOUND"));
        Purchase purchaseFind = this.purchaseDAO.findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(productSuggestTemp.getIdConversation(), productSuggestTemp.getIdPlatform(), false, true).orElseGet(() -> {
            Purchase newPurchase = new Purchase();
            newPurchase.setPaymentMethod("Solo consultaba");
            newPurchase.setTotalAmount(Double.valueOf(0.0));
            newPurchase.setPlatformId(productSuggestTemp.getIdPlatform());
            newPurchase.setPlatform(productSuggestTemp.getPlatform());
            newPurchase.setConversationId(productSuggestTemp.getIdConversation());
            newPurchase.setUrlPurchase("");
            newPurchase.setPurchaseDetails(new ArrayList());
            return (Purchase)this.purchaseDAO.save((Object)newPurchase);
        });
        purchaseFind.getPurchaseDetails().stream().filter(detail -> productSuggestTemp.getProductId().equals(detail.getProductId())).findFirst().map(detail -> {
            detail.setQuantity(Integer.valueOf(detail.getQuantity() + 1));
            detail.setSubtotal(Double.valueOf((double)detail.getQuantity().intValue() * productSuggestTemp.getUnitPrice()));
            return detail;
        }).orElseGet(() -> {
            PurchaseDetail newDetail = new PurchaseDetail();
            newDetail.setProductId(productSuggestTemp.getProductId());
            newDetail.setSkuId(productSuggestTemp.getSkuId());
            newDetail.setQuantity(Integer.valueOf(1));
            newDetail.setUnitPrice(productSuggestTemp.getUnitPrice());
            newDetail.setSubtotal(productSuggestTemp.getUnitPrice());
            newDetail.setDescription(productSuggestTemp.getDescription());
            newDetail.setUrlImage(productSuggestTemp.getUrlImage());
            newDetail.setPurchase(purchaseFind);
            purchaseFind.getPurchaseDetails().add(newDetail);
            return newDetail;
        });
        double totalAmount = purchaseFind.getPurchaseDetails().stream().mapToDouble(PurchaseDetail::getSubtotal).sum();
        purchaseFind.setTotalAmount(Double.valueOf(totalAmount));
        this.purchaseDAO.save((Object)purchaseFind);
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("\u2705 \u00a1Producto agregado a tu carrito!").hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("VER_CARRITO", "COMPRAR")).build());
    }

    public ResponseEntity<ResponseResult<?>> viewDetailPurchase(ActivitySaveDTO activitySaveDTO) {
        Optional purchaseFind = this.purchaseDAO.findTopByPlatformIdAndCompletedAndStatusOrderByIdDesc(activitySaveDTO.getIdPlatform(), false, true);
        if (!purchaseFind.isPresent()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        System.out.println(purchaseFind);
        StringBuilder detailCartBuilder = new StringBuilder();
        AtomicInteger index = new AtomicInteger(0);
        ((Purchase)purchaseFind.get()).getPurchaseDetails().forEach(product -> {
            String detailCart = String.format("*Item %d*\n%s\n*Cantidad*: %d\n*Precio*: $%.2f\n\n", index.incrementAndGet(), product.getDescription(), product.getQuantity(), product.getUnitPrice());
            detailCartBuilder.append(detailCart);
        });
        String dataView = String.format("Detalle Carrito:\n\n%s*Total*: $%.2f", detailCartBuilder.toString(), ((Purchase)purchaseFind.get()).getTotalAmount());
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(dataView).hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("COMPRAR")).build());
    }

    public ResponseEntity<ResponseResult<?>> setUpPurchase(ActivitySaveDTO activitySaveDTO) {
        Gson gson = new Gson();
        String orderFormId = "";
        Object urlPurchase = "";
        ArrayList<JSONObject> orderItemsSave = new ArrayList<JSONObject>();
        Optional purchaseFind = this.purchaseDAO.findTopByPlatformIdAndCompletedAndStatusOrderByIdDesc(activitySaveDTO.getIdPlatform(), false, true);
        if (!purchaseFind.isPresent()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        List listPurchaseDetail = ((Purchase)purchaseFind.get()).getPurchaseDetails();
        if (listPurchaseDetail == null || listPurchaseDetail.isEmpty()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        try {
            for (int index = 0; index < listPurchaseDetail.size(); ++index) {
                PurchaseDetail item = (PurchaseDetail)listPurchaseDetail.get(index);
                JSONObject itemSave = new JSONObject();
                itemSave.put("quantity", (Object)item.getQuantity());
                itemSave.put("seller", (Object)"1");
                itemSave.put("id", (Object)item.getSkuId());
                itemSave.put("index", index);
                orderItemsSave.add(itemSave);
            }
            JSONObject dataInitForm = this.vtexRepository.initOrderForm();
            OrderForm orderForm = (OrderForm)gson.fromJson(dataInitForm.toString(), OrderForm.class);
            orderFormId = orderForm.getOrderFormId();
            this.vtexRepository.addUTMOrderForm(orderFormId);
            this.vtexRepository.addItemCart(orderFormId, orderItemsSave);
            urlPurchase = this.vtexPurchaseUrl + "?orderFormId=" + orderFormId + "#/cart";
            ((Purchase)purchaseFind.get()).setCompleted(Boolean.valueOf(true));
            ((Purchase)purchaseFind.get()).setUrlPurchase((String)urlPurchase);
            ((Purchase)purchaseFind.get()).setOrderFormId(orderFormId);
            this.purchaseDAO.save((Object)((Purchase)purchaseFind.get()));
            String dataMessagePurchase = this.getMessagePurchase(((Purchase)purchaseFind.get()).getPaymentMethod(), (String)urlPurchase);
            return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(dataMessagePurchase).hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("FINALIZAR")).build());
        }
        catch (Exception e) {
            log.info("Error generating Shopping Cart Link: " + e.getMessage());
            return TransactionCustom.error((String)"ERROR WHEN GENERATING CART");
        }
    }

    public String getMessagePurchase(String methodPayment, String linkCart) {
        switch (methodPayment) {
            case "Pagar con Tarjeta Bancaria": {
                return PurchaseUtils.getMessagePurchase1((String)linkCart);
            }
            case "Pagar con Transferencia o dep\u00f3sito": {
                return PurchaseUtils.getMessagePurchase2((String)linkCart);
            }
            case "Solo consultaba": {
                return PurchaseUtils.getMessagePurchase3((String)linkCart);
            }
        }
        return PurchaseUtils.getMessagePurchase3((String)linkCart);
    }

    public static String getNumberFromEvent(String input) {
        int lastUnderscoreIndex = input.lastIndexOf("_");
        if (lastUnderscoreIndex != -1 && lastUnderscoreIndex < input.length() - 1) {
            return input.substring(lastUnderscoreIndex + 1);
        }
        return "";
    }

    private String extractActivityEvent(String activity) {
        if (activity.contains("ADD_CART_")) {
            return "ADD_CART";
        }
        if (activity.contains("DETAIL_")) {
            return "DETAIL";
        }
        return activity;
    }

    private ResponseEntity<ResponseResult<?>> createResponse(String message, boolean hasEvent, String titleEvent, List<String> events) {
        ActivityResponseDTO responseDTO = ActivityResponseDTO.builder().message(message).hasEvent(Boolean.valueOf(hasEvent)).titleEvent(titleEvent).events(events).build();
        return TransactionCustom.ok((String)"OK", (Object)responseDTO);
    }

    public ResponseEntity<?> getTotalAmountBetweenDates(LocalDate startDate, LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        BigDecimal totalAmount = this.purchaseDAO.getTotalAmountBetweenDates(start, end);
        return TransactionCustom.ok((Object)this.getTotalAmountFormat(totalAmount));
    }

    public ResponseEntity<?> getCountBetweenDates(LocalDate startDate, LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        Long totalCount = this.purchaseDAO.getCountBetweenDates(start, end);
        return TransactionCustom.ok((Object)totalCount);
    }

    public BigDecimal getTotalAmountFormat(BigDecimal total) {
        return total.setScale(2, RoundingMode.HALF_UP);
    }

    public List<Purchase> findAllInRange(LocalDateTime start, LocalDateTime end) {
        return this.purchaseDAO.findAllInRange(start, end);
    }

    public Purchase saveEntity(Purchase purchase) {
        return (Purchase)this.purchaseDAO.save((Object)purchase);
    }

    public Optional<Purchase> findNotPurchasedByOrderFormId(String orderFormId) {
        try {
            return this.purchaseDAO.findNotInvoicedByOrderFormId(orderFormId);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<Purchase> findNotInvoicedByOrderFormIds(List<String> orderFormIds) {
        return this.purchaseDAO.findNotInvoicedByOrderFormIds(orderFormIds);
    }

    public List<Purchase> saveAll(List<Purchase> purchases) {
        return this.purchaseDAO.saveAll(purchases);
    }
}

