/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.PromptDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PromptRepository;
import ec.tws2.back.lhia.marcimex.models.entity.TPrompt;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PromptRepositoryImpl
implements PromptRepository {
    private final PromptDAO promptDAO;

    public TPrompt findByName(String name) {
        return (TPrompt)this.promptDAO.findByName(name).orElseThrow(() -> new RuntimeException("Prompt not found"));
    }

    public ResponseEntity<?> postCreatePrompt(TPrompt prompt) {
        TPrompt promptNew = (TPrompt)this.promptDAO.save((Object)prompt);
        return TransactionCustom.ok((Object)promptNew);
    }

    public ResponseEntity<?> putUpdatePrompt(Long id, TPrompt prompt) {
        Optional promptTemp = this.promptDAO.findById((Object)id);
        if (promptTemp.isPresent()) {
            ((TPrompt)promptTemp.get()).setName(prompt.getName());
            ((TPrompt)promptTemp.get()).setContent(prompt.getContent());
            TPrompt promptUpdate = (TPrompt)this.promptDAO.save((Object)((TPrompt)promptTemp.get()));
            return TransactionCustom.ok((Object)promptUpdate);
        }
        return TransactionCustom.error((String)"Prompt not found.");
    }

    public ResponseEntity<?> getFindByName(String name) {
        try {
            TPrompt prompt = this.findByName(name);
            return TransactionCustom.ok((Object)prompt);
        }
        catch (RuntimeException e) {
            return TransactionCustom.error((String)"Prompt not found.");
        }
    }

    public PromptRepositoryImpl(PromptDAO promptDAO) {
        this.promptDAO = promptDAO;
    }
}

