/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.util.ProductUtil;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ProductSuggestDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductSuggestRepository;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.entity.ProductMongo;
import ec.tws2.back.lhia.marcimex.models.entity.ProductSuggest;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductSuggestRepositoryImpl
implements ProductSuggestRepository {
    private static final Logger log = LoggerFactory.getLogger(ProductSuggestRepositoryImpl.class);
    @Autowired
    private ProductSuggestDAO productSuggestDAO;

    public ProductSuggest save(ProductSuggest product) {
        return (ProductSuggest)this.productSuggestDAO.save((Object)product);
    }

    public ProductSuggest saveProductVectorial(String idPlatform, String platform, String idConversation, ProductVectorial product) {
        Optional productSuggestFind = this.productSuggestDAO.findById((Object)idPlatform);
        ProductSuggest productSuggestTemp = ProductSuggest.builder().idPlatform(productSuggestFind.isPresent() ? ((ProductSuggest)productSuggestFind.get()).getIdPlatform() : idPlatform).platform(platform).productId(product.getId()).skuId(Long.valueOf(product.getSkuId())).unitPrice(Double.valueOf(ProductUtil.convertToDouble((String)product.getPrecio()))).description(product.getTitulo()).urlImage(product.getImagenUrl()).idConversation(idConversation).build();
        return (ProductSuggest)this.productSuggestDAO.save((Object)productSuggestTemp);
    }

    public ProductSuggest saveProductMongo(String idPlatform, String platform, String idConversation, ProductMongo product) {
        Optional productSuggestFind = this.productSuggestDAO.findById((Object)idPlatform);
        if (productSuggestFind.isPresent()) {
            log.info("Actualizando ProductSuggest existente - idPlatform: {}, productId: {}", (Object)idPlatform, (Object)product.getProductId());
        } else {
            log.info("Creando nuevo ProductSuggest - idPlatform: {}, productId: {}", (Object)idPlatform, (Object)product.getProductId());
        }
        ProductSuggest productSuggestTemp = ProductSuggest.builder().idPlatform(productSuggestFind.map(ProductSuggest::getIdPlatform).orElse(idPlatform)).platform(platform).productId(Long.valueOf(Long.parseLong(product.getProductId()))).skuId(Long.valueOf(product.getSkuId())).unitPrice(Double.valueOf(ProductUtil.convertToDouble((String)product.getProductPriceWithTax()))).description(product.getTitle()).urlImage(product.getImageLink()).idConversation(idConversation).build();
        ProductSuggest saved = (ProductSuggest)this.productSuggestDAO.save((Object)productSuggestTemp);
        log.info("ProductSuggest guardado correctamente - idPlatform: {}, productId: {}", (Object)saved.getIdPlatform(), (Object)saved.getProductId());
        return saved;
    }
}

