/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.util.UtilLhia;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.OpenAiRepository;
import ec.tws2.back.lhia.marcimex.models.data.ConversacionUsuario;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OpenAiRepositoryImpl
implements OpenAiRepository {
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    private Logger log = Logger.getLogger(OpenAiRepositoryImpl.class.getName());
    private final RestTemplate restTemplate = new RestTemplate();
    UtilLhia utilLhia = new UtilLhia();

    public String answerOpenAi(List<ConversacionUsuario> listConversation, int maxTokens) {
        try {
            Map requestBody = this.createRequestBodyOpenAi(listConversation, maxTokens);
            HttpEntity request = this.createHttpRequestOpenAi(requestBody);
            ResponseEntity response = this.restTemplate.exchange(this.urlAnswer2, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return this.utilLhia.extractTextFromResponse(response);
        }
        catch (Exception e) {
            this.log.info("Error al obtener respuesta de OpenAI: " + String.valueOf(e));
            return "";
        }
    }

    private Map<String, Object> createRequestBodyOpenAi(List<ConversacionUsuario> listConversation, int maxTokens) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", listConversation);
        requestBody.put("max_tokens", maxTokens);
        return requestBody;
    }

    private HttpEntity<Map<String, Object>> createHttpRequestOpenAi(Map<String, Object> requestBody) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        return new HttpEntity(requestBody, (MultiValueMap)headers);
    }
}

