/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import ec.tws2.back.lhia.marcimex.common.util.PromptsQuestionUtil;
import ec.tws2.back.lhia.marcimex.infrastructure.client.OpenAiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.RolDao;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.OpenAiClientRepository;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ConversacionDetalle;
import ec.tws2.back.lhia.marcimex.models.entity.Rol;
import ec.tws2.back.lhia.marcimex.models.request.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.request.OpenAiRequest;
import ec.tws2.back.lhia.marcimex.models.request.QuestionRequest;
import ec.tws2.back.lhia.marcimex.models.response.OpenAiResponse;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OpenAiClientRepositoryImpl
implements OpenAiClientRepository {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClientRepositoryImpl.class);
    private static final String DEFAULT_USER = "USER-ADMIN";
    private static final String DEFAULT_NUMBER = "0000000001";
    private static final String DEFAULT_CANAL = "WEB-ADMIN";
    private final OpenAiClient openAiClient;
    private final ConversacionDetalleDAO conversacionDetalleDAO;
    private final ConversacionDAO conversacionDAO;
    private final RolDao rolDAO;
    private final EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private final Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);

    public Map<String, Object> correctMessage(QuestionRequest request) {
        String question = request.getMessage().trim();
        String prompt = PromptsQuestionUtil.correctMessage;
        List listMessages = this.getListMessages(question, prompt);
        OpenAiResponse response = this.openAiClient.getLhiaQuestion(listMessages, 300);
        String content = ((OpenAiResponse.Choice)response.getChoices().get(0)).getMessage().getContent();
        String nameAssistant = "ASISTENTE REDACCI\u00d3N";
        this.processResponse(UUID.randomUUID().toString(), content, question, nameAssistant);
        log.info("Response Lhia: {}", (Object)content);
        Map result = this.getResultCorrectMessage(request, content);
        return result;
    }

    public Map<String, Object> questionLhia(LhiaRequest request) {
        String question = request.getQuestion().trim();
        String prompt = PromptsQuestionUtil.questionLhia;
        List listMessages = this.getListMessages(question, prompt);
        OpenAiResponse response = this.openAiClient.getLhiaQuestion(listMessages, 400);
        String content = ((OpenAiResponse.Choice)response.getChoices().get(0)).getMessage().getContent();
        String nameAssistant = "ASISTENTE FAQ";
        this.processResponse(UUID.randomUUID().toString(), content, question, nameAssistant);
        log.info("Response Lhia: {}", (Object)content);
        return this.getResultQuestionLhia(content);
    }

    private Map<String, Object> getResultQuestionLhia(String content) {
        if (content != null && content.toLowerCase().contains("no encuentro esa informaci\u00f3n")) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("respuesta", content);
        return result;
    }

    private Map<String, Object> getResultCorrectMessage(QuestionRequest request, String content) {
        List<String> suggestionList = Arrays.stream(content.split("(?m)^\\s*[-\u2022\\d\\.]*\\s*")).map(String::trim).filter(line -> !line.isEmpty()).toList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("original", request.getMessage());
        result.put("suggestions", suggestionList);
        return result;
    }

    private List<OpenAiRequest.Message> getListMessages(String question, String prompt) {
        List<OpenAiRequest.Message> listMessages = List.of(new OpenAiRequest.Message("system", prompt), new OpenAiRequest.Message("user", question));
        return listMessages;
    }

    public void processResponse(String identificationQuest, String content, String question, String nameAssistant) {
        String prompt = "contexto: " + content + "\n";
        String promptComplete = prompt.concat("pregunta: " + question.replaceAll("\n", ""));
        this.saveConversation(identificationQuest, "system", "", 0.0, 0, "", nameAssistant);
        this.saveConversation(identificationQuest, "user", promptComplete, 0.0, this.encoding.countTokens(promptComplete), question.replaceAll("\n", ""), nameAssistant);
        this.saveConversation(identificationQuest, "assistant", content, 0.0, this.encoding.countTokens(content), "", nameAssistant);
    }

    public void saveConversation(String identificationQuest, String rol, String message, double score, int tokens, String question, String nameAssistant) {
        Optional conversationFound = this.conversacionDAO.findByIdentificador(identificationQuest);
        if (conversationFound.isPresent()) {
            Conversacion conversation = (Conversacion)conversationFound.get();
            this.saveConversationDetail(rol, message, score, tokens, question, conversation);
        } else {
            Conversacion conversationNew = new Conversacion();
            conversationNew.setUsuario(DEFAULT_USER);
            conversationNew.setIdentificador(identificationQuest);
            conversationNew.setNumero_celular(DEFAULT_NUMBER);
            conversationNew.setCanal(DEFAULT_CANAL);
            conversationNew.setFecha(this.dateEcuador());
            conversationNew.setRoles((Rol)this.rolDAO.findByDescripcion(nameAssistant).get());
            Conversacion conversation = (Conversacion)this.conversacionDAO.save((Object)conversationNew);
            this.saveConversationDetail(rol, "", 0.0, 0, "", conversation);
        }
    }

    private void saveConversationDetail(String rol, String message, double score, int tokens, String question, Conversacion conversation) {
        ConversacionDetalle conversationDetail = new ConversacionDetalle();
        conversationDetail.setRol(rol);
        conversationDetail.setMensaje(message);
        conversationDetail.setScore(score);
        conversationDetail.setTokens(tokens);
        conversationDetail.setPregunta(question);
        conversationDetail.setId_conversacion(conversation);
        conversationDetail.setFecha(this.dateEcuador());
        this.conversacionDetalleDAO.save((Object)conversationDetail);
    }

    public Date dateEcuador() {
        LocalDateTime dateHourEcuador = LocalDateTime.now();
        return Date.from(dateHourEcuador.atZone(ZoneId.systemDefault()).toInstant());
    }

    public OpenAiClientRepositoryImpl(OpenAiClient openAiClient, ConversacionDetalleDAO conversacionDetalleDAO, ConversacionDAO conversacionDAO, RolDao rolDAO) {
        this.openAiClient = openAiClient;
        this.conversacionDetalleDAO = conversacionDetalleDAO;
        this.conversacionDAO = conversacionDAO;
        this.rolDAO = rolDAO;
    }
}

