/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.client.MxVtexApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MxVtexRepository;
import ec.tws2.back.lhia.marcimex.models.data.CreditInfo;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.dto.PricingLoadstoneDto;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MxVtexRepositoryImpl
implements MxVtexRepository {
    private static final Logger log = LoggerFactory.getLogger(MxVtexRepositoryImpl.class);
    private final MxVtexApiClient mxVtexApiClient;
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance(new Locale("es", "EC"));

    public MxVtexRepositoryImpl(MxVtexApiClient mxVtexApiClient) {
        this.mxVtexApiClient = mxVtexApiClient;
    }

    public Double getPriceProductValue(int skuId) {
        PricingLoadstoneDto priceProduct = this.mxVtexApiClient.getPricingLoadstone(skuId);
        return priceProduct != null && priceProduct.getTotalToPay() != null ? priceProduct.getTotalToPay().doubleValue() : 0.0;
    }

    public ResponseRobot getPriceProduct(ResponseRobot resp) {
        if (resp == null || resp.getListProductVectorial() == null) {
            return resp;
        }
        int totalEntrada = resp.getListProductVectorial().size();
        log.info("getPriceProduct: procesando {} productos en paralelo", (Object)totalEntrada);
        List<CompletableFuture> futures = resp.getListProductVectorial().stream().map(item -> CompletableFuture.runAsync(() -> this.fetchPrice(item))).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        resp.getListProductVectorial().removeIf(item -> item.getCreditInfo() == null);
        log.info("getPriceProduct: {}/{} productos con creditInfo valido", (Object)resp.getListProductVectorial().size(), (Object)totalEntrada);
        return resp;
    }

    private void fetchPrice(ProductVectorial item) {
        int skuId = item.getSkuId();
        if (skuId <= 0) {
            log.warn("Producto omitido (skuId invalido={}): titulo='{}'", (Object)skuId, (Object)item.getTitulo());
            return;
        }
        try {
            log.info("Consultando precio: skuId={}, titulo='{}'", (Object)skuId, (Object)item.getTitulo());
            PricingLoadstoneDto priceProduct = this.mxVtexApiClient.getPricingLoadstone(skuId);
            if (priceProduct != null) {
                String price = MxVtexRepositoryImpl.formatPriceString((String)item.getPrecio());
                if (price != null) {
                    item.setPrecio(price);
                }
                String precioCredit = this.formatPrice(priceProduct.getTotalToPay());
                int plazo = priceProduct.getTerm();
                String cuota = this.formatPrice(priceProduct.getInstallment());
                log.info("Precio OK skuId={}: finalAPagar={}, plazo={}, cuota={}", new Object[]{skuId, precioCredit, plazo, cuota});
                item.setCreditInfo(new CreditInfo(precioCredit, plazo, cuota));
            } else {
                log.warn("No se pudo obtener precio para skuId={}, titulo='{}'", (Object)skuId, (Object)item.getTitulo());
            }
        }
        catch (Exception e) {
            log.warn("Error al consultar precio skuId={}, producto omitido: {}", (Object)skuId, (Object)e.getMessage());
        }
    }

    public static String formatPriceString(String price) {
        if (price == null || price.isBlank()) {
            return null;
        }
        String onlyNumber = price.replace("USD", "").trim().replace(".", "").replace(",", ".");
        double valor = Double.parseDouble(onlyNumber);
        return CURRENCY_FORMAT.format(valor);
    }

    public String formatPrice(BigDecimal price) {
        if (price == null) {
            return null;
        }
        return CURRENCY_FORMAT.format(price);
    }
}

