/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import ec.tws2.back.lhia.marcimex.common.util.ProductVectorMapper;
import ec.tws2.back.lhia.marcimex.common.util.PromptsUtil;
import ec.tws2.back.lhia.marcimex.common.util.UtilLhia;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ActividadDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.OpcionesDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.RolDao;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MarcimexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MilvusRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.OpenAiRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductRecommendationRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductSuggestRepository;
import ec.tws2.back.lhia.marcimex.models.data.ConversacionAsesor;
import ec.tws2.back.lhia.marcimex.models.data.ConversacionUsuario;
import ec.tws2.back.lhia.marcimex.models.data.ConversationResolution;
import ec.tws2.back.lhia.marcimex.models.data.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.data.ParametroConversacionAsesor;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.data.RespuestaVector;
import ec.tws2.back.lhia.marcimex.models.data.TemasConsumo;
import ec.tws2.back.lhia.marcimex.models.data.UsuariosConsumo;
import ec.tws2.back.lhia.marcimex.models.entity.Actividad;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ConversacionDetalle;
import ec.tws2.back.lhia.marcimex.models.entity.Opciones;
import ec.tws2.back.lhia.marcimex.models.entity.ProductRecommendation;
import ec.tws2.back.lhia.marcimex.models.entity.Rol;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MarcimexRepositoryImpl
implements MarcimexRepository {
    private static final Logger log = LoggerFactory.getLogger(MarcimexRepositoryImpl.class);
    UtilLhia utilLhia = new UtilLhia();
    String iniTextNew;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private ProductVectorMapper productVectorMapper;
    @Autowired
    private RolDao rolDAO;
    @Autowired
    private OpcionesDAO opcionesDAO;
    @Autowired
    private ActividadDAO actividadDAO;
    @Autowired
    private ProductSuggestRepository productSuggestRepository;
    @Autowired
    private MilvusRepository milvusRepository;
    @Autowired
    private OpenAiRepository openAiRepository;
    @Autowired
    private ProductRecommendationRepository productRecommendationRepository;
    private final RestTemplate restTemplate = new RestTemplate();
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    private String textSystem = "";

    public ResponseRobot findProductsByQuestion(LhiaRequest lhiaRequest) {
        String questionClean = Optional.ofNullable(lhiaRequest.getQuestion()).orElse("").toLowerCase();
        if (questionClean.contains("asesor")) {
            ResponseRobot responseRobotTemp = new ResponseRobot();
            responseRobotTemp.setResponse("REDIRECT_ASESOR");
            responseRobotTemp.setListProductVectorial(Collections.emptyList());
            return responseRobotTemp;
        }
        String platform = lhiaRequest.getPlatform() != null ? lhiaRequest.getPlatform().name() : null;
        String identificationQuestion = this.getIdentificationQuestion(lhiaRequest.getIdentificador(), lhiaRequest.getIdPlatform(), platform);
        log.info("identification => {}", (Object)identificationQuestion);
        List conversationUser = this.buildConversacionUser(identificationQuestion, lhiaRequest.getQuestion());
        ResponseRobot responseRobot = this.answerOpenAiForProducts(conversationUser, lhiaRequest.getIdPlatform());
        if (!responseRobot.getResponse().isEmpty()) {
            this.processResponse(responseRobot, identificationQuestion, lhiaRequest.getUsuario(), lhiaRequest.getQuestion(), lhiaRequest.getIdPlatform(), platform);
        }
        return this.handleSingleProduct(responseRobot, lhiaRequest.getIdPlatform(), platform, identificationQuestion);
    }

    public ResponseEntity<?> startConversacion(String identification, String nick, String numberPhone, String canal, String rol) {
        if (!this.conversacionDAO.existsByIdentificador(identification)) {
            Conversacion newConversation = new Conversacion();
            newConversation.setUsuario(nick);
            newConversation.setIdentificador(identification);
            newConversation.setNumero_celular(numberPhone.isEmpty() ? "9999999999" : numberPhone);
            newConversation.setCanal(canal);
            newConversation.setRoles((Rol)this.rolDAO.findByDescripcion(rol).get());
            newConversation.setFecha(this.utilLhia.fechaEcuador());
            return ResponseEntity.ok((Object)((Conversacion)this.conversacionDAO.save((Object)newConversation)));
        }
        return ResponseEntity.badRequest().build();
    }

    public ResponseEntity<?> actividadConversacion(String identificador, Long opcion, String pregunta, String respuesta) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            Actividad newActivity = new Actividad();
            newActivity.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
            newActivity.setId_opciones((Opciones)this.opcionesDAO.findById((Object)opcion).get());
            newActivity.setTexto_pregunta(pregunta);
            newActivity.setTexto_respuesta(respuesta);
            newActivity.setFecha(this.utilLhia.fechaEcuador());
            return ResponseEntity.ok((Object)((Actividad)this.actividadDAO.save((Object)newActivity)));
        }
        return ResponseEntity.badRequest().build();
    }

    public void generateNumTokens() {
        List listaConversacionDetalle = this.conversacionDetalleDAO.findAll();
        for (ConversacionDetalle conversacionDetalle : listaConversacionDetalle) {
            if (!conversacionDetalle.getRol().equals("user") && !conversacionDetalle.getRol().equals("assistant")) continue;
            conversacionDetalle.setTokens(this.encoding.countTokens(conversacionDetalle.getMensaje()));
            this.conversacionDetalleDAO.save((Object)conversacionDetalle);
        }
    }

    public int obtenerTokens(Date fecha1, Date fecha2) {
        if (this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2) != null) {
            return Integer.valueOf(this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2));
        }
        return 0;
    }

    public List<UsuariosConsumo> obtenerlistadoUsuarios(Date fecha1, Date fecha2) {
        return this.conversacionDAO.listadoUsuarios(fecha1, fecha2);
    }

    public List<TemasConsumo> obtenerTemas(Date fecha1, Date fecha2, String rol) {
        return this.opcionesDAO.listadoTemasFrecuencia(fecha1, fecha2, rol);
    }

    public List<Actividad> listadoActividadOpciones(Long id, Date fecha1, Date fecha2) throws ParseException, InterruptedException, ExecutionException {
        List a = this.actividadDAO.listadoActividadOpciones(id, fecha1, fecha2);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (Actividad actividad : a) {
            boolean opcion_9;
            boolean opcion_1 = actividad.getId_opciones().getId_opciones() == 1L && actividad.getTexto_pregunta().contains("Ventas");
            boolean opcion_2 = actividad.getId_opciones().getId_opciones() == 2L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_3 = actividad.getId_opciones().getId_opciones() == 3L && actividad.getTexto_pregunta().contains("Cobranzas");
            boolean opcion_4 = actividad.getId_opciones().getId_opciones() == 4L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_5 = actividad.getId_opciones().getId_opciones() == 5L && actividad.getTexto_pregunta().contains("Servicio T\u00e9cnico");
            boolean opcion_6 = actividad.getId_opciones().getId_opciones() == 6L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_7 = actividad.getId_opciones().getId_opciones() == 7L && actividad.getTexto_pregunta().contains("Servicio T\u00e9cnico");
            boolean opcion_8 = actividad.getId_opciones().getId_opciones() == 8L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean bl = opcion_9 = actividad.getId_opciones().getId_opciones() == 9L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            if (!opcion_1 && !opcion_2 && !opcion_3 && !opcion_4 && !opcion_5 && !opcion_6 && !opcion_7 && !opcion_8 && !opcion_9) continue;
            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                try {
                    return (String)this.obtenerConversacionAsesor(act.getTexto_respuesta()).get();
                }
                catch (InterruptedException | ParseException | ExecutionException e) {
                    e.printStackTrace();
                    return "Error obtaining conversation";
                }
            }).thenAccept(response -> act.setTexto_respuesta(response));
            futures.add(future);
        }
        for (CompletableFuture completableFuture : futures) {
            completableFuture.get();
        }
        return a;
    }

    public Page<Actividad> listadoActividadOpcionesPaginado(Long id, Date fecha1, Date fecha2, int pagina, int filas) throws ParseException, InterruptedException, ExecutionException {
        PageRequest pageable = PageRequest.of((int)pagina, (int)filas);
        Page actividadPage = this.actividadDAO.listadoActividadOpcionesPaginado(id, fecha1, fecha2, (Pageable)pageable);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (Actividad actividad : actividadPage) {
            boolean opcion_9;
            boolean opcion_1 = actividad.getId_opciones().getId_opciones() == 1L && actividad.getTexto_pregunta().contains("Ventas");
            boolean opcion_2 = actividad.getId_opciones().getId_opciones() == 2L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_3 = actividad.getId_opciones().getId_opciones() == 3L && actividad.getTexto_pregunta().contains("Cobranzas");
            boolean opcion_4 = actividad.getId_opciones().getId_opciones() == 4L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_5 = actividad.getId_opciones().getId_opciones() == 5L && actividad.getTexto_pregunta().contains("Servicio T\u00e9cnico");
            boolean opcion_6 = actividad.getId_opciones().getId_opciones() == 6L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean opcion_7 = actividad.getId_opciones().getId_opciones() == 7L && actividad.getTexto_pregunta().contains("Servicio T\u00e9cnico");
            boolean opcion_8 = actividad.getId_opciones().getId_opciones() == 8L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            boolean bl = opcion_9 = actividad.getId_opciones().getId_opciones() == 9L && actividad.getTexto_pregunta().contains("Atenci\u00f3n al Cliente");
            if (!opcion_1 && !opcion_2 && !opcion_3 && !opcion_4 && !opcion_5 && !opcion_6 && !opcion_7 && !opcion_8 && !opcion_9) continue;
            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                try {
                    return (String)this.obtenerConversacionAsesor(act.getTexto_respuesta()).get();
                }
                catch (InterruptedException | ParseException | ExecutionException e) {
                    e.printStackTrace();
                    return "Error obtaining conversation";
                }
            }).thenAccept(response -> act.setTexto_respuesta(response));
            futures.add(future);
        }
        for (CompletableFuture completableFuture : futures) {
            completableFuture.get();
        }
        return actividadPage;
    }

    public String getIdentificationLastConversation(String idPlatform) {
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        Page resultado = this.conversacionDAO.findLastByNumeroCelular(idPlatform, (Pageable)pageable);
        if (resultado.hasContent()) {
            Conversacion ultimaConversacion = (Conversacion)resultado.getContent().get(0);
            return ultimaConversacion.getIdentificador();
        }
        return null;
    }

    public Optional<Conversacion> getConversationByIdentificationLast(String idPlatform) {
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        Page resultado = this.conversacionDAO.findLastByNumeroCelular(idPlatform, (Pageable)pageable);
        if (resultado.hasContent()) {
            return Optional.of((Conversacion)resultado.getContent().get(0));
        }
        return Optional.empty();
    }

    @Async
    public CompletableFuture<String> obtenerConversacionAsesor(String roomId) throws ParseException {
        String URL2 = "https://flow.lhia.ai/chat/getConversation";
        ParametroConversacionAsesor payload = new ParametroConversacionAsesor(roomId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(URL2, HttpMethod.POST, request, ConversacionAsesor[].class, new Object[0]);
        ConversacionAsesor[] messages = (ConversacionAsesor[])response.getBody();
        if (messages == null) {
            return CompletableFuture.completedFuture("No messages found");
        }
        List<ConversacionAsesor> messageList = Arrays.asList(messages);
        Collections.sort(messageList, Comparator.comparing(ConversacionAsesor::getCreatedAt));
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        SimpleDateFormat outputFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        StringBuilder chatBuilder = new StringBuilder();
        for (ConversacionAsesor message : messageList) {
            String origin;
            String formattedDate = outputFormat.format(inputFormat.parse(message.getCreatedAt()));
            String string = origin = message.getOrigin().equals("User") ? "Usuario" : message.getOrigin();
            if (message.getText() != null) {
                chatBuilder.append(origin).append(": ").append(message.getText()).append("\n");
                chatBuilder.append("Fecha: ").append(formattedDate).append("\n\n");
                continue;
            }
            if (message.getUrl() == null) continue;
            chatBuilder.append(origin).append(": ").append(message.getUrl()).append("\n");
            chatBuilder.append("Fecha: ").append(formattedDate).append("\n\n");
        }
        return CompletableFuture.completedFuture(chatBuilder.toString());
    }

    private String getIdentificationQuestion(String identificador, String idPlatform, String platform) {
        String identificadorQuestion = Optional.ofNullable(idPlatform).flatMap(id -> Optional.ofNullable(platform).map(p -> this.getIdentificationLastConversation(idPlatform))).orElseGet(() -> {
            if (identificador == null || identificador.isBlank()) {
                return UUID.randomUUID().toString();
            }
            return identificador;
        });
        return identificadorQuestion;
    }

    private List<ConversacionUsuario> buildConversacionUser(String identificationQuestion, String question) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        String iniTextNew = PromptsUtil.PROMPTS_PRODUCTS;
        conversacionUsuario.add(new ConversacionUsuario("system", iniTextNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificationQuestion);
        conversacion.sort(Comparator.comparingLong(ConversacionDetalle::getId_conversacion_detalle));
        conversacion.forEach(c -> {
            if ("user".equals(c.getRol()) || "assistant".equals(c.getRol())) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
        });
        String pregunta = question.isEmpty() ? "usuario: hola" : question.toUpperCase();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta.replaceAll("\n", "")));
        return conversacionUsuario;
    }

    private void processResponse(ResponseRobot responseRobot, String identificationQuestion, String usuario, String question, String idPlatform, String platform) {
        String prompt = "contexto: " + responseRobot.getResponse() + "\n";
        String promptCompleto = prompt.concat("pregunta: " + question.replaceAll("\n", ""));
        this.guardarConversacion(identificationQuestion, usuario, "", "", 0.0, 0, "", idPlatform, platform);
        this.guardarConversacion(identificationQuestion, usuario, "user", promptCompleto, 0.0, this.encoding.countTokens(promptCompleto), question.replaceAll("\n", ""), idPlatform, platform);
        this.guardarConversacion(identificationQuestion, usuario, "assistant", responseRobot.getResponse(), 0.0, this.encoding.countTokens(responseRobot.getResponse()), "", idPlatform, platform);
    }

    private ResponseRobot handleSingleProduct(ResponseRobot responseRobot, String idPlatform, String platform, String identificationQuestion) {
        if (responseRobot.getListProductVectorial().size() == 1) {
            ProductVectorial productVectorial = (ProductVectorial)responseRobot.getListProductVectorial().get(0);
            ResponseRobot responseRobotTemp = new ResponseRobot();
            responseRobotTemp.setResponse("ADD_PRODUCT");
            responseRobotTemp.setListProductVectorial(responseRobot.getListProductVectorial());
            if (idPlatform != null && platform != null) {
                this.productSuggestRepository.saveProductVectorial(idPlatform, platform, identificationQuestion, productVectorial);
            }
            return responseRobotTemp;
        }
        return responseRobot;
    }

    public ConversationResolution resolveConversationUuidV3(String identificador, String idPlatform, String usuario, String canal) {
        PageRequest pageable;
        Date fiveHoursAgo;
        Page results;
        if (identificador != null && !identificador.isBlank()) {
            Date fiveHoursAgoById = Date.from(LocalDateTime.now().minusHours(5L).atZone(ZoneId.systemDefault()).toInstant());
            if (this.conversacionDAO.existsByIdentificadorAndFinalizadaFalseAndFechaAfter(identificador, fiveHoursAgoById)) {
                log.info("Usando UUID de conversacion existente: {}", (Object)identificador);
                return new ConversationResolution(identificador, false);
            }
            log.info("UUID recibido no cumple condiciones (no existe, finalizada=true o mayor a 5h), creando conversacion: {}", (Object)identificador);
            Conversacion newConversation = new Conversacion();
            newConversation.setIdentificador(identificador);
            newConversation.setUsuario(usuario != null ? usuario : "");
            newConversation.setNumero_celular(idPlatform != null ? idPlatform : "");
            newConversation.setCanal(canal != null ? canal : "");
            newConversation.setFecha(this.utilLhia.fechaEcuador());
            newConversation.setRoles((Rol)this.rolDAO.findByDescripcion("ASISTENTE").get());
            this.conversacionDAO.save((Object)newConversation);
            return new ConversationResolution(identificador, true);
        }
        if (idPlatform != null && !idPlatform.isBlank() && (results = this.conversacionDAO.findLastByNumeroCelularSince(idPlatform, fiveHoursAgo = Date.from(LocalDateTime.now().minusHours(5L).atZone(ZoneId.systemDefault()).toInstant()), (Pageable)(pageable = PageRequest.of((int)0, (int)1)))).hasContent()) {
            String foundUuid = ((Conversacion)results.getContent().get(0)).getIdentificador();
            log.info("Conversacion encontrada en rango 5h para idPlatform={}: {}", (Object)idPlatform, (Object)foundUuid);
            return new ConversationResolution(foundUuid, false);
        }
        String newUuid = UUID.randomUUID().toString();
        log.info("Creando nueva conversacion V3 con UUID: {}", (Object)newUuid);
        Conversacion newConversation = new Conversacion();
        newConversation.setIdentificador(newUuid);
        newConversation.setUsuario(usuario != null ? usuario : "");
        newConversation.setNumero_celular(idPlatform != null ? idPlatform : "");
        newConversation.setCanal(canal != null ? canal : "");
        newConversation.setFecha(this.utilLhia.fechaEcuador());
        newConversation.setRoles((Rol)this.rolDAO.findByDescripcion("ASISTENTE").get());
        this.conversacionDAO.save((Object)newConversation);
        return new ConversationResolution(newUuid, true);
    }

    public void guardarConversacion(String identificador, String usuario, String rol, String mensaje, double score, int prompts, String pregunta, String idPlatform, String platform) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens(prompts);
                conversacion_detalle.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(this.utilLhia.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion newConversatio = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            newConversatio.setUsuario(usuario);
            newConversatio.setIdentificador(identificador);
            newConversatio.setNumero_celular(idPlatform);
            newConversatio.setCanal(platform);
            newConversatio.setFecha(this.utilLhia.fechaEcuador());
            newConversatio.setRoles((Rol)this.rolDAO.findByDescripcion("ASISTENTE").get());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)newConversatio);
            conversacion_detalle.setRol("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(this.textSystem);
            conversacion_detalle.setTokens(0);
            conversacion_detalle.setId_conversacion(aux);
            conversacion_detalle.setFecha(this.utilLhia.fechaEcuador());
            conversacion_detalle.setPregunta("");
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseRobot answerOpenAiForProducts(List<ConversacionUsuario> listConversation, String idPlatform) {
        Optional productRecommendationFind;
        boolean isActivePromotion = false;
        String recommendationUser = "";
        Object textAnswerIA = this.openAiRepository.answerOpenAi(listConversation, 150);
        if (this.utilLhia.containsAny((String)textAnswerIA, new String[]{"asesor"})) {
            return this.utilLhia.createDefaultResponse("REDIRECT_ASESOR");
        }
        if (idPlatform != null && (productRecommendationFind = this.productRecommendationRepository.findById(idPlatform)).isPresent()) {
            String string = recommendationUser = ((ProductRecommendation)productRecommendationFind.get()).getRecommendation() != null ? ((ProductRecommendation)productRecommendationFind.get()).getRecommendation() : "";
        }
        if (this.utilLhia.containsAny((String)textAnswerIA, new String[]{"PROMOCION"}) || recommendationUser.equals("PROMOCION")) {
            isActivePromotion = true;
            String newTextFormat = ((String)textAnswerIA).replace("PROMOCION", "");
            textAnswerIA = "Producto Categoria: PROMOCION " + newTextFormat;
        }
        if (this.utilLhia.containsAny((String)textAnswerIA, new String[]{"listar producto", "listar_producto", "Disponemos"})) {
            return this.handleProductListResponse((String)textAnswerIA, 10, 3, isActivePromotion);
        }
        if (this.utilLhia.containsAny((String)textAnswerIA, new String[]{"producto encontrado", "producto_encontrado", "product_encontrado", "disponible", "Disponible"})) {
            return this.handleSingleProductResponse((String)textAnswerIA, 1);
        }
        return this.utilLhia.createDefaultResponse((String)textAnswerIA);
    }

    private ResponseRobot handleProductListResponse(String text, int amount, int limit, boolean isActivePromotion) {
        ResponseEntity responseResponseVector = this.milvusRepository.respondePreguntasMilvusCollectionV2(text.toLowerCase(), amount);
        List productos = this.productVectorMapper.transformarRespuestaALista(((RespuestaVector)responseResponseVector.getBody()).getContenido());
        if (isActivePromotion) {
            productos = productos.stream().sorted(Comparator.comparing(ProductVectorial::getProductCategory).reversed()).collect(Collectors.toList());
        }
        log.info("Total Products: {}", (Object)productos.size());
        List productosTemp = productos.subList(0, Math.min(limit, productos.size()));
        return this.utilLhia.getResponseRobotOfListProduct(text, productosTemp);
    }

    private ResponseRobot handleSingleProductResponse(String text, int amount) {
        ResponseEntity responseResponseVector = this.milvusRepository.respondePreguntasMilvusCollectionV2(text.toLowerCase(), amount);
        List productos = this.productVectorMapper.transformarRespuestaALista(((RespuestaVector)responseResponseVector.getBody()).getContenido());
        return this.getResponseRobotOfProduct(text, productos);
    }

    public ResponseRobot getResponseRobotOfProduct(String question, List<ProductVectorial> secciones) {
        try {
            StringBuilder resultadoBusqueda = new StringBuilder();
            resultadoBusqueda.append("Disponemos de: \n");
            for (ProductVectorial seccion : secciones) {
                resultadoBusqueda.append(seccion.getTitulo()).append("\n").append("Precio: " + seccion.getPrecio() + "\n\n");
            }
            ResponseRobot responseR = new ResponseRobot();
            if (secciones.size() == 0) {
                responseR.setResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.");
                responseR.setListProductVectorial(new ArrayList());
            } else {
                ArrayList<ProductVectorial> newLisstSecciones = new ArrayList<ProductVectorial>();
                ProductVectorial productVectorial = secciones.get(0);
                newLisstSecciones.add(productVectorial);
                responseR.setResponse(resultadoBusqueda.toString());
                responseR.setListProductVectorial(newLisstSecciones);
            }
            return responseR;
        }
        catch (Exception e) {
            log.info("Error al obtener lista de productos o producto:" + e.getMessage());
            return this.utilLhia.createDefaultResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.");
        }
    }
}

