/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.UtilLhia;
import ec.tws2.back.lhia.marcimex.infrastructure.client.OpenAiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.LhiaRepository;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ConversacionDetalle;
import ec.tws2.back.lhia.marcimex.models.request.QuestionFlowRequest;
import ec.tws2.back.lhia.marcimex.models.response.OpenAiResponse;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class LhiaRepositoryImpl
implements LhiaRepository {
    @Autowired
    private OpenAiClient openAiClient;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);

    public ResponseEntity<?> getQuestionFlow(QuestionFlowRequest request) {
        Optional conversationOpt = this.conversacionDAO.findById((Object)request.getIdConversation());
        if (conversationOpt.isEmpty()) {
            return TransactionCustom.ok(Map.of("value", ""));
        }
        String inputMessage = request.getQuestionMessage();
        String fullPrompt = this.buildPrompt(inputMessage);
        OpenAiResponse aiResponse = this.openAiClient.getChatResponse(fullPrompt, 150);
        String responseText = this.extractResponse(aiResponse);
        if (responseText == null || responseText.isBlank()) {
            return TransactionCustom.error((String)"Error response model.");
        }
        this.saveConversationDetail((Conversacion)conversationOpt.get(), inputMessage, fullPrompt, responseText);
        return TransactionCustom.ok(Map.of("value", responseText));
    }

    private String buildPrompt(String message) {
        return String.format("%s%n%nEntrada: \"%s\"%nSalida:", "\tEres un asistente especializado en la gesti\u00f3n de flujos conversacionales.\n\tAnaliza la entrada del usuario y devuelve la categor\u00eda m\u00e1s adecuada seg\u00fan las siguientes reglas:\n\tIgnora may\u00fasculas, min\u00fasculas y tildes al comparar.\n\tSi la entrada contiene palabras clave de una categor\u00eda, devuelve esa categor\u00eda inmediatamente sin analizar otras.\n\tElige la primera coincidencia en orden de prioridad.\n\tSi la entrada no coincide con ninguna categor\u00eda, responde \"menu\".\n\tLista de categor\u00edas en orden de prioridad:\n\tcustomer_advisor \u2192 (\"asesor\", \"atenci\u00f3n al cliente\", \"comprar a cr\u00e9dito\", \"credito\")\n\tcheck_balance \u2192 (\"saldo de cr\u00e9dito\", \"consultar saldo\", \"mi saldo disponible\")\n\ttechnical_service \u2192 (\"instalaci\u00f3n de servicio t\u00e9cnico\", \"fallo t\u00e9cnico\", \"asistencia t\u00e9cnica\")\n\tpromos \u2192 (\"promociones\", \"mejores ofertas\", \"descuentos disponibles\")\n\tmenu \u2192 (Si no coincide con ninguna categor\u00eda)\n\tReglas adicionales:\n\tSi una entrada coincide con varias categor\u00edas, elige la primera de la lista.\n\tDevuelve \u00fanicamente la categor\u00eda en min\u00fasculas, sin explicaciones adicionales.\n", message);
    }

    private String extractResponse(OpenAiResponse response) {
        if (response == null || response.getChoices().isEmpty()) {
            return null;
        }
        OpenAiResponse.Message message = ((OpenAiResponse.Choice)response.getChoices().get(0)).getMessage();
        return message != null ? message.getContent() : null;
    }

    private void saveConversationDetail(Conversacion conversacion, String inputMessage, String prompt, String responseText) {
        String fullMessage = prompt + responseText;
        int tokens = this.encoding.countTokens("Entrada: \"" + inputMessage + "\"\nSalida:" + responseText);
        ConversacionDetalle detalle = new ConversacionDetalle();
        detalle.setRol("system");
        detalle.setMensaje(fullMessage);
        detalle.setScore(0.0);
        detalle.setTokens(tokens);
        detalle.setId_conversacion(conversacion);
        detalle.setFecha(new UtilLhia().fechaEcuador());
        detalle.setPregunta("");
        this.conversacionDetalleDAO.save((Object)detalle);
    }
}

