/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.util.VoucherHttpUtils;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ImageRecognitionRepository;
import ec.tws2.back.lhia.marcimex.models.dto.ProcessVoucherDto;
import ec.tws2.back.lhia.marcimex.models.dto.VoucherBankPaymentDto;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ImageRecognitionRepositoryImpl
implements ImageRecognitionRepository {
    private static final Logger log = LoggerFactory.getLogger(ImageRecognitionRepositoryImpl.class);
    @Value(value="${openai.urlAnswer4}")
    private String urlAnswer4;
    @Value(value="${openai.modelAnswer4}")
    private String modelAnswer4;
    @Value(value="${openai.apiKey}")
    private String apiKey;

    public Optional<ProcessVoucherDto> checkImageDocumentPrompt(String urlImage, VoucherBankPaymentDto voucher, String customPrompt) {
        HttpHeaders headers = VoucherHttpUtils.createHeaders((String)this.apiKey);
        Map requestBody = VoucherHttpUtils.createRequestBodyCustomPrompt((String)urlImage, (String)this.modelAnswer4, (int)700, (String)customPrompt);
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(this.urlAnswer4, HttpMethod.POST, entity, String.class, new Object[0]);
            if (!VoucherHttpUtils.isJsonResponse((ResponseEntity)response)) {
                log.error("Error: Response is not JSON");
                return Optional.empty();
            }
            return Optional.of(VoucherHttpUtils.processResponse((String)((String)response.getBody())));
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            log.error("HTTP error: {} - {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            log.debug("Request Body: {}", entity.getBody());
        }
        catch (Exception e) {
            log.error("General error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Optional.empty();
    }
}

