/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.FileUtils;
import ec.tws2.back.lhia.marcimex.common.util.SecurityUtils;
import ec.tws2.back.lhia.marcimex.common.util.VoucherHttpUtils;
import ec.tws2.back.lhia.marcimex.infrastructure.client.FileApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ImageDescriptionRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.WhatsappRepository;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.WhatsappDTO;
import ec.tws2.back.lhia.marcimex.models.request.FileUploadRequest;
import ec.tws2.back.lhia.marcimex.models.request.ImageDescriptionRequest;
import ec.tws2.back.lhia.marcimex.models.response.FileUploadResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ImageDescriptionRepositoryImpl
implements ImageDescriptionRepository {
    private static final Logger log = LoggerFactory.getLogger(ImageDescriptionRepositoryImpl.class);
    private static final String PROMPT_DESCRIBE_IMAGE = "Identifica el producto principal en la imagen.\n\nDevuelve \u00fanicamente en este formato exacto:\n\nNombre del producto\ncaracter\u00edstica 1, caracter\u00edstica 2, caracter\u00edstica 3\n\nNo agregues explicaciones, t\u00edtulos ni texto adicional.\n";
    @Value(value="${openai.urlAnswer4}")
    private String urlAnswer4;
    @Value(value="${openai.modelAnswer4}")
    private String modelAnswer4;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Autowired
    private WhatsappRepository whatsappRepository;
    @Autowired
    private FileApiClient fileApiClient;

    public ResponseEntity<ResponseResult<?>> describeImage(ImageDescriptionRequest request, BindingResult resultBinding) {
        if (resultBinding.hasErrors()) {
            return TransactionCustom.errorFields((BindingResult)resultBinding);
        }
        log.info("Descargando imagen desde WhatsApp: {}", (Object)request.getImageUrl());
        Optional responseWhatsapp = this.whatsappRepository.downloadImageAndConvertToBase64(request.getImageUrl());
        if (!responseWhatsapp.isPresent()) {
            log.error("Error al descargar la imagen desde WhatsApp");
            return TransactionCustom.error((String)"Error al descargar la imagen desde WhatsApp");
        }
        log.info("Subiendo imagen al servidor de archivos...");
        FileUploadResponse.FilePayload filePayload = this.uploadImage(FileUtils.toBase64String((byte[])((WhatsappDTO)responseWhatsapp.get()).getFileContentBytes()));
        if (filePayload == null) {
            log.error("Error al guardar la imagen en el servidor");
            return TransactionCustom.error((String)"Error al guardar la imagen en el servidor");
        }
        log.info("Imagen subida correctamente, path p\u00fablico: {}", (Object)filePayload.getPath());
        log.info("Analizando imagen con OpenAI...");
        HttpHeaders headers = VoucherHttpUtils.createHeaders((String)this.apiKey);
        Map requestBody = this.buildRequestBody(filePayload.getPath());
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(this.urlAnswer4, HttpMethod.POST, entity, String.class, new Object[0]);
            if (!VoucherHttpUtils.isJsonResponse((ResponseEntity)response)) {
                log.error("La respuesta de OpenAI no es JSON");
                return TransactionCustom.error((String)"Error al procesar la respuesta de OpenAI");
            }
            String description = this.extractContent((String)response.getBody());
            log.info("Descripci\u00f3n obtenida correctamente");
            return TransactionCustom.ok((String)"Imagen analizada correctamente", (Object)description);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            log.error("Error HTTP al llamar a OpenAI: {} - {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return TransactionCustom.error((String)("Error al comunicarse con OpenAI: " + String.valueOf(e.getStatusCode())));
        }
        catch (Exception e) {
            log.error("Error general al analizar la imagen: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error((String)"Error inesperado al analizar la imagen");
        }
    }

    private FileUploadResponse.FilePayload uploadImage(String imageBase64) {
        try {
            String tokenHttp = SecurityUtils.extractToken();
            FileUploadRequest uploadRequest = new FileUploadRequest();
            uploadRequest.setContentType("png");
            uploadRequest.setFolder("VOUCHER");
            uploadRequest.setBase64(imageBase64);
            ResponseEntity dataResponse = this.fileApiClient.uploadFile(uploadRequest, tokenHttp);
            if (dataResponse.getStatusCode().value() == 200) {
                return ((FileUploadResponse)dataResponse.getBody()).getPayload();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error al subir imagen al servidor: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Map<String, Object> buildRequestBody(String imageUrl) {
        Map<String, String> textPart = Map.of("type", "text", "text", PROMPT_DESCRIBE_IMAGE.trim());
        Map<String, Map<String, String>> imagePart = Map.of("type", "image_url", "image_url", Map.of("url", imageUrl));
        Map<String, List<Map>> userMessage = Map.of("role", "user", "content", Arrays.asList(textPart, imagePart));
        return Map.of("model", this.modelAnswer4, "messages", Collections.singletonList(userMessage), "max_tokens", 700);
    }

    private String extractContent(String responseBody) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(responseBody);
            return rootNode.path("choices").get(0).path("message").path("content").asText();
        }
        catch (Exception e) {
            log.error("Error al parsear la respuesta de OpenAI: {}", (Object)e.getMessage());
            return "No se pudo extraer la descripci\u00f3n de la respuesta";
        }
    }
}

