/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.FileUtils;
import ec.tws2.back.lhia.marcimex.common.util.MarkdownUtil;
import ec.tws2.back.lhia.marcimex.common.util.SecurityUtils;
import ec.tws2.back.lhia.marcimex.infrastructure.client.ConversationApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.client.FileApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.client.MetaApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.HistoryConversationRepository;
import ec.tws2.back.lhia.marcimex.models.dto.MetaDTO;
import ec.tws2.back.lhia.marcimex.models.request.FileUploadRequest;
import ec.tws2.back.lhia.marcimex.models.request.HistoryConversationBotRequest;
import ec.tws2.back.lhia.marcimex.models.request.HistoryConversationRequest;
import ec.tws2.back.lhia.marcimex.models.response.FileUploadResponse;
import ec.tws2.back.lhia.marcimex.models.response.MetaAttachmentResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class HistoryConversationRepositoryImpl
implements HistoryConversationRepository {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationRepositoryImpl.class);
    private MetaApiClient metaApiClient;
    private FileApiClient fileApiClient;
    private ConversationApiClient conversationApiClient;

    public void processExportConversation(String idPlatform, String platform, String nick, String rol, String typeMode, List<HistoryConversationBotRequest> listData) {
        HistoryConversationRequest historyConversationRequest = this.parseHistoryConversationRequest(idPlatform, platform, nick, listData);
        this.conversationApiClient.exportConversacion(historyConversationRequest);
    }

    public ResponseEntity<?> exportConversationDownloadMetaFile(HistoryConversationBotRequest request) {
        try {
            String midId = (String)FileUtils.getMidOfPath((String)request.getUrlFile()).orElseThrow(() -> new IllegalArgumentException("URL no contiene mid v\u00e1lido"));
            MetaAttachmentResponse attachment = (MetaAttachmentResponse)this.metaApiClient.getMetaAttachment(midId).orElseThrow(() -> new IllegalStateException("No se pudo obtener attachment desde Meta"));
            MetaDTO metaDto = (MetaDTO)this.metaApiClient.downloadFileAndConvertToBase64(attachment.getUrl()).orElseThrow(() -> new IllegalStateException("No se pudo descargar ni convertir el archivo"));
            FileUploadResponse.FilePayload filePayload = (FileUploadResponse.FilePayload)this.getFileMetaPayload(metaDto.getContentType(), metaDto.getFileContentBase64()).orElseThrow(() -> new IllegalStateException("No se pudo generar el FilePayload"));
            HistoryConversationBotRequest historyItem = this.buildHistoryItem(request, filePayload);
            HistoryConversationRequest historyConversationRequest = this.parseHistoryConversationRequest(request.getIdPlatform(), request.getPlatform(), request.getNick(), List.of(historyItem));
            log.info("Exportando conversaci\u00f3n con data: {}", (Object)historyConversationRequest);
            return this.conversationApiClient.exportConversacion(historyConversationRequest) ? TransactionCustom.ok((Object)historyConversationRequest) : TransactionCustom.error((String)"Error al exportar la conversaci\u00f3n.");
        }
        catch (Exception e) {
            log.error("Fallo al exportar la conversaci\u00f3n: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error((String)("Excepci\u00f3n en exportaci\u00f3n: " + e.getMessage()));
        }
    }

    private HistoryConversationBotRequest buildHistoryItem(HistoryConversationBotRequest request, FileUploadResponse.FilePayload filePayload) {
        HistoryConversationBotRequest historyItem = new HistoryConversationBotRequest();
        historyItem.setIdPlatform(request.getIdPlatform());
        historyItem.setPlatform(request.getPlatform());
        historyItem.setNick(request.getNick());
        historyItem.setType(request.getType());
        historyItem.setMessage(request.getMessage());
        historyItem.setUrlFile(filePayload.getPath());
        historyItem.setCreatedAt(request.getCreatedAt());
        return historyItem;
    }

    private Optional<FileUploadResponse.FilePayload> getFileMetaPayload(String contentType, String imageBase64) {
        try {
            String tokenHttp = SecurityUtils.extractToken();
            FileUploadRequest request = new FileUploadRequest();
            request.setContentType(contentType);
            request.setFolder("FILE_BOT");
            request.setBase64(imageBase64);
            ResponseEntity dataResponse = this.fileApiClient.uploadFile(request, tokenHttp);
            if (dataResponse.getStatusCode().value() == 200) {
                return Optional.of(((FileUploadResponse)dataResponse.getBody()).getPayload());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public ResponseEntity<?> exportConversationDownloadFile(HistoryConversationBotRequest request) {
        boolean processed = this.processConversationItem(request);
        if (processed) {
            HistoryConversationRequest historyConversationRequest = this.parseHistoryConversationRequest(request.getIdPlatform(), request.getPlatform(), request.getNick(), List.of(request));
            return this.conversationApiClient.exportConversacion(historyConversationRequest) ? TransactionCustom.ok((Object)historyConversationRequest) : TransactionCustom.error((String)"Error al exportar la conversaci\u00f3n.");
        }
        return TransactionCustom.error((String)"No se pudo procesar el archivo");
    }

    private boolean processConversationItem(HistoryConversationBotRequest request) {
        String url = request.getUrlFile();
        return this.metaApiClient.downloadFileAndConvertToBase64(url).flatMap(metaDTO -> this.getFilePayload(metaDTO.getFileContentBase64())).map(filePayload -> {
            request.setUrlFile(filePayload.getPath());
            return true;
        }).orElseGet(() -> {
            log.warn("\u26a0\ufe0f No se pudo procesar archivo desde la URL: {}", (Object)url);
            return false;
        });
    }

    private Optional<FileUploadResponse.FilePayload> getFilePayload(String imageBase64) {
        try {
            String tokenHttp = SecurityUtils.extractToken();
            FileUploadRequest request = new FileUploadRequest();
            request.setContentType("png");
            request.setFolder("FILE_BOT");
            request.setBase64(imageBase64);
            ResponseEntity dataResponse = this.fileApiClient.uploadFile(request, tokenHttp);
            if (dataResponse.getStatusCode().value() == 200) {
                return Optional.of(((FileUploadResponse)dataResponse.getBody()).getPayload());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private HistoryConversationRequest parseHistoryConversationRequest(String idPlatform, String platform, String nick, List<HistoryConversationBotRequest> listData) {
        HistoryConversationRequest request = new HistoryConversationRequest();
        HistoryConversationRequest.HistoryConversation conversation = new HistoryConversationRequest.HistoryConversation();
        conversation.setIdPlatform(idPlatform);
        conversation.setPlatform(platform);
        conversation.setNick(nick);
        ArrayList items = new ArrayList();
        listData.forEach(element -> {
            String messageItemUrl = "";
            messageItemUrl = "image".equals(element.getType()) ? MarkdownUtil.generateMarkdownImage((String)element.getMessage(), (String)element.getUrlFile()) : element.getUrlFile();
            HistoryConversationRequest.HistoryConversationItem item = new HistoryConversationRequest.HistoryConversationItem();
            item.setIdPlatform(idPlatform);
            item.setPlatform(platform);
            item.setNick(nick);
            item.setMessage(messageItemUrl);
            item.setType(element.getType());
            item.setRol("USER");
            item.setMessageTypeMode("BOT");
            item.setCreatedAt(element.getCreatedAt());
            items.add(item);
        });
        request.setConversation(conversation);
        request.setItems(items);
        return request;
    }

    public HistoryConversationRepositoryImpl(MetaApiClient metaApiClient, FileApiClient fileApiClient, ConversationApiClient conversationApiClient) {
        this.metaApiClient = metaApiClient;
        this.fileApiClient = fileApiClient;
        this.conversationApiClient = conversationApiClient;
    }
}

