/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.marcimex.common.util.UtilEmail;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.EmailRepository;
import ec.tws2.back.lhia.marcimex.models.data.EmailVoucher;
import ec.tws2.back.lhia.marcimex.models.data.KeyCloak;
import ec.tws2.back.lhia.marcimex.models.dto.BankTransferDto;
import ec.tws2.back.lhia.marcimex.models.dto.VoucherBankPaymentDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EmailRepositoryImpl
implements EmailRepository {
    @Value(value="${endpoint.admin.email_api}")
    private String adminEmailServerApi;
    @Value(value="${endpoint.admin.email_token}")
    private String adminEmailServerToken;
    @Value(value="${property.server.email_username}")
    private String adminEmailUsername;
    @Value(value="${property.server.email_password}")
    private String adminEmailPassword;
    @Value(value="${property.server.email_client_id}")
    private String adminEmailClientId;
    @Value(value="${property.server.email_grant_type}")
    private String adminEmailGrantType;
    @Value(value="${property.server.user_email}")
    private String adminUserEmail;
    @Value(value="${property.server.email_code_email}")
    private String adminEmailCodeEmail;
    @Autowired
    RestTemplate restTemplate;

    public String getTokenAdminEmail() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.adminEmailClientId);
        map.add((Object)"username", (Object)this.adminEmailUsername);
        map.add((Object)"grant_type", (Object)this.adminEmailGrantType);
        map.add((Object)"password", (Object)this.adminEmailPassword);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity answer = this.restTemplate.exchange(this.adminEmailServerToken, HttpMethod.POST, entity, KeyCloak.class, new Object[0]);
        return ((KeyCloak)answer.getBody()).getAccess_token();
    }

    public boolean sendEmailBank(VoucherBankPaymentDto voucherBankPaymentDto, BankTransferDto bankTransferDto, String fileBase64, List<String> emailList, String urlImage) throws Exception {
        String tokenAdminEmail = this.getTokenAdminEmail();
        EmailVoucher emailVoucher = UtilEmail.createEmailVoucherBank((VoucherBankPaymentDto)voucherBankPaymentDto, (BankTransferDto)bankTransferDto, (String)fileBase64, (String)this.adminEmailCodeEmail, emailList, (String)urlImage);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(tokenAdminEmail);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonEmailModel = objectMapper.writeValueAsString((Object)emailVoucher);
        HttpEntity request = new HttpEntity((Object)jsonEmailModel, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.adminEmailServerApi, (Object)request, Object.class, new Object[0]);
        System.out.println(response.getStatusCode());
        return response.getStatusCode() == HttpStatus.OK;
    }
}

